/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4C8TTILob;
import oracle.jdbc.driver.T4CConnection;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NCLOB;

final class T4C8TTIClob
extends T4C8TTILob {
    int[] nBytes = new int[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4C8TTIClob(T4CConnection _conn) {
        super(_conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long read(byte[] lobLocator, long offset, long numChars, boolean isNCLOB, char[] charOutBuffer, int _offsetInOutBuffer) throws SQLException, IOException {
        long bytesRead = 0L;
        long charsRead = numChars;
        boolean varWidthChar = false;
        byte[] myBuffer = null;
        try {
            this.initializeLobdef();
            if ((lobLocator[6] & 0x80) == 128) {
                varWidthChar = true;
            }
            int bufferSizeNeeded = 0;
            bufferSizeNeeded = varWidthChar ? (int)numChars * 2 : (int)numChars * 3;
            myBuffer = this.connection.getByteBuffer(bufferSizeNeeded);
            if ((lobLocator[7] & 0x40) > 0) {
                this.littleEndianClob = true;
            }
            this.lobops = 2L;
            this.sourceLobLocator = lobLocator;
            this.sourceOffset = offset;
            this.lobamt = numChars;
            this.sendLobamt = true;
            this.outBuffer = myBuffer;
            this.doRPC();
            charsRead = this.lobamt;
            long bytesConverted = 0L;
            if (varWidthChar) {
                if (this.connection.versionNumber < 10101) {
                    DBConversion cfr_ignored_0 = this.meg.conv;
                    DBConversion.ucs2BytesToJavaChars(this.outBuffer, (int)this.lobBytesRead, charOutBuffer);
                } else if (this.littleEndianClob) {
                    CharacterSet.convertAL16UTF16LEBytesToJavaChars(this.outBuffer, 0, charOutBuffer, _offsetInOutBuffer, (int)this.lobBytesRead, true);
                } else {
                    CharacterSet.convertAL16UTF16BytesToJavaChars(this.outBuffer, 0, charOutBuffer, _offsetInOutBuffer, (int)this.lobBytesRead, true);
                }
            } else if (!isNCLOB) {
                this.nBytes[0] = (int)this.lobBytesRead;
                this.meg.conv.CHARBytesToJavaChars(this.outBuffer, 0, charOutBuffer, _offsetInOutBuffer, this.nBytes, charOutBuffer.length);
            } else {
                this.nBytes[0] = (int)this.lobBytesRead;
                this.meg.conv.NCHARBytesToJavaChars(this.outBuffer, 0, charOutBuffer, _offsetInOutBuffer, this.nBytes, charOutBuffer.length);
            }
            this.outBuffer = null;
        }
        catch (Throwable throwable) {
            this.outBuffer = null;
            this.connection.cacheBuffer(myBuffer);
            throw throwable;
        }
        this.connection.cacheBuffer(myBuffer);
        return charsRead;
    }

    long write(byte[] lobLocator, long offset, boolean isNCLOB, char[] _inBuffer, long offsetInBuffer, long numChars) throws SQLException, IOException {
        boolean varWidthChar = false;
        if ((lobLocator[6] & 0x80) == 128) {
            varWidthChar = true;
        }
        if ((lobLocator[7] & 0x40) == 64) {
            this.littleEndianClob = true;
        }
        long bytesConverted = 0L;
        byte[] myBuffer = null;
        if (varWidthChar) {
            myBuffer = new byte[(int)numChars * 2];
            if (this.connection.versionNumber < 10101) {
                DBConversion cfr_ignored_0 = this.meg.conv;
                DBConversion.javaCharsToUcs2Bytes(_inBuffer, (int)offsetInBuffer, myBuffer, 0, (int)numChars);
            } else if (this.littleEndianClob) {
                CharacterSet.convertJavaCharsToAL16UTF16LEBytes(_inBuffer, (int)offsetInBuffer, myBuffer, 0, (int)numChars);
            } else {
                CharacterSet.convertJavaCharsToAL16UTF16Bytes(_inBuffer, (int)offsetInBuffer, myBuffer, 0, (int)numChars);
            }
        } else {
            myBuffer = new byte[(int)numChars * 3];
            bytesConverted = !isNCLOB ? (long)this.meg.conv.javaCharsToCHARBytes(_inBuffer, (int)offsetInBuffer, myBuffer, 0, (int)numChars) : (long)this.meg.conv.javaCharsToNCHARBytes(_inBuffer, (int)offsetInBuffer, myBuffer, 0, (int)numChars);
        }
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = lobLocator;
        this.sourceOffset = offset;
        this.lobamt = numChars;
        this.sendLobamt = true;
        this.inBuffer = myBuffer;
        this.inBufferOffset = 0L;
        this.inBufferNumBytes = varWidthChar ? (this.connection.versionNumber < 10101 ? numChars : numChars * 2L) : bytesConverted;
        this.doRPC();
        long charsWritten = this.lobamt;
        return charsWritten;
    }

    @Override
    Datum createTemporaryLob(Connection conn, boolean cache, int duration) throws SQLException, IOException {
        return this.createTemporaryLob(conn, cache, duration, (short)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datum createTemporaryLob(Connection conn, boolean cache, int duration, short form_of_use) throws SQLException, IOException {
        if (duration == 12) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4C8TTIClob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 158);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 158);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        CLOB clob = null;
        this.initializeLobdef();
        this.lobops = 272L;
        this.sourceLobLocator = new byte[40];
        this.sourceLobLocator[1] = 84;
        this.sourceOffset = form_of_use == 1 ? 1L : 2L;
        this.destinationOffset = 112L;
        this.destinationLength = duration;
        this.lobamt = duration;
        this.sendLobamt = true;
        this.nullO2U = true;
        short s2 = this.characterSet = form_of_use == 2 ? this.meg.conv.getNCharSetId() : this.meg.conv.getServerCharSetId();
        if (this.connection.versionNumber >= 9000) {
            this.lobscn = new int[1];
            this.lobscn[0] = cache ? 1 : 0;
            this.lobscnl = 1;
        }
        this.doRPC();
        if (this.sourceLobLocator != null) {
            clob = form_of_use == 1 ? new CLOB((OracleConnection)conn, this.sourceLobLocator) : new NCLOB((OracleConnection)conn, this.sourceLobLocator);
        }
        return clob;
    }

    @Override
    boolean open(byte[] lobLocator, int mode) throws SQLException, IOException {
        boolean wasOpened = false;
        int kokl_mode = 2;
        if (mode == 0) {
            kokl_mode = 1;
        }
        wasOpened = this._open(lobLocator, kokl_mode, 32768);
        return wasOpened;
    }

    @Override
    boolean close(byte[] lobLocator) throws SQLException, IOException {
        boolean wasClosed = false;
        wasClosed = this._close(lobLocator, 65536);
        return wasClosed;
    }

    @Override
    boolean isOpen(byte[] lobLocator) throws SQLException, IOException {
        boolean open = false;
        open = this._isOpen(lobLocator, 69632);
        return open;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4C8TTIClob"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

