/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;

final class T4C7Oversion
extends T4CTTIfun {
    byte[] rdbmsVersion = new byte[]{78, 111, 116, 32, 100, 101, 116, 101, 114, 109, 105, 110, 101, 100, 32, 121, 101, 116};
    private final boolean rdbmsVersionO2U = true;
    private final int bufLen = 256;
    private final boolean retVerLenO2U = true;
    int retVerLen = 0;
    private final boolean retVerNumO2U = true;
    long retVerNum = 0L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4C7Oversion(T4CConnection _connection) {
        super(_connection, (byte)3);
        this.setFunCode((short)59);
    }

    void doOVERSION() throws SQLException, IOException {
        this.doRPC();
    }

    @Override
    void readRPA() throws IOException, SQLException {
        this.retVerLen = this.meg.unmarshalUB2();
        this.rdbmsVersion = this.meg.unmarshalCHR(this.retVerLen);
        this.retVerNum = this.meg.unmarshalUB4();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void processRPA() throws SQLException {
        if (this.rdbmsVersion == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4C7Oversion.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 438);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
    }

    byte[] getVersion() {
        return this.rdbmsVersion;
    }

    short getVersionNumber() {
        int ver = 0;
        ver = (int)((long)ver + (this.retVerNum >>> 24 & 0xFFL) * 1000L);
        ver = (int)((long)ver + (this.retVerNum >>> 20 & 0xFL) * 100L);
        ver = (int)((long)ver + (this.retVerNum >>> 12 & 0xFL) * 10L);
        ver = (int)((long)ver + (this.retVerNum >>> 8 & 0xFL));
        return (short)ver;
    }

    long getVersionNumberasIs() {
        return this.retVerNum;
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalO2U(true);
        this.meg.marshalSWORD(256);
        this.meg.marshalO2U(true);
        this.meg.marshalO2U(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4C7Oversion.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4C7Oversion.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4C7Oversion.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4C7Oversion"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

