/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleNClob;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OracleRef;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeRAW;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.StructDescriptor;

class StructMetaData
implements oracle.jdbc.internal.StructMetaData {
    StructDescriptor descriptor;
    OracleTypeADT otype;
    OracleType[] types;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructMetaData(StructDescriptor desc) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(desc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (desc == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructMetaData.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "illegal operation: descriptor is null");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "illegal operation: descriptor is null");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.descriptor = desc;
            this.otype = desc.getOracleTypeADT();
            this.types = this.otype.getAttrTypes();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnCount() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.types.length);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.types.length;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSearchable(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleResultSetMetaData.SecurityAttribute getSecurityAttribute(int column) throws SQLException {
        OracleResultSetMetaData.SecurityAttribute securityAttribute;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)OracleResultSetMetaData.SecurityAttribute.NONE));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            securityAttribute = OracleResultSetMetaData.SecurityAttribute.NONE;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructMetaData.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return securityAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurrency(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int idx = this.getValidColumnIndex(column);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (this.types[idx] instanceof OracleTypeNUMBER || this.types[idx] instanceof OracleTypeFLOAT));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.types[idx] instanceof OracleTypeNUMBER || this.types[idx] instanceof OracleTypeFLOAT;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int idx = this.getValidColumnIndex(column);
            boolean __result__ = this.types[idx] instanceof OracleTypeCHAR;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int isNullable(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = 1;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSigned(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int idx;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.types[idx = this.getValidColumnIndex(column)] instanceof OracleTypeCHAR) {
                int __result__ = ((OracleTypeCHAR)this.types[idx]).getLength();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = __result__;
                return n2;
            }
            if (this.types[idx] instanceof OracleTypeRAW) {
                int __result__ = ((OracleTypeRAW)this.types[idx]).getLength();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = __result__;
                return n3;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n4 = 0;
            return n4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnLabel(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String __result__ = this.getColumnName(column);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnName(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String __result__ = this.otype.getAttributeName(column);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchemaName(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int idx;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.types[idx = this.getValidColumnIndex(column)] instanceof OracleTypeADT) {
                String __result__ = ((OracleTypeADT)this.types[idx]).getSchemaName();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = __result__;
                return string;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = "";
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPrecision(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int idx = this.getValidColumnIndex(column);
            int __result__ = this.types[idx].getPrecision();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScale(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int idx = this.getValidColumnIndex(column);
            int __result__ = this.types[idx].getScale();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTableName(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalogName(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnType(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int idx = this.getValidColumnIndex(column);
            int __result__ = this.types[idx].getTypeCode();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnTypeName(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int type = this.getColumnType(column);
            int idx = this.getValidColumnIndex(column);
            switch (type) {
                case 12: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "VARCHAR");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "VARCHAR";
                    return string;
                }
                case 1: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "CHAR");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "CHAR";
                    return string;
                }
                case -2: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "RAW");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "RAW";
                    return string;
                }
                case 6: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "FLOAT");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "FLOAT";
                    return string;
                }
                case 2: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "NUMBER");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "NUMBER";
                    return string;
                }
                case 8: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "DOUBLE");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "DOUBLE";
                    return string;
                }
                case 3: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "DECIMAL");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "DECIMAL";
                    return string;
                }
                case 100: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "BINARY_FLOAT");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "BINARY_FLOAT";
                    return string;
                }
                case 101: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "BINARY_DOUBLE");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "BINARY_DOUBLE";
                    return string;
                }
                case 91: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "DATE");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "DATE";
                    return string;
                }
                case -104: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "INTERVALDS");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "INTERVALDS";
                    return string;
                }
                case -103: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "INTERVALYM");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "INTERVALYM";
                    return string;
                }
                case 93: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "TIMESTAMP");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "TIMESTAMP";
                    return string;
                }
                case -101: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "TIMESTAMP WITH TIME ZONE");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "TIMESTAMP WITH TIME ZONE";
                    return string;
                }
                case -102: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "TIMESTAMP WITH LOCAL TIME ZONE");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "TIMESTAMP WITH LOCAL TIME ZONE";
                    return string;
                }
                case 2004: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "BLOB");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "BLOB";
                    return string;
                }
                case 2005: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "CLOB");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "CLOB";
                    return string;
                }
                case -13: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "BFILE");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "BFILE";
                    return string;
                }
                case 2002: 
                case 2003: 
                case 2007: 
                case 2008: {
                    String __result__ = ((OracleTypeADT)this.types[idx]).getFullName();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = __result__;
                    return string;
                }
                case 2006: {
                    String __result__ = "REF " + ((OracleTypeREF)this.types[idx]).getFullName();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = __result__;
                    return string;
                }
                case -15: {
                    String __result__ = "NCHAR";
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = __result__;
                    return string;
                }
                case -9: {
                    String __result__ = "NVARCHAR";
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = __result__;
                    return string;
                }
                case 2011: {
                    String __result__ = "NCLOB";
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = __result__;
                    return string;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWritable(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnClassName(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int type = this.getColumnType(column);
            switch (type) {
                case -15: 
                case -9: 
                case 1: 
                case 12: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "java.lang.String");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "java.lang.String";
                    return string;
                }
                case -2: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "byte[]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "byte[]";
                    return string;
                }
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "java.math.BigDecimal");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "java.math.BigDecimal";
                    return string;
                }
                case 91: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "java.sql.Timestamp");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "java.sql.Timestamp";
                    return string;
                }
                case -103: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "oracle.sql.INTERVALYM");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "oracle.sql.INTERVALYM";
                    return string;
                }
                case -104: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "oracle.sql.INTERVALDS");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "oracle.sql.INTERVALDS";
                    return string;
                }
                case 93: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "oracle.sql.TIMESTAMP");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "oracle.sql.TIMESTAMP";
                    return string;
                }
                case -101: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "oracle.sql.TIMESTAMPTZ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "oracle.sql.TIMESTAMPTZ";
                    return string;
                }
                case -102: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "oracle.sql.TIMESTAMPLTZ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "oracle.sql.TIMESTAMPLTZ";
                    return string;
                }
                case 2004: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleBlob.class.getName());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = OracleBlob.class.getName();
                    return string;
                }
                case 2005: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleClob.class.getName());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = OracleClob.class.getName();
                    return string;
                }
                case 2011: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleNClob.class.getName());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = OracleNClob.class.getName();
                    return string;
                }
                case -13: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleBfile.class.getName());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = OracleBfile.class.getName();
                    return string;
                }
                case 2002: 
                case 2008: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleStruct.class.getName());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = OracleStruct.class.getName();
                    return string;
                }
                case 2007: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleOpaque.class.getName());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = OracleOpaque.class.getName();
                    return string;
                }
                case 2003: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleArray.class.getName());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = OracleArray.class.getName();
                    return string;
                }
                case 2006: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + OracleRef.class.getName());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = OracleRef.class.getName();
                    return string;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOracleColumnClassName(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int type = this.getColumnType(column);
            switch (type) {
                case -15: 
                case -9: 
                case 1: 
                case 12: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "CHAR");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "CHAR";
                    return string;
                }
                case -2: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "RAW");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "RAW";
                    return string;
                }
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "NUMBER");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "NUMBER";
                    return string;
                }
                case 91: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "DATE");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "DATE";
                    return string;
                }
                case -103: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "INTERVALYM");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "INTERVALYM";
                    return string;
                }
                case -104: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "INTERVALDS");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "INTERVALDS";
                    return string;
                }
                case 93: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "TIMESTAMP");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "TIMESTAMP";
                    return string;
                }
                case -101: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "TIMESTAMPTZ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "TIMESTAMPTZ";
                    return string;
                }
                case -102: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "TIMESTAMPLTZ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "TIMESTAMPLTZ";
                    return string;
                }
                case 2004: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "BLOB");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "BLOB";
                    return string;
                }
                case 2005: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "CLOB");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "CLOB";
                    return string;
                }
                case 2011: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "NCLOB");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "NCLOB";
                    return string;
                }
                case -13: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "BFILE");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "BFILE";
                    return string;
                }
                case 2002: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "STRUCT");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "STRUCT";
                    return string;
                }
                case 2008: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "JAVA_STRUCT");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "JAVA_STRUCT";
                    return string;
                }
                case 2007: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "OPAQUE");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "OPAQUE";
                    return string;
                }
                case 2003: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "ARRAY");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "ARRAY";
                    return string;
                }
                case 2006: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "REF");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "REF";
                    return string;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLocalColumnCount() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = this.descriptor.getLocalAttributeCount();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInherited(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = column <= this.getColumnCount() - this.getLocalColumnCount();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttributeJavaName(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int idx = this.getValidColumnIndex(column);
            String __result__ = this.descriptor.getAttributeJavaName(idx);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getValidColumnIndex(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int index;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((index = column - 1) < 0 || index >= this.types.length) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructMetaData.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + "getValidColumnIndex");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getValidColumnIndex");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + index);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = index;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNCHAR(int column) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int idx = this.getValidColumnIndex(column);
            boolean __result__ = this.types[idx].isNCHAR();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        block24: {
            boolean bl;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructMetaData.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(iface));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!iface.isInterface()) break block24;
                boolean __result__ = iface.isInstance(this);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructMetaData.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructMetaData.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructMetaData.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 177);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        block24: {
            StructMetaData structMetaData;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructMetaData.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(iface));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!iface.isInterface() || !iface.isInstance(this)) break block24;
                StructMetaData __result__ = this;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructMetaData.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                structMetaData = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructMetaData.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return (T)structMetaData;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                StructMetaData.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 177);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructMetaData.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.StructMetaData"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

