/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.ROWID;

class RowidAccessor
extends Accessor {
    static final int maxLength = 128;
    static final int EXTENDED_ROWID_MAX_LENGTH = 18;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowidAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.init(stmt, 104, 9, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowidAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.init(stmt, 104, 9, form, false);
            this.initForDescribe(104, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            this.internalTypeMaxLength = 128;
            this.byteLength = this.internalTypeMaxLength + 2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getString(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RowidAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                int off = this.columnIndex + this.byteLength * currentRow;
                short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
                result = new String(this.rowSpaceByte, off + 2, (int)len);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = result;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ROWID __result__ = this.getROWID(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ROWID rOWID = __result__;
            return rOWID;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ROWID __result__ = this.getROWID(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ROWID rOWID = __result__;
            return rOWID;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ROWID getROWID(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            byte[] b2;
            ROWID __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ROWID rOWID = __result__ = (b2 = this.getBytes(currentRow)) == null ? null : new ROWID(b2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ROWID rOWID2 = __result__;
            return rOWID2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    byte[] getBytes(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RowidAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
                int off = this.columnIndex + this.byteLength * currentRow;
                result = new byte[len];
                System.arraycopy(this.rowSpaceByte, off + 2, result, 0, len);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow, Map map) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ROWID __result__ = this.getROWID(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ROWID rOWID = __result__;
            return rOWID;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.RowidAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

