/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.driver.SensitiveScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.OracleConnection;

class ResultSetUtil {
    static final int[][] allRsetTypes = new int[][]{{0, 0}, {1003, 1007}, {1003, 1008}, {1004, 1007}, {1004, 1008}, {1005, 1007}, {1005, 1008}};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    ResultSetUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OracleResultSet createScrollResultSet(ScrollRsetStatement owner, OracleResultSet referencedRset, int rsetType) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(owner) + ", " + OracleLog.argument(referencedRset) + ", " + OracleLog.argument(rsetType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            switch (rsetType) {
                case 1: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ResultSetUtil.logger().log(Level.FINER, "         Return: " + referencedRset);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    OracleResultSet oracleResultSet = referencedRset;
                    return oracleResultSet;
                }
                case 2: {
                    UpdatableResultSet __result__ = new UpdatableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    UpdatableResultSet updatableResultSet = __result__;
                    return updatableResultSet;
                }
                case 3: {
                    ScrollableResultSet __result__ = new ScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    ScrollableResultSet scrollableResultSet = __result__;
                    return scrollableResultSet;
                }
                case 4: {
                    ScrollableResultSet _rset = new ScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    UpdatableResultSet __result__ = new UpdatableResultSet(owner, _rset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    UpdatableResultSet updatableResultSet = __result__;
                    return updatableResultSet;
                }
                case 5: {
                    SensitiveScrollableResultSet __result__ = new SensitiveScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SensitiveScrollableResultSet sensitiveScrollableResultSet = __result__;
                    return sensitiveScrollableResultSet;
                }
                case 6: {
                    SensitiveScrollableResultSet _rset1 = new SensitiveScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    UpdatableResultSet __result__ = new UpdatableResultSet(owner, _rset1, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    UpdatableResultSet updatableResultSet = __result__;
                    return updatableResultSet;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 23" + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 23, null);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getScrollType(int typeCode) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(typeCode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = allRsetTypes[typeCode][0];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getUpdateConcurrency(int typeCode) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(typeCode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = allRsetTypes[typeCode][1];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getRsetTypeCode(int scrollType, int updateConcurrency) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            for (int i2 = 0; i2 < allRsetTypes.length; ++i2) {
                if (allRsetTypes[i2][0] != scrollType || allRsetTypes[i2][1] != updateConcurrency) continue;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ResultSetUtil.logger().log(Level.FINER, "         Return: " + i2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = i2;
                return n2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 68");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 68);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean needIdentifier(int typeCode) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = typeCode != 1 && typeCode != 3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean needIdentifier(int type, int concur) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean __result__ = ResultSetUtil.needIdentifier(ResultSetUtil.getRsetTypeCode(type, concur));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean needCache(int typeCode) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = typeCode >= 3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean needCache(int type, int concur) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean __result__ = ResultSetUtil.needCache(ResultSetUtil.getRsetTypeCode(type, concur));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean supportRefreshRow(int typeCode) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = typeCode >= 4;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean supportRefreshRow(int type, int concur) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean __result__ = ResultSetUtil.supportRefreshRow(ResultSetUtil.getRsetTypeCode(type, concur));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetUtil.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ResultSetUtil"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

