/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class PlsqlIndexTableAccessor
extends Accessor {
    int elementInternalType;
    int maxNumberOfElements;
    int elementMaxLen;
    int ibtValueIndex;
    int ibtIndicatorIndex;
    int ibtLengthIndex;
    int ibtMetaIndex;
    int ibtByteLength;
    int ibtCharLength;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PlsqlIndexTableAccessor(OracleStatement stmt, int elemSqlType, int elemInternalType, int elemMaxLen, int maxNumOfElements, short form, boolean forBind) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(elemSqlType) + ", " + OracleLog.argument(elemInternalType) + ", " + OracleLog.argument(elemMaxLen) + ", " + OracleLog.argument(maxNumOfElements) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(forBind));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.init(stmt, 998, 998, form, forBind);
            this.elementInternalType = elemInternalType;
            this.maxNumberOfElements = maxNumOfElements;
            this.elementMaxLen = elemMaxLen;
            this.initForDataAccess(elemSqlType, elemMaxLen, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        __ol_nanos__ = 0L;
        try {
            if (PlsqlIndexTableAccessor.TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            switch (this.elementInternalType) {
                case 1: 
                case 96: {
                    this.internalTypeMaxLength = ((OraclePreparedStatement)this.statement).maxIbtVarcharElementLength;
                    if (max_len <= this.internalTypeMaxLength) ** GOTO lbl29
                    if (PlsqlIndexTableAccessor.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PlsqlIndexTableAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 53);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 53);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl29:
                    // 1 sources

                    this.elementMaxLen = (max_len == 0 ? this.internalTypeMaxLength : max_len) + 1;
                    this.ibtCharLength = this.elementMaxLen * this.maxNumberOfElements;
                    this.elementInternalType = 9;
                    ** break;
lbl33:
                    // 1 sources

                    break;
                }
                case 6: {
                    this.internalTypeMaxLength = 21;
                    this.elementMaxLen = this.internalTypeMaxLength + 1;
                    this.ibtByteLength = this.elementMaxLen * this.maxNumberOfElements;
                    ** break;
lbl39:
                    // 1 sources

                    break;
                }
                default: {
                    if (PlsqlIndexTableAccessor.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PlsqlIndexTableAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 97);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
        }
        finally {
            if (PlsqlIndexTableAccessor.TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getPlsqlIndexTable(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Object[] result = null;
            short[] ibtBindIndicators = this.statement.ibtBindIndicators;
            int actualElements = ((ibtBindIndicators[this.ibtMetaIndex + 4] & 0xFFFF) << 16) + (ibtBindIndicators[this.ibtMetaIndex + 5] & 0xFFFF);
            int offset = this.ibtValueIndex;
            switch (this.elementInternalType) {
                case 9: {
                    result = new String[actualElements];
                    char[] ibtBindChars = this.statement.ibtBindChars;
                    for (int i2 = 0; i2 < actualElements; ++i2) {
                        result[i2] = ibtBindIndicators[this.ibtIndicatorIndex + i2] == -1 ? null : new String(ibtBindChars, offset + 1, ibtBindChars[offset] >> 1);
                        offset += this.elementMaxLen;
                    }
                    break;
                }
                case 6: {
                    result = new BigDecimal[actualElements];
                    byte[] ibtBindBytes = this.statement.ibtBindBytes;
                    for (int i3 = 0; i3 < actualElements; ++i3) {
                        if (ibtBindIndicators[this.ibtIndicatorIndex + i3] == -1) {
                            result[i3] = null;
                        } else {
                            byte len = ibtBindBytes[offset];
                            byte[] val = new byte[len];
                            System.arraycopy(ibtBindBytes, offset + 1, val, 0, len);
                            result[i3] = oracle.sql.NUMBER.toBigDecimal(val);
                        }
                        offset += this.elementMaxLen;
                    }
                    break;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PlsqlIndexTableAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 97);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Datum[] getOraclePlsqlIndexTable(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Datum[] result = null;
            short[] ibtBindIndicators = this.statement.ibtBindIndicators;
            int actualElements = ((ibtBindIndicators[this.ibtMetaIndex + 4] & 0xFFFF) << 16) + (ibtBindIndicators[this.ibtMetaIndex + 5] & 0xFFFF);
            int offset = this.ibtValueIndex;
            switch (this.elementInternalType) {
                case 9: {
                    result = new CHAR[actualElements];
                    CharacterSet charset = CharacterSet.make(2000);
                    char[] ibtBindChars = this.statement.ibtBindChars;
                    for (int i2 = 0; i2 < actualElements; ++i2) {
                        if (ibtBindIndicators[this.ibtIndicatorIndex + i2] == -1) {
                            result[i2] = null;
                        } else {
                            char len = ibtBindChars[offset];
                            byte[] b2 = new byte[len];
                            DBConversion.javaCharsToUcs2Bytes(ibtBindChars, offset + 1, b2, 0, len >> 1);
                            result[i2] = new CHAR(b2, charset);
                        }
                        offset += this.elementMaxLen;
                    }
                    break;
                }
                case 6: {
                    result = new NUMBER[actualElements];
                    byte[] ibtBindBytes = this.statement.ibtBindBytes;
                    for (int i3 = 0; i3 < actualElements; ++i3) {
                        if (ibtBindIndicators[this.ibtIndicatorIndex + i3] == -1) {
                            result[i3] = null;
                        } else {
                            byte len = ibtBindBytes[offset];
                            byte[] val = new byte[len];
                            System.arraycopy(ibtBindBytes, offset + 1, val, 0, len);
                            result[i3] = new NUMBER(val);
                        }
                        offset += this.elementMaxLen;
                    }
                    break;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PlsqlIndexTableAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 97);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray = result;
            return datumArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIndexTableAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.PlsqlIndexTableAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

