/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.OracleTimeoutPollingThread;
import oracle.jdbc.internal.OracleConnection;

class OracleTimeoutThreadPerVM
extends OracleTimeout {
    private static final OracleTimeoutPollingThread watchdog = new OracleTimeoutPollingThread();
    private OracleStatement statement;
    private long interruptAfter;
    private String name;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleTimeoutThreadPerVM(String name) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutThreadPerVM.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.name = name;
            this.interruptAfter = Long.MAX_VALUE;
            watchdog.addTimeout(this);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutThreadPerVM.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutThreadPerVM.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            watchdog.removeTimeout(this);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutThreadPerVM.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void setTimeout(long milliseconds, OracleStatement stmt) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutThreadPerVM.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(milliseconds) + ", " + OracleLog.argument(stmt));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.interruptAfter != Long.MAX_VALUE) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTimeoutThreadPerVM.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 131);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 131);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.statement = stmt;
            this.interruptAfter = System.currentTimeMillis() + milliseconds;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutThreadPerVM.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void cancelTimeout() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutThreadPerVM.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.statement = null;
            this.interruptAfter = Long.MAX_VALUE;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutThreadPerVM.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIfAppropriate(long now) {
        block29: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTimeoutThreadPerVM.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(now));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (now <= this.interruptAfter) break block29;
                OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM = this;
                synchronized (oracleTimeoutThreadPerVM) {
                    if (now > this.interruptAfter) {
                        block31: {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "CANCELING thread :" + this.name);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            if (this.statement.connection.spawnNewThreadToCancel) {
                                final OracleStatement s2 = this.statement;
                                Thread t = new Thread(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        block5: {
                                            try {
                                                s2.cancel();
                                            }
                                            catch (Throwable e2) {
                                                if (!TRACE || !OracleLog.recursiveEnter()) break block5;
                                                try {
                                                    OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "spawning thread failed: " + e2);
                                                }
                                                finally {
                                                    OracleLog.recursiveExit();
                                                }
                                            }
                                        }
                                    }
                                });
                                t.setName("interruptIfAppropriate_" + this);
                                t.setDaemon(true);
                                t.setPriority(10);
                                t.start();
                            } else {
                                try {
                                    this.statement.cancel();
                                }
                                catch (Throwable e2) {
                                    if (!TRACE || !OracleLog.recursiveEnter()) break block31;
                                    try {
                                        OracleTimeoutThreadPerVM.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "statement cancel failed: " + e2);
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                            }
                        }
                        this.statement = null;
                        this.interruptAfter = Long.MAX_VALUE;
                    }
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTimeoutThreadPerVM.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutThreadPerVM.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutThreadPerVM.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTimeoutThreadPerVM.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleTimeoutThreadPerVM"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

