/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.CancelLock;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatementWrapper;
import oracle.jdbc.driver.OutRawAccessor;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.driver.VarnumAccessor;
import oracle.jdbc.internal.OracleStatement;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

abstract class OracleStatement
implements oracle.jdbc.internal.OracleStatement,
ScrollRsetStatement {
    static final int PLAIN_STMT = 0;
    static final int PREP_STMT = 1;
    static final int CALL_STMT = 2;
    int cursorId;
    int numberOfDefinePositions;
    int definesBatchSize;
    Accessor[] accessors;
    int defineByteSubRange;
    int defineCharSubRange;
    int defineIndicatorSubRange;
    int defineLengthSubRange;
    byte[] defineBytes;
    char[] defineChars;
    short[] defineIndicators;
    boolean described;
    boolean describedWithNames;
    byte[] defineMetaData;
    int defineMetaDataSubRange;
    static final int METADATALENGTH = 1;
    int rowsProcessed;
    int cachedDefineByteSize;
    int cachedDefineCharSize;
    int cachedDefineIndicatorSize;
    int cachedDefineMetaDataSize;
    OracleStatement children;
    OracleStatement parent;
    OracleStatement nextChild;
    OracleStatement next;
    OracleStatement prev;
    long c_state;
    int numberOfBindPositions;
    byte[] bindBytes;
    char[] bindChars;
    short[] bindIndicators;
    int bindByteOffset;
    int bindCharOffset;
    int bindIndicatorOffset;
    int bindByteSubRange;
    int bindCharSubRange;
    int bindIndicatorSubRange;
    Accessor[] outBindAccessors;
    InputStream[][] parameterStream;
    Object[][] userStream;
    int firstRowInBatch;
    boolean hasIbtBind;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    int ibtBindByteOffset;
    int ibtBindCharOffset;
    int ibtBindIndicatorOffset;
    int ibtBindIndicatorSize;
    ByteBuffer[] nioBuffers;
    Object[] lobPrefetchMetaData;
    boolean hasStream;
    byte[] tmpByteArray;
    int sizeTmpByteArray;
    byte[] tmpBindsByteArray;
    boolean needToSendOalToFetch;
    int[] definedColumnType;
    int[] definedColumnSize;
    int[] definedColumnFormOfUse;
    T4CTTIoac[] oacdefSent;
    int[] nbPostPonedColumns;
    int[][] indexOfPostPonedColumn;
    boolean aFetchWasDoneDuringDescribe;
    boolean implicitDefineForLobPrefetchDone;
    long checkSum;
    boolean checkSumComputationFailure;
    int accessorByteOffset;
    int accessorCharOffset;
    int accessorShortOffset;
    static final int VALID_ROWS_UNINIT = -999;
    PhysicalConnection connection;
    OracleInputStream streamList;
    OracleInputStream nextStream;
    OracleResultSetImpl currentResultSet;
    boolean processEscapes;
    boolean convertNcharLiterals;
    int queryTimeout;
    int batch;
    int numberOfExecutedElementsInBatch;
    int currentRank;
    boolean bsendBatchInProgress;
    int currentRow;
    int validRows;
    int maxFieldSize;
    int maxRows;
    int totalRowsVisited;
    int rowPrefetch;
    int rowPrefetchInLastFetch;
    int defaultRowPrefetch;
    boolean rowPrefetchChanged;
    int defaultLobPrefetchSize;
    boolean gotLastBatch;
    boolean clearParameters;
    boolean closed;
    boolean sqlStringChanged;
    OracleSql sqlObject;
    boolean needToParse;
    boolean needToPrepareDefineBuffer;
    boolean columnsDefinedByUser;
    OracleStatement.SqlKind sqlKind;
    byte sqlKindByte;
    int autoRollback;
    int defaultFetchDirection;
    boolean serverCursor;
    boolean fixedString;
    boolean noMoreUpdateCounts;
    protected CancelLock cancelLock;
    OracleStatementWrapper wrapper;
    static final byte EXECUTE_NONE = -1;
    static final byte EXECUTE_QUERY = 1;
    static final byte EXECUTE_UPDATE = 2;
    static final byte EXECUTE_NORMAL = 3;
    byte executionType;
    OracleResultSet scrollRset;
    oracle.jdbc.OracleResultSetCache rsetCache;
    int userRsetType;
    int realRsetType;
    boolean needToAddIdentifier;
    SQLWarning sqlWarning;
    int cacheState;
    int creationState;
    boolean isOpen;
    int statementType;
    boolean columnSetNull;
    int[] returnParamMeta;
    static final int DMLR_METADATA_PREFIX_SIZE = 3;
    static final int DMLR_METADATA_NUM_OF_RETURN_PARAMS = 0;
    static final int DMLR_METADATA_ROW_BIND_BYTES = 1;
    static final int DMLR_METADATA_ROW_BIND_CHARS = 2;
    static final int DMLR_METADATA_TYPE_OFFSET = 0;
    static final int DMLR_METADATA_IS_CHAR_TYPE_OFFSET = 1;
    static final int DMLR_METADATA_BIND_SIZE_OFFSET = 2;
    static final int DMLR_METADATA_FORM_OF_USE_OFFSET = 3;
    static final int DMLR_METADATA_PER_POSITION_SIZE = 4;
    Accessor[] returnParamAccessors;
    boolean returnParamsFetched;
    int rowsDmlReturned;
    int numReturnParams;
    byte[] returnParamBytes;
    char[] returnParamChars;
    short[] returnParamIndicators;
    int returnParamRowBytes;
    int returnParamRowChars;
    OracleReturnResultSet returnResultSet;
    boolean isAutoGeneratedKey;
    AutoKeyInfo autoKeyInfo;
    TimeZone defaultTimeZone;
    String defaultTimeZoneName;
    Calendar defaultCalendar;
    Calendar gmtCalendar;
    long inScn;
    int lastIndex;
    Vector m_batchItems;
    ArrayList tempClobsToFree;
    ArrayList tempBlobsToFree;
    ArrayList oldTempClobsToFree;
    ArrayList oldTempBlobsToFree;
    NTFDCNRegistration registration;
    String[] dcnTableName;
    long dcnQueryId;
    long _checkSum;
    static final byte IS_UNINITIALIZED = 0;
    static final byte IS_SELECT = 1;
    static final byte IS_DELETE = 2;
    static final byte IS_INSERT = 4;
    static final byte IS_MERGE = 8;
    static final byte IS_UPDATE = 16;
    static final byte IS_PLSQL_BLOCK = 32;
    static final byte IS_CALL_BLOCK = 64;
    static final byte IS_OTHER = -128;
    static final byte IS_DML = 30;
    static final byte IS_PLSQL = 96;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    abstract void doDescribe(boolean var1) throws SQLException;

    abstract void executeForDescribe() throws SQLException;

    abstract void executeForRows(boolean var1) throws SQLException;

    abstract void fetch() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void continueReadRow(int start) throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "continueReadRow is only implemented by the T4C statements.");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "continueReadRow is only implemented by the T4C statements.");
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    abstract void doClose() throws SQLException;

    abstract void closeQuery() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cursorIfRefCursor() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "cursorIfRefCursor not implemented");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "cursorIfRefCursor not implemented");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    void closeCursorOnPlainStatement() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSnapshotSCN(long scn) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.doSetSnapshotSCN(scn);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSetSnapshotSCN(long scn) throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleStatement(PhysicalConnection conn, int batchValue, int rowPrefetchValue) throws SQLException {
        block12: {
            this(conn, batchValue, rowPrefetchValue, -1, -1);
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(batchValue) + ", " + OracleLog.argument(rowPrefetchValue));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleStatement(PhysicalConnection conn, int batch_value, int row_prefetch_value, int UserResultSetType, int UserResultSetConcur) throws SQLException {
        this.described = false;
        this.describedWithNames = false;
        this.cachedDefineByteSize = 0;
        this.cachedDefineCharSize = 0;
        this.cachedDefineIndicatorSize = 0;
        this.cachedDefineMetaDataSize = 0;
        this.children = null;
        this.parent = null;
        this.nextChild = null;
        this.hasIbtBind = false;
        this.nioBuffers = null;
        this.lobPrefetchMetaData = null;
        this.sizeTmpByteArray = 0;
        this.needToSendOalToFetch = false;
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        this.oacdefSent = null;
        this.nbPostPonedColumns = null;
        this.indexOfPostPonedColumn = null;
        this.aFetchWasDoneDuringDescribe = false;
        this.implicitDefineForLobPrefetchDone = false;
        this.checkSum = 0L;
        this.checkSumComputationFailure = false;
        this.accessorByteOffset = 0;
        this.accessorCharOffset = 0;
        this.accessorShortOffset = 0;
        this.numberOfExecutedElementsInBatch = -1;
        this.bsendBatchInProgress = false;
        this.rowPrefetchInLastFetch = -1;
        this.sqlKind = OracleStatement.SqlKind.SELECT;
        this.sqlKindByte = 1;
        this.fixedString = false;
        this.noMoreUpdateCounts = false;
        this.cancelLock = new CancelLock();
        this.executionType = (byte)-1;
        this.cacheState = 3;
        this.creationState = 0;
        this.isOpen = false;
        this.statementType = 0;
        this.columnSetNull = false;
        this.defaultTimeZone = null;
        this.defaultTimeZoneName = null;
        this.defaultCalendar = null;
        this.gmtCalendar = null;
        this.inScn = 0L;
        this.m_batchItems = null;
        this.tempClobsToFree = null;
        this.tempBlobsToFree = null;
        this.oldTempClobsToFree = null;
        this.oldTempBlobsToFree = null;
        this.registration = null;
        this.dcnTableName = null;
        this.dcnQueryId = -1L;
        this._checkSum = 0L;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(batch_value) + ", " + OracleLog.argument(row_prefetch_value) + ", " + OracleLog.argument(UserResultSetType) + ", " + OracleLog.argument(UserResultSetConcur));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.connection = conn;
            this.connection.needLine();
            this.connection.registerHeartbeat();
            this.connection.addStatement(this);
            this.sqlObject = new OracleSql(this.connection.conversion);
            this.processEscapes = this.connection.processEscapes;
            this.convertNcharLiterals = this.connection.convertNcharLiterals;
            this.autoRollback = 2;
            this.gotLastBatch = false;
            this.closed = false;
            this.clearParameters = true;
            this.serverCursor = false;
            this.needToAddIdentifier = false;
            this.defaultFetchDirection = 1000;
            this.fixedString = this.connection.getDefaultFixedString();
            this.rowPrefetchChanged = false;
            this.rowPrefetch = row_prefetch_value;
            this.defaultRowPrefetch = row_prefetch_value;
            this.defaultLobPrefetchSize = this.connection.getVersionNumber() >= 11000 ? this.connection.defaultLobPrefetchSize : -1;
            this.batch = batch_value;
            this.sqlStringChanged = true;
            this.needToParse = true;
            this.needToPrepareDefineBuffer = true;
            this.columnsDefinedByUser = false;
            if (UserResultSetType != -1 || UserResultSetConcur != -1) {
                this.realRsetType = 0;
                this.userRsetType = ResultSetUtil.getRsetTypeCode(UserResultSetType, UserResultSetConcur);
                this.needToAddIdentifier = ResultSetUtil.needIdentifier(this.userRsetType);
            } else {
                this.userRsetType = 1;
                this.realRsetType = 1;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeDefineSubRanges() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.defineByteSubRange = 0;
            this.defineCharSubRange = 0;
            this.defineIndicatorSubRange = 0;
            this.defineMetaDataSubRange = 0;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareDefinePreambles() {
        block17: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block17;
                try {
                    OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "do nothing");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareAccessors() throws SQLException {
        block54: {
            long __ol_nanos__ = 0L;
            try {
                int preFetchSize;
                Accessor accessor;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                byte[] tmp_defineBytes = null;
                char[] tmp_defineChars = null;
                short[] tmp_defineIndicators = null;
                boolean isIndicatorsReused = false;
                byte[] tmp_defineMetaData = null;
                if (this.accessors == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int defineByteSize = 0;
                int defineCharSize = 0;
                int defineMetaDataSize = 0;
                for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                    accessor = this.accessors[i2];
                    if (accessor == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    switch (accessor.internalType) {
                        case 8: 
                        case 24: {
                            this.hasStream = true;
                        }
                    }
                    defineByteSize += accessor.byteLength;
                    defineCharSize += accessor.charLength;
                    ++defineMetaDataSize;
                }
                if (this.streamList != null && !this.connection.useFetchSizeWithLongColumn) {
                    this.rowPrefetch = 1;
                }
                this.definesBatchSize = preFetchSize = this.rowPrefetch;
                this.initializeDefineSubRanges();
                int totalMetaDataSize = defineMetaDataSize * preFetchSize;
                if (this.defineMetaData == null || this.defineMetaData.length < totalMetaDataSize) {
                    if (this.defineMetaData != null) {
                        tmp_defineMetaData = this.defineMetaData;
                    }
                    this.defineMetaData = new byte[totalMetaDataSize];
                }
                this.cachedDefineByteSize = this.defineByteSubRange + defineByteSize * preFetchSize;
                if (this.defineBytes == null || this.defineBytes.length < this.cachedDefineByteSize) {
                    if (this.defineBytes != null) {
                        tmp_defineBytes = this.defineBytes;
                    }
                    this.defineBytes = this.connection.getByteBuffer(this.cachedDefineByteSize);
                }
                this.defineByteSubRange += this.accessorByteOffset;
                this.cachedDefineCharSize = this.defineCharSubRange + defineCharSize * preFetchSize;
                if ((this.defineChars == null || this.defineChars.length < this.cachedDefineCharSize) && this.cachedDefineCharSize > 0) {
                    if (this.defineChars != null) {
                        tmp_defineChars = this.defineChars;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + this.toString() + " requests a " + this.cachedDefineCharSize / 512 + "KB char data buffer");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.defineChars = this.connection.getCharBuffer(this.cachedDefineCharSize);
                }
                this.defineCharSubRange += this.accessorCharOffset;
                int defineIndicatorSizeTerm = this.numberOfDefinePositions * preFetchSize;
                int totalIndicatorSize = this.defineIndicatorSubRange + defineIndicatorSizeTerm + defineIndicatorSizeTerm;
                if (this.defineIndicators == null || this.defineIndicators.length < totalIndicatorSize) {
                    if (this.defineIndicators != null) {
                        tmp_defineIndicators = this.defineIndicators;
                    }
                    this.defineIndicators = new short[totalIndicatorSize];
                } else if (this.defineIndicators.length >= totalIndicatorSize) {
                    isIndicatorsReused = true;
                    tmp_defineIndicators = this.defineIndicators;
                }
                this.defineIndicatorSubRange += this.accessorShortOffset;
                int defineLengthSubRange = this.defineIndicatorSubRange + defineIndicatorSizeTerm;
                for (int i3 = 0; i3 < this.numberOfDefinePositions; ++i3) {
                    accessor = this.accessors[i3];
                    accessor.lengthIndexLastRow = accessor.lengthIndex;
                    accessor.indicatorIndexLastRow = accessor.indicatorIndex;
                    accessor.columnIndexLastRow = accessor.columnIndex;
                    accessor.setOffsets(preFetchSize);
                    accessor.lengthIndex = defineLengthSubRange;
                    accessor.indicatorIndex = this.defineIndicatorSubRange;
                    accessor.metaDataIndex = this.defineMetaDataSubRange;
                    accessor.rowSpaceByte = this.defineBytes;
                    accessor.rowSpaceChar = this.defineChars;
                    accessor.rowSpaceIndicator = this.defineIndicators;
                    accessor.rowSpaceMetaData = this.defineMetaData;
                    this.defineIndicatorSubRange += preFetchSize;
                    defineLengthSubRange += preFetchSize;
                    this.defineMetaDataSubRange += preFetchSize * 1;
                }
                this.prepareDefinePreambles();
                if (this.rowPrefetchInLastFetch != -1 && this.rowPrefetch != this.rowPrefetchInLastFetch) {
                    if (tmp_defineChars == null) {
                        tmp_defineChars = this.defineChars;
                    }
                    if (tmp_defineBytes == null) {
                        tmp_defineBytes = this.defineBytes;
                    }
                    if (tmp_defineIndicators == null) {
                        tmp_defineIndicators = this.defineIndicators;
                    }
                    this.saveDefineBuffersIfRequired(tmp_defineChars, tmp_defineBytes, tmp_defineIndicators, isIndicatorsReused);
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block54;
                try {
                    OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "return " + "rowPrefetch = " + this.rowPrefetch + " needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkAccessorsUsable() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int len;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((len = this.accessors.length) < this.numberOfDefinePositions) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            boolean allHaveExternalType = true;
            boolean anyHaveExternalType = false;
            boolean result = false;
            for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                Accessor accessor = this.accessors[i2];
                if (accessor == null || accessor.externalType == 0) {
                    allHaveExternalType = false;
                    continue;
                }
                anyHaveExternalType = true;
            }
            if (allHaveExternalType) {
                result = true;
            } else {
                if (anyHaveExternalType) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.columnsDefinedByUser = false;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeMaybeDescribe() throws SQLException {
        block40: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "rowPrefetchChanged = " + this.rowPrefetchChanged + ", needToParse = " + this.needToParse + ", needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer + ", columnsDefinedByUser = " + this.columnsDefinedByUser);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean needExplicitFetch = true;
                if (this.rowPrefetchChanged) {
                    if (this.streamList == null && this.rowPrefetch != this.definesBatchSize) {
                        this.needToPrepareDefineBuffer = true;
                    }
                    this.rowPrefetchChanged = false;
                }
                if (!this.needToPrepareDefineBuffer) {
                    if (this.accessors == null) {
                        this.needToPrepareDefineBuffer = true;
                    } else if (this.columnsDefinedByUser) {
                        this.needToPrepareDefineBuffer = !this.checkAccessorsUsable();
                    }
                }
                boolean executed_for_describe = false;
                try {
                    this.cancelLock.enterExecuting();
                    if (this.needToPrepareDefineBuffer) {
                        if (!this.columnsDefinedByUser) {
                            this.executeForDescribe();
                            executed_for_describe = true;
                            if (this.aFetchWasDoneDuringDescribe) {
                                needExplicitFetch = false;
                            }
                        }
                        if (this.needToPrepareDefineBuffer) {
                            this.prepareAccessors();
                        }
                    }
                    int len = this.accessors.length;
                    for (int i2 = this.numberOfDefinePositions; i2 < len; ++i2) {
                        Accessor accessor = this.accessors[i2];
                        if (accessor == null) continue;
                        accessor.rowSpaceIndicator = null;
                    }
                    if (needExplicitFetch) {
                        this.executeForRows(executed_for_describe);
                    }
                }
                catch (SQLException ea) {
                    this.needToParse = true;
                    throw ea;
                }
                finally {
                    this.cancelLock.exitExecuting();
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block40;
                try {
                    OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "validRows = " + this.validRows + ", needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer + " ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustGotLastBatch() {
        block17: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block17;
                try {
                    OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "do nothing");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doExecuteWithTimeout() throws SQLException {
        block73: {
            long __ol_nanos__ = 0L;
            try {
                block69: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer + "");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            Throwable __t__ = new Throwable("No Error");
                            OracleStatement.logger().log(Level.CONFIG, Integer.toHexString(this.hashCode()).toUpperCase() + " SQL: " + this.sqlObject.getOriginalSql(), __t__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    try {
                        SQLException __ex__;
                        this.cleanOldTempLobs();
                        this.connection.registerHeartbeat();
                        this.rowsProcessed = 0;
                        if (this.sqlKind.isSELECT()) {
                            if (this.connection.j2ee13Compliant && this.executionType == 2) {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 129);
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 129);
                                __ex__.fillInStackTrace();
                                throw __ex__;
                            }
                            this.connection.needLine();
                            if (!this.isOpen) {
                                this.connection.open(this);
                                this.isOpen = true;
                            }
                            if (this.queryTimeout != 0) {
                                try {
                                    this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                                    this.executeMaybeDescribe();
                                }
                                finally {
                                    this.connection.getTimeout().cancelTimeout();
                                }
                            } else {
                                this.executeMaybeDescribe();
                            }
                            this.checkValidRowsStatus();
                            if (this.serverCursor) {
                                this.adjustGotLastBatch();
                            }
                            break block69;
                        }
                        if (this.connection.j2ee13Compliant && !this.sqlKind.isPlsqlOrCall() && this.executionType == 1) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 128);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 128);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        ++this.currentRank;
                        if (this.currentRank >= this.batch) {
                            try {
                                this.connection.needLine();
                                this.cancelLock.enterExecuting();
                                if (!this.isOpen) {
                                    this.connection.open(this);
                                    this.isOpen = true;
                                }
                                if (this.queryTimeout != 0) {
                                    this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                                }
                                this.executeForRows(false);
                            }
                            catch (SQLException ea) {
                                this.needToParse = true;
                                if (this.batch > 1) {
                                    int i2;
                                    int[] ret_array;
                                    this.clearBatch();
                                    if (this.numberOfExecutedElementsInBatch != -1 && this.numberOfExecutedElementsInBatch < this.batch) {
                                        ret_array = new int[this.numberOfExecutedElementsInBatch];
                                        for (i2 = 0; i2 < ret_array.length; ++i2) {
                                            ret_array[i2] = -2;
                                        }
                                    } else {
                                        ret_array = new int[this.batch];
                                        for (i2 = 0; i2 < ret_array.length; ++i2) {
                                            ret_array[i2] = -3;
                                        }
                                    }
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing BatchUpdateException: " + ea + ret_array.length + ret_array);
                                        }
                                        finally {
                                            OracleLog.recursiveExit();
                                        }
                                    }
                                    BatchUpdateException __ex__2 = DatabaseError.createBatchUpdateException(ea, ret_array.length, ret_array);
                                    __ex__2.fillInStackTrace();
                                    throw __ex__2;
                                }
                                this.resetCurrentRowBinders();
                                throw ea;
                            }
                            finally {
                                if (this.queryTimeout != 0) {
                                    this.connection.getTimeout().cancelTimeout();
                                }
                                this.currentRank = 0;
                                this.cancelLock.exitExecuting();
                                this.checkValidRowsStatus();
                            }
                        }
                        if (!TRACE || !OracleLog.recursiveEnter()) break block69;
                        try {
                            OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "currentRank=" + this.currentRank + " needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    catch (SQLException ea) {
                        this.resetOnExceptionDuringExecute();
                        throw ea;
                    }
                }
                this.connection.registerHeartbeat();
                if (!TRACE || !OracleLog.recursiveEnter()) break block73;
                try {
                    OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "validRows = " + this.validRows + ", needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    void resetOnExceptionDuringExecute() {
        this.needToParse = true;
    }

    void resetCurrentRowBinders() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.isOpen) {
                this.connection.needLine();
                this.connection.open(this);
                this.isOpen = true;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSet oracleResultSet;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                OracleResultSet result = null;
                try {
                    this.executionType = 1;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.noMoreUpdateCounts = false;
                    this.ensureOpen();
                    this.checkIfJdbcBatchExists();
                    this.sendBatch();
                    this.hasStream = false;
                    this.sqlObject.initialize(sql);
                    this.sqlKind = this.sqlObject.getSqlKind();
                    this.needToParse = true;
                    this.prepareForNewResults(true, true);
                    if (this.userRsetType == 1) {
                        this.doExecuteWithTimeout();
                        this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                        result = this.currentResultSet;
                    } else {
                        result = this.doScrollStmtExecuteQuery();
                        if (result == null) {
                            this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                            result = this.currentResultSet;
                        }
                    }
                }
                finally {
                    this.executionType = (byte)-1;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleResultSet = result;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleResultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeWithKey(String key) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(key));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.closeOrCache(null);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeOrCache(String key) throws SQLException {
        block41: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(key));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    return;
                }
                if (this.connection.lifecycle == 2) {
                    this.connection.needLineUnchecked();
                } else {
                    this.connection.needLine();
                }
                if (this.statementType != 0 && this.cacheState != 0 && this.cacheState != 3 && this.connection.isStatementCacheInitialized()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "caching stmt = " + this);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (key == null) {
                        if (this.connection.getImplicitCachingEnabled()) {
                            this.connection.cacheImplicitStatement((OraclePreparedStatement)this, this.sqlObject.getOriginalSql(), this.statementType, this.userRsetType);
                        } else {
                            this.cacheState = 0;
                            this.hardClose();
                        }
                    } else if (this.connection.getExplicitCachingEnabled()) {
                        this.connection.cacheExplicitStatement((OraclePreparedStatement)this, key);
                    } else {
                        this.cacheState = 0;
                        this.hardClose();
                    }
                    break block41;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "closing stmt " + this);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.hardClose();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hardClose() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.hardClose(true);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hardClose(boolean closeCursor) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(closeCursor));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.alwaysOnClose();
            this.describedWithNames = false;
            this.described = false;
            this.connection.removeStatement(this);
            this.cleanupDefines();
            if (this.isOpen && closeCursor && (this.connection.lifecycle == 1 || this.connection.lifecycle == 16 || this.connection.lifecycle == 2)) {
                this.connection.registerHeartbeat();
                this.doClose();
                this.isOpen = false;
            }
            this.sqlObject = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void alwaysOnClose() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleStatement child = this.children;
            while (child != null) {
                OracleStatement n2 = child.nextChild;
                child.close();
                child = n2;
            }
            if (this.parent != null) {
                this.parent.removeChild(this);
            }
            this.closed = true;
            if (this.connection.lifecycle == 1 || this.connection.lifecycle == 2) {
                if (this.currentResultSet != null) {
                    this.currentResultSet.internal_close(false);
                    this.currentResultSet = null;
                }
                if (this.scrollRset != null) {
                    this.scrollRset.close();
                    this.scrollRset = null;
                }
                if (this.returnResultSet != null) {
                    this.returnResultSet.close();
                    this.returnResultSet = null;
                }
            }
            this.clearWarnings();
            this.m_batchItems = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeLeaveCursorOpen() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    return;
                }
                this.hardClose(false);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.setNonAutoKey();
                int __result__ = this.executeUpdateInternal(sql);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int executeUpdateInternal(String sql) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            try {
                if (this.executionType == -1) {
                    this.executionType = (byte)2;
                }
                this.noMoreUpdateCounts = false;
                this.ensureOpen();
                this.checkIfJdbcBatchExists();
                this.sendBatch();
                this.hasStream = false;
                this.sqlObject.initialize(sql);
                this.sqlKind = this.sqlObject.getSqlKind();
                this.needToParse = true;
                this.prepareForNewResults(true, true);
                if (this.userRsetType == 1) {
                    this.doExecuteWithTimeout();
                } else {
                    this.doScrollStmtExecuteQuery();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.validRows);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = this.validRows;
            }
            catch (Throwable throwable) {
                this.executionType = (byte)-1;
                throw throwable;
            }
            this.executionType = (byte)-1;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.setNonAutoKey();
                boolean __result__ = this.executeInternal(sql);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeInternal(String sql) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sql));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            try {
                this.executionType = (byte)3;
                this.checkSum = 0L;
                this.checkSumComputationFailure = false;
                this.noMoreUpdateCounts = false;
                this.ensureOpen();
                this.checkIfJdbcBatchExists();
                this.sendBatch();
                this.hasStream = false;
                this.sqlObject.initialize(sql);
                this.sqlKind = this.sqlObject.getSqlKind();
                this.needToParse = true;
                this.prepareForNewResults(true, true);
                if (this.userRsetType == 1) {
                    this.doExecuteWithTimeout();
                } else {
                    this.doScrollStmtExecuteQuery();
                }
                boolean __result__ = this.sqlKind.isSELECT();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                this.executionType = (byte)-1;
                throw throwable;
            }
            this.executionType = (byte)-1;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfColumns() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.ensureOpen();
            if (!this.described) {
                PhysicalConnection physicalConnection = this.connection;
                synchronized (physicalConnection) {
                    this.doDescribe(false);
                    this.described = true;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.numberOfDefinePositions);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.numberOfDefinePositions;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Accessor[] getDescription() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            Accessor[] accessorArray;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.ensureOpen();
            if (!this.described) {
                accessorArray = this.connection;
                // MONITORENTER : this.connection
                this.doDescribe(false);
                this.described = true;
                // MONITOREXIT : accessorArray
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.accessors);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            accessorArray = this.accessors;
            return accessorArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Accessor[] getDescriptionWithNames() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            Accessor[] accessorArray;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.ensureOpen();
            if (!this.describedWithNames) {
                accessorArray = this.connection;
                // MONITORENTER : this.connection
                this.doDescribe(true);
                this.described = true;
                this.describedWithNames = true;
                // MONITOREXIT : accessorArray
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.accessors);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            accessorArray = this.accessors;
            return accessorArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleStatement.SqlKind getSqlKind() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.sqlObject.getSqlKind()));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleStatement.SqlKind sqlKind = this.sqlObject.getSqlKind();
            return sqlKind;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDefines() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.freeLine();
                this.streamList = null;
                this.columnsDefinedByUser = false;
                this.needToPrepareDefineBuffer = true;
                this.numberOfDefinePositions = 0;
                this.definesBatchSize = 0;
                this.described = false;
                this.describedWithNames = false;
                this.cleanupDefines();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reparseOnRedefineIfNeeded() throws SQLException {
        block17: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block17;
                try {
                    OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "do nothing");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void defineColumnTypeInternal(int column_index, int type, int size, boolean sizeNotGiven, String typeName) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(size) + ", " + OracleLog.argument(sizeNotGiven) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.defineColumnTypeInternal(column_index, type, size, (short)1, sizeNotGiven, typeName);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void defineColumnTypeInternal(int column_index, int type, int size, short form, boolean sizeNotGiven, String typeName) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int max_len;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(size) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(sizeNotGiven) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.connection.disableDefinecolumntype) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            if (column_index < 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (type == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int idx = column_index - 1;
            int n2 = max_len = this.maxFieldSize > 0 ? this.maxFieldSize : -1;
            if (sizeNotGiven) {
                if (type == 1 || type == 12 || type == -15 || type == -9) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + "defineColumnType with a type that requires a length, but no length provided");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 108);
                }
            } else {
                if (size < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 53);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 53);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (max_len == -1 && size > 0 || max_len > 0 && size < max_len) {
                    max_len = size;
                }
            }
            if (this.currentResultSet != null && !this.currentResultSet.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 28);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 28);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (!this.columnsDefinedByUser) {
                this.clearDefines();
                this.columnsDefinedByUser = true;
            }
            if (this.numberOfDefinePositions < column_index) {
                if (this.accessors == null || this.accessors.length < column_index) {
                    Accessor[] na = new Accessor[column_index << 1];
                    if (this.accessors != null) {
                        System.arraycopy(this.accessors, 0, na, 0, this.numberOfDefinePositions);
                    }
                    this.accessors = na;
                }
                this.numberOfDefinePositions = column_index;
            }
            switch (type) {
                case -16: 
                case -15: 
                case -9: 
                case 2011: {
                    form = (short)2;
                    break;
                }
                case 2009: {
                    typeName = "SYS.XMLTYPE";
                    break;
                }
            }
            int internal_type = this.getInternalType(type);
            if (!(internal_type != 109 && internal_type != 111 || typeName != null && !typeName.equals(""))) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 60 + "Invalid arguments");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Accessor accessor = this.accessors[idx];
            boolean need_to_prepare = true;
            if (accessor != null) {
                int reusability = accessor.useForDataAccessIfPossible(internal_type, type, max_len, typeName);
                if (reusability == 0) {
                    form = accessor.formOfUse;
                    accessor = null;
                    this.reparseOnRedefineIfNeeded();
                } else if (reusability == 1) {
                    accessor = null;
                    this.reparseOnRedefineIfNeeded();
                } else if (reusability == 2) {
                    need_to_prepare = false;
                }
            }
            if (need_to_prepare) {
                this.needToPrepareDefineBuffer = true;
            }
            if (accessor == null) {
                this.accessors[idx] = this.allocateAccessor(internal_type, type, column_index, max_len, form, typeName, false);
                this.described = false;
                this.describedWithNames = false;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Accessor allocateAccessor(int internal_type, int external_type, int col_index, int max_len, short form, String typeName, boolean forBind) throws SQLException {
        __ol_nanos__ = 0L;
        try {
            if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(col_index) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(forBind));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            switch (internal_type) {
                case 96: {
                    if (!forBind || typeName == null) ** GOTO lbl26
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl26:
                    // 1 sources

                    __result__ = new CharAccessor(this, max_len, form, external_type, forBind);
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_68 = __result__;
                    return var12_68;
                }
                case 8: {
                    if (!forBind || typeName == null) ** GOTO lbl49
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl49:
                    // 1 sources

                    if (forBind) ** GOTO lbl60
                    __result__ = new LongAccessor(this, col_index, max_len, form, external_type);
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_69 = __result__;
                    return var12_69;
                }
lbl60:
                // 2 sources

                case 1: {
                    if (!forBind || typeName == null) ** GOTO lbl73
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl73:
                    // 1 sources

                    __result__ = new VarcharAccessor(this, max_len, form, external_type, forBind);
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_70 = __result__;
                    return var12_70;
                }
                case 2: {
                    if (!forBind || typeName == null) ** GOTO lbl96
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl96:
                    // 1 sources

                    __result__ = new NumberAccessor(this, max_len, form, external_type, forBind);
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_71 = __result__;
                    return var12_71;
                }
                case 6: {
                    if (!forBind || typeName == null) ** GOTO lbl119
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl119:
                    // 1 sources

                    __result__ = new VarnumAccessor(this, max_len, form, external_type, forBind);
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_72 = __result__;
                    return var12_72;
                }
                case 24: {
                    if (!forBind || typeName == null) ** GOTO lbl142
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl142:
                    // 1 sources

                    if (!forBind) {
                        __ex__ = new LongRawAccessor(this, col_index, max_len, form, external_type);
                        return __ex__;
                    }
                }
                case 23: {
                    if (!forBind || typeName == null) ** GOTO lbl158
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl158:
                    // 1 sources

                    if (!forBind) ** GOTO lbl169
                    __result__ = new OutRawAccessor(this, max_len, form, external_type);
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_73 = __result__;
                    return var12_73;
lbl169:
                    // 1 sources

                    __result__ = new RawAccessor(this, max_len, form, external_type, false);
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_74 = __result__;
                    return var12_74;
                }
                case 100: {
                    if (!forBind || typeName == null) ** GOTO lbl192
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl192:
                    // 1 sources

                    __ex__ = new BinaryFloatAccessor(this, max_len, form, external_type, forBind);
                    return __ex__;
                }
                case 101: {
                    if (!forBind || typeName == null) ** GOTO lbl207
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl207:
                    // 1 sources

                    __ex__ = new BinaryDoubleAccessor(this, max_len, form, external_type, forBind);
                    return __ex__;
                }
                case 104: {
                    if (!forBind || typeName == null) ** GOTO lbl222
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl222:
                    // 1 sources

                    if (this.sqlKind != OracleStatement.SqlKind.CALL_BLOCK) ** GOTO lbl236
                    max_len = 18;
                    result = new VarcharAccessor(this, max_len, form, external_type, forBind);
                    result.definedColumnType = -8;
                    __result__ = result;
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_75 = __result__;
                    return var12_75;
lbl236:
                    // 1 sources

                    __result__ = new RowidAccessor(this, max_len, form, external_type, forBind);
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_76 = __result__;
                    return var12_76;
                }
                case 102: {
                    if (!forBind || typeName == null) ** GOTO lbl259
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl259:
                    // 1 sources

                    __result__ = new ResultSetAccessor(this, max_len, form, external_type, forBind);
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_77 = __result__;
                    return var12_77;
                }
                case 12: {
                    if (!forBind || typeName == null) ** GOTO lbl282
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl282:
                    // 1 sources

                    __result__ = new DateAccessor(this, max_len, form, external_type, forBind);
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_78 = __result__;
                    return var12_78;
                }
                case 113: {
                    if (!forBind || typeName == null) ** GOTO lbl305
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl305:
                    // 1 sources

                    result = new BlobAccessor(this, -1, form, external_type, forBind);
                    if (!forBind) {
                        result.lobPrefetchSizeForThisColumn = max_len;
                    }
                    __result__ = result;
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_79 = __result__;
                    return var12_79;
                }
                case 112: {
                    if (!forBind || typeName == null) ** GOTO lbl331
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl331:
                    // 1 sources

                    result = new ClobAccessor(this, -1, form, external_type, forBind);
                    if (!forBind) {
                        result.lobPrefetchSizeForThisColumn = max_len;
                    }
                    __result__ = result;
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_80 = __result__;
                    return var12_80;
                }
                case 114: {
                    if (!forBind || typeName == null) ** GOTO lbl357
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl357:
                    // 1 sources

                    __result__ = result = new BfileAccessor(this, -1, form, external_type, forBind);
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_81 = __result__;
                    return var12_81;
                }
                case 109: {
                    if (typeName != null) ** GOTO lbl392
                    if (!forBind) ** GOTO lbl381
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl381:
                    // 1 sources

                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 60 + "Unable to resolve type \"null\"");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"");
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl392:
                    // 1 sources

                    result = new NamedTypeAccessor(this, typeName, form, external_type, forBind);
                    result.initMetadata();
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = result;
                    return __ex__;
                }
                case 111: {
                    if (typeName != null) ** GOTO lbl428
                    if (!forBind) ** GOTO lbl417
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl417:
                    // 1 sources

                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 60 + "Unable to resolve type \"null\"");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"");
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl428:
                    // 1 sources

                    result = new RefTypeAccessor(this, typeName, form, external_type, forBind);
                    result.initMetadata();
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = result;
                    return __ex__;
                }
                case 180: {
                    if (!forBind || typeName == null) ** GOTO lbl452
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl452:
                    // 1 sources

                    __result__ = new TimestampAccessor(this, max_len, form, external_type, forBind);
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_82 = __result__;
                    return var12_82;
                }
                case 181: {
                    if (!forBind || typeName == null) ** GOTO lbl475
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl475:
                    // 1 sources

                    __result__ = new TimestamptzAccessor(this, max_len, form, external_type, forBind);
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var12_83 = __result__;
                    return var12_83;
                }
                case 231: {
                    if (!forBind || typeName == null) ** GOTO lbl498
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl498:
                    // 1 sources

                    __ex__ = new TimestampltzAccessor(this, max_len, form, external_type, forBind);
                    return __ex__;
                }
                case 182: {
                    if (!forBind || typeName == null) ** GOTO lbl513
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl513:
                    // 1 sources

                    __ex__ = new IntervalymAccessor(this, max_len, form, external_type, forBind);
                    return __ex__;
                }
                case 183: {
                    if (!forBind || typeName == null) ** GOTO lbl528
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl528:
                    // 1 sources

                    __ex__ = new IntervaldsAccessor(this, max_len, form, external_type, forBind);
                    return __ex__;
                }
                case 995: {
                    if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 89);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (OracleStatement.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnType(int column_index, int type) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.defineColumnTypeInternal(column_index, type, -1, true, null);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnType(int column_index, int type, int max_size) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(max_size));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.defineColumnTypeInternal(column_index, type, max_size, false, null);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnType(int column_index, int type, int max_size, short form_of_use) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(max_size) + ", " + OracleLog.argument(form_of_use));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.defineColumnTypeInternal(column_index, type, max_size, form_of_use, false, null);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnTypeBytes(int column_index, int type, int max_size) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(max_size));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + "call to defineColumnTypeBytes which is deprecated and may not behave as expected");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.defineColumnTypeInternal(column_index, type, max_size, false, null);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnTypeChars(int column_index, int type, int max_size) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(max_size));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.defineColumnTypeInternal(column_index, type, max_size, false, null);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnType(int column_index, int typeCode, String typeName) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(typeCode) + ", " + OracleLog.argument(typeName));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.defineColumnTypeInternal(column_index, typeCode, -1, true, typeName);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCursorId(int id) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(id));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.cursorId = id;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPrefetchInternal(int new_value, boolean setRowPrefetch, boolean statement) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(new_value) + ", " + OracleLog.argument(setRowPrefetch) + ", " + OracleLog.argument(statement));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (setRowPrefetch) {
                if (new_value <= 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 20);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 20);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            } else {
                if (new_value < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "setFetchSize");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchSize");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (new_value == 0) {
                    new_value = this.connection.getDefaultRowPrefetch();
                }
            }
            if (statement) {
                if (new_value != this.defaultRowPrefetch) {
                    this.defaultRowPrefetch = new_value;
                    if (this.currentResultSet == null || this.currentResultSet.closed) {
                        this.rowPrefetchChanged = true;
                    }
                }
            } else if (new_value != this.rowPrefetch && this.streamList == null) {
                this.rowPrefetch = new_value;
                this.rowPrefetchChanged = true;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRowPrefetch(int value) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.setPrefetchInternal(value, true, true);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLobPrefetchSize(int value) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(value));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (value < -1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 267);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 267);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.defaultLobPrefetchSize = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLobPrefetchSize() {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.defaultLobPrefetchSize);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.defaultLobPrefetchSize;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPrefetchInternal(boolean statement) {
        long __ol_nanos__ = 0L;
        try {
            int ret_val;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(statement));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int n2 = ret_val = statement ? this.defaultRowPrefetch : this.rowPrefetch;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret_val);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = ret_val;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowPrefetch() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                int __result__ = this.getPrefetchInternal(true);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFixedString(boolean fixedString_value) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(fixedString_value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.fixedString = fixedString_value;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getFixedString() {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.fixedString);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.fixedString;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void check_row_prefetch_changed() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.rowPrefetchChanged) {
                if (this.streamList == null) {
                    this.prepareAccessors();
                    this.needToPrepareDefineBuffer = true;
                }
                this.rowPrefetchChanged = false;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDefinesInitialized(boolean value) {
        block17: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block17;
                try {
                    OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "no implemetation for kprb and thin, implemented only in OCI");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    void printState(String message) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkValidRowsStatus() throws SQLException {
        block31: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.validRows == -2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "nextStream = " + this.nextStream);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.validRows = 1;
                    this.connection.holdLine(this);
                    OracleInputStream is = this.streamList;
                    while (is != null) {
                        if (is.hasBeenOpen) {
                            is = is.accessor.initForNewRow();
                        }
                        is.closed = false;
                        is.hasBeenOpen = true;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "opens " + is);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        is = is.nextStream;
                    }
                    this.nextStream = this.streamList;
                    break block31;
                }
                if (this.sqlKind.isSELECT()) {
                    if (this.validRows < this.rowPrefetch) {
                        this.gotLastBatch = true;
                    }
                } else if (!this.sqlKind.isPlsqlOrCall()) {
                    this.rowsProcessed = this.validRows;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupDefines() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.accessors != null) {
                for (int i2 = 0; i2 < this.accessors.length; ++i2) {
                    this.accessors[i2] = null;
                }
            }
            this.accessors = null;
            this.connection.cacheBuffer(this.defineBytes);
            this.defineBytes = null;
            this.connection.cacheBuffer(this.defineChars);
            this.defineChars = null;
            this.defineIndicators = null;
            this.defineMetaData = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxFieldSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.maxFieldSize);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = this.maxFieldSize;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(max));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (max < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.maxFieldSize = max;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxRows() throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.maxRows);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.maxRows;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxRows(int max) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(max));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (max < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.maxRows = max;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(enable));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.processEscapes = enable;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueryTimeout() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.queryTimeout);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = this.queryTimeout;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueryTimeout(int max) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(max));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (max < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.queryTimeout = max;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.doCancel();
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doCancel() throws SQLException {
        boolean connectionHasBeenCancelled = false;
        if (this.closed) {
            return connectionHasBeenCancelled;
        }
        if (this.connection.statementHoldingLine != null) {
            this.freeLine();
        } else if (this.cancelLock.enterCanceling()) {
            try {
                connectionHasBeenCancelled = true;
                this.connection.cancelOperationOnServer(true);
            }
            finally {
                this.cancelLock.exitCanceling();
            }
        } else {
            return connectionHasBeenCancelled;
        }
        OracleStatement s2 = this.children;
        while (s2 != null) {
            connectionHasBeenCancelled = connectionHasBeenCancelled || s2.doCancel();
            s2 = s2.nextChild;
        }
        this.connection.releaseLineForCancel();
        return connectionHasBeenCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.sqlWarning);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            sQLWarning = this.sqlWarning;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return sQLWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.sqlWarning = null;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void foundPlsqlCompilerWarning() throws SQLException {
        block18: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                SQLWarning w = DatabaseError.addSqlWarning(this.sqlWarning, "Found Plsql compiler warnings.", 24439);
                if (this.sqlWarning != null) {
                    this.sqlWarning.setNextWarning(w);
                    if (!TRACE || !OracleLog.recursiveEnter()) break block18;
                    try {
                        OracleStatement.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + "found Plsql compile warning");
                        break block18;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.sqlWarning = w;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorName(String name) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block37: {
                block36: {
                    OracleResultSetImpl oracleResultSetImpl;
                    __ol_nanos__ = 0L;
                    try {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                            __ol_nanos__ = System.nanoTime();
                        }
                        if (this.userRsetType != 1) break block36;
                        if (!this.sqlKind.isSELECT()) break block37;
                        if (this.currentResultSet == null) {
                            this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.currentResultSet);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        oracleResultSetImpl = this.currentResultSet;
                        if (!TRACE) return oracleResultSetImpl;
                    }
                    catch (Throwable throwable) {
                        if (!TRACE) throw throwable;
                        if (!OracleLog.recursiveEnter()) throw throwable;
                        try {
                            OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                            throw throwable;
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (!OracleLog.recursiveEnter()) return oracleResultSetImpl;
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    return oracleResultSetImpl;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.scrollRset);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleResultSet oracleResultSet = this.scrollRset;
                if (!TRACE) return oracleResultSet;
                if (!OracleLog.recursiveEnter()) return oracleResultSet;
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return oracleResultSet;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet resultSet = null;
            if (!TRACE) return resultSet;
            if (!OracleLog.recursiveEnter()) return resultSet;
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateCount() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                int l_updateCount = -1;
                switch (this.sqlKind) {
                    case UNINITIALIZED: 
                    case SELECT_FOR_UPDATE: 
                    case SELECT: {
                        break;
                    }
                    case ALTER_SESSION: 
                    case OTHER: {
                        if (!this.noMoreUpdateCounts) {
                            l_updateCount = this.rowsProcessed;
                        }
                        this.noMoreUpdateCounts = true;
                        break;
                    }
                    case PLSQL_BLOCK: 
                    case CALL_BLOCK: {
                        this.noMoreUpdateCounts = true;
                        break;
                    }
                    case DELETE: 
                    case INSERT: 
                    case MERGE: 
                    case UPDATE: {
                        if (!this.noMoreUpdateCounts) {
                            l_updateCount = this.rowsProcessed;
                        }
                        this.noMoreUpdateCounts = true;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l_updateCount);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = l_updateCount;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() throws SQLException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = false;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendBatch() throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = 0;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareForNewResults(boolean resetPrefetch, boolean clearStreamList) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(resetPrefetch) + ", " + OracleLog.argument(clearStreamList));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.clearWarnings();
            if (this.streamList != null) {
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + exc);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
                if (clearStreamList) {
                    OracleInputStream s2 = this.streamList;
                    OracleInputStream prev = null;
                    this.streamList = null;
                    while (s2 != null) {
                        if (!s2.hasBeenOpen) {
                            if (prev == null) {
                                this.streamList = s2;
                            } else {
                                prev.nextStream = s2;
                            }
                            prev = s2;
                        }
                        s2 = s2.nextStream;
                    }
                }
            }
            if (this.currentResultSet != null) {
                this.currentResultSet.internal_close(true);
                this.currentResultSet = null;
            }
            this.currentRow = -1;
            this.checkSum = 0L;
            this.checkSumComputationFailure = false;
            this.validRows = 0;
            if (resetPrefetch) {
                this.totalRowsVisited = 0;
            }
            this.gotLastBatch = false;
            if (this.needToParse && !this.columnsDefinedByUser) {
                if (clearStreamList && this.numberOfDefinePositions != 0) {
                    this.numberOfDefinePositions = 0;
                }
                this.needToPrepareDefineBuffer = true;
            }
            if (resetPrefetch && this.rowPrefetch != this.defaultRowPrefetch && this.streamList == null) {
                this.rowPrefetch = this.defaultRowPrefetch;
                this.rowPrefetchChanged = true;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reopenStreams() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleInputStream is = this.streamList;
            while (is != null) {
                if (is.hasBeenOpen) {
                    is = is.accessor.initForNewRow();
                }
                is.closed = false;
                is.hasBeenOpen = true;
                is = is.nextStream;
            }
            this.nextStream = this.streamList;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endOfResultSet(boolean dont_call_prepare_for_new_result) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(dont_call_prepare_for_new_result));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!dont_call_prepare_for_new_result) {
                this.prepareForNewResults(false, false);
            }
            this.clearDefines();
            this.rowPrefetchInLastFetch = -1;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wasNullValue() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.lastIndex == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 24);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.sqlKind.isSELECT()) {
                boolean __result__ = this.accessors[this.lastIndex - 1].isNull(this.currentRow);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = __result__;
                return bl;
            }
            boolean __result__ = this.outBindAccessors[this.lastIndex - 1].isNull(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getColumnIndex(String columnName) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.ensureOpen();
            if (!this.describedWithNames) {
                PhysicalConnection physicalConnection = this.connection;
                synchronized (physicalConnection) {
                    this.doDescribe(true);
                    this.described = true;
                    this.describedWithNames = true;
                }
            }
            for (int index = 0; index < this.numberOfDefinePositions; ++index) {
                if (!this.accessors[index].columnName.equalsIgnoreCase(columnName)) continue;
                int __result__ = index + 1;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = __result__;
                return n2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getJDBCType(int internalType) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(internalType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int result = 0;
            switch (internalType) {
                case 6: {
                    result = 2;
                    break;
                }
                case 100: {
                    result = 100;
                    break;
                }
                case 101: {
                    result = 101;
                    break;
                }
                case 999: {
                    result = 999;
                    break;
                }
                case 96: {
                    result = 1;
                    break;
                }
                case 1: {
                    result = 12;
                    break;
                }
                case 8: {
                    result = -1;
                    break;
                }
                case 12: {
                    result = 91;
                    break;
                }
                case 180: {
                    result = 93;
                    break;
                }
                case 181: {
                    result = -101;
                    break;
                }
                case 231: {
                    result = -102;
                    break;
                }
                case 182: {
                    result = -103;
                    break;
                }
                case 183: {
                    result = -104;
                    break;
                }
                case 23: {
                    result = -2;
                    break;
                }
                case 24: {
                    result = -4;
                    break;
                }
                case 104: {
                    result = -8;
                    break;
                }
                case 113: {
                    result = 2004;
                    break;
                }
                case 112: {
                    result = 2005;
                    break;
                }
                case 114: {
                    result = -13;
                    break;
                }
                case 102: {
                    result = -10;
                    break;
                }
                case 109: {
                    result = 2002;
                    break;
                }
                case 111: {
                    result = 2006;
                    break;
                }
                case 998: {
                    result = -14;
                    break;
                }
                case 995: {
                    result = 0;
                    break;
                }
                default: {
                    result = internalType;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = result;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getInternalType(int externalType) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(externalType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int result = 0;
            switch (externalType) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    result = 6;
                    break;
                }
                case 100: {
                    result = 100;
                    break;
                }
                case 101: {
                    result = 101;
                    break;
                }
                case 999: {
                    result = 999;
                    break;
                }
                case 1: {
                    result = 96;
                    break;
                }
                case -15: 
                case -9: 
                case 12: {
                    result = 1;
                    break;
                }
                case -16: 
                case -1: {
                    result = 8;
                    break;
                }
                case 91: 
                case 92: {
                    result = 12;
                    break;
                }
                case -100: 
                case 93: {
                    result = 180;
                    break;
                }
                case -101: {
                    result = 181;
                    break;
                }
                case -102: {
                    result = 231;
                    break;
                }
                case -103: {
                    result = 182;
                    break;
                }
                case -104: {
                    result = 183;
                    break;
                }
                case -3: 
                case -2: {
                    result = 23;
                    break;
                }
                case -4: {
                    result = 24;
                    break;
                }
                case -8: {
                    result = 104;
                    break;
                }
                case 2004: {
                    result = 113;
                    break;
                }
                case 2005: 
                case 2011: {
                    result = 112;
                    break;
                }
                case -13: {
                    result = 114;
                    break;
                }
                case -10: {
                    result = 102;
                    break;
                }
                case 2002: 
                case 2003: 
                case 2007: 
                case 2008: 
                case 2009: {
                    result = 109;
                    break;
                }
                case 2006: {
                    result = 111;
                    break;
                }
                case -14: {
                    result = 998;
                    break;
                }
                case 70: {
                    result = 1;
                    break;
                }
                case 0: {
                    result = 995;
                    break;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + Integer.toString(externalType));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, Integer.toString(externalType));
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = result;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void describe() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.ensureOpen();
                if (!this.described) {
                    this.doDescribe(false);
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeLine() throws SQLException {
        block21: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.streamList == null) break block21;
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + exc);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeUsedStreams(int columnIndex) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(columnIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            while (this.nextStream != null && this.nextStream.columnIndex < columnIndex) {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "closing " + this.nextStream + " at index " + this.nextStream.columnIndex);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.nextStream.close();
                }
                catch (IOException exc) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + exc);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureOpen() throws SQLException {
        block24: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.connection.lifecycle != 1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (!this.closed) break block24;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocateTmpByteArray() {
        block17: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block17;
                try {
                    OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "for Thin only");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int direction) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block24: {
                __ol_nanos__ = 0L;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(direction));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if (direction == 1000) {
                        this.defaultFetchDirection = direction;
                        break block24;
                    }
                    if (direction == 1001 || direction == 1002) {
                        this.defaultFetchDirection = 1000;
                        this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
                        break block24;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "setFetchDirection");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchDirection");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchDirection() throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.defaultFetchDirection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.defaultFetchDirection;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int rows) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rows));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.setPrefetchInternal(rows, false, true);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = this.getPrefetchInternal(true);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetConcurrency() throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = ResultSetUtil.getUpdateConcurrency(this.userRsetType);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetType() throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = ResultSetUtil.getScrollType(this.userRsetType);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        OracleConnection oracleConnection;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleConnection __result__ = this.connection.getWrapper();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracleConnection = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oracleConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResultSetCache(oracle.jdbc.OracleResultSetCache cache) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cache));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    if (cache == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (this.rsetCache != null) {
                        this.rsetCache.close();
                    }
                    this.rsetCache = cache;
                }
                catch (IOException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultSetCache(OracleResultSetCache cache) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cache));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.setResultSetCache((oracle.jdbc.OracleResultSetCache)cache);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleResultSetCache getResultSetCache() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetCache oracleResultSetCache;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                OracleResultSetCache __result__ = (OracleResultSetCache)this.rsetCache;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleResultSetCache = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleResultSetCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOracleBatchStyle() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initBatch() {
        block17: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block17;
                try {
                    OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "do nothing");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getBatchSize() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.m_batchItems == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = 0;
                return n2;
            }
            int __result__ = this.m_batchItems.size();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = __result__;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBatchItem(String sql) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sql));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.m_batchItems == null) {
                this.m_batchItems = new Vector();
            }
            this.m_batchItems.addElement(sql);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getBatchItem(int index) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(index));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String __result__ = (String)this.m_batchItems.elementAt(index);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearBatchItems() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.m_batchItems.removeAllElements();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkIfJdbcBatchExists() throws SQLException {
        block18: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.getBatchSize() <= 0) break block18;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 81 + "batch must be either executed or cleared");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String sql) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.addBatchItem(sql);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.clearBatchItems();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] executeBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int[] nArray;
            int n_batches;
            int i2;
            long __ol_nanos__;
            block66: {
                __ol_nanos__ = 0L;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.cleanOldTempLobs();
                i2 = 0;
                n_batches = this.getBatchSize();
                this.checkSum = 0L;
                this.checkSumComputationFailure = false;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "batch size is " + n_batches);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (n_batches > 0) break block66;
                int[] __result__ = new int[]{};
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int[] nArray2 = __result__;
                if (!TRACE) return nArray2;
                if (!OracleLog.recursiveEnter()) return nArray2;
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return nArray2;
            }
            try {
                int[] ret_array = new int[n_batches];
                this.ensureOpen();
                this.prepareForNewResults(true, true);
                int number_of_define_positions_saved = this.numberOfDefinePositions;
                String saved_sql = this.sqlObject.getOriginalSql();
                OracleStatement.SqlKind saved_sql_kind = this.sqlKind;
                this.noMoreUpdateCounts = false;
                int save_valid_rows = 0;
                try {
                    this.connection.registerHeartbeat();
                    this.connection.needLine();
                    for (i2 = 0; i2 < n_batches; ++i2) {
                        this.sqlObject.initialize(this.getBatchItem(i2));
                        this.sqlKind = this.sqlObject.getSqlKind();
                        this.needToParse = true;
                        this.numberOfDefinePositions = 0;
                        this.rowsProcessed = 0;
                        this.currentRank = 1;
                        if (this.sqlKind.isSELECT()) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing BatchUpdateException: " + 80 + "invalid SELECT batch command " + i2 + i2 + ret_array);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            BatchUpdateException __ex__ = DatabaseError.createBatchUpdateException(80, "invalid SELECT batch command " + i2, i2, ret_array);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        if (!this.isOpen) {
                            this.connection.open(this);
                            this.isOpen = true;
                        }
                        int ret_val = -1;
                        try {
                            if (this.queryTimeout != 0) {
                                this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                            }
                            this.cancelLock.enterExecuting();
                            this.executeForRows(false);
                            if (this.validRows > 0) {
                                save_valid_rows += this.validRows;
                            }
                            ret_val = this.validRows;
                        }
                        catch (SQLException ea) {
                            this.needToParse = true;
                            this.resetCurrentRowBinders();
                            throw ea;
                        }
                        finally {
                            if (this.queryTimeout != 0) {
                                this.connection.getTimeout().cancelTimeout();
                            }
                            this.validRows = save_valid_rows;
                            this.cancelLock.exitExecuting();
                            this.checkValidRowsStatus();
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "batch item " + i2 + ": return=" + ret_val);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        ret_array[i2] = ret_val;
                        if (ret_array[i2] >= 0) continue;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing BatchUpdateException: " + 81 + "command return value " + ret_array[i2] + i2 + ret_array);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        BatchUpdateException __ex__ = DatabaseError.createBatchUpdateException(81, "command return value " + ret_array[i2], i2, ret_array);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
                catch (SQLException e1) {
                    if (e1 instanceof BatchUpdateException) {
                        throw e1;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing BatchUpdateException: " + 81 + e1.getMessage() + i2 + ret_array);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    BatchUpdateException __ex__ = DatabaseError.createBatchUpdateException(81, e1.getMessage(), i2, ret_array);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                finally {
                    this.clearBatchItems();
                    this.numberOfDefinePositions = number_of_define_positions_saved;
                    if (saved_sql != null) {
                        this.sqlObject.initialize(saved_sql);
                        this.sqlKind = saved_sql_kind;
                    }
                    this.currentRank = 0;
                }
                this.connection.registerHeartbeat();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret_array);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                nArray = ret_array;
                if (!TRACE) return nArray;
            }
            catch (Throwable throwable) {
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    throw throwable;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!OracleLog.recursiveEnter()) return nArray;
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int copyBinds(Statement toStmt, int offset) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = 0;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCloseRset() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.scrollRset = null;
            this.endOfResultSet(false);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOriginalSql() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String __result__ = this.sqlObject.getOriginalSql();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doScrollExecuteCommon() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.scrollRset != null) {
                this.scrollRset.close();
                this.scrollRset = null;
            }
            if (!this.sqlKind.isSELECT()) {
                this.doExecuteWithTimeout();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            if (!this.needToAddIdentifier) {
                this.doExecuteWithTimeout();
                this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                this.realRsetType = this.userRsetType;
            } else {
                try {
                    this.sqlObject.setIncludeRowid(true);
                    this.needToParse = true;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "revised SQL:<" + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals) + ">");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.prepareForNewResults(true, false);
                    if (this.columnsDefinedByUser) {
                        Accessor[] oldaccs = this.accessors;
                        if (this.accessors == null || this.accessors.length <= this.numberOfDefinePositions) {
                            this.accessors = new Accessor[this.numberOfDefinePositions + 1];
                        }
                        if (oldaccs != null) {
                            for (int i2 = this.numberOfDefinePositions; i2 > 0; --i2) {
                                Accessor accessor;
                                this.accessors[i2] = accessor = oldaccs[i2 - 1];
                                if (!accessor.isColumnNumberAware) continue;
                                accessor.updateColumnNumber(i2);
                            }
                        }
                        this.allocateRowidAccessor();
                        ++this.numberOfDefinePositions;
                    }
                    this.doExecuteWithTimeout();
                    this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                    this.realRsetType = this.userRsetType;
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            e2.printStackTrace(pw);
                            OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + sw.toString());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.realRsetType = this.userRsetType > 3 ? 3 : 1;
                    this.sqlObject.setIncludeRowid(false);
                    this.needToParse = true;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "Trying type " + this.realRsetType + "...");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.prepareForNewResults(true, false);
                    if (this.columnsDefinedByUser) {
                        this.needToPrepareDefineBuffer = true;
                        --this.numberOfDefinePositions;
                        System.arraycopy(this.accessors, 1, this.accessors, 0, this.numberOfDefinePositions);
                        this.accessors[this.numberOfDefinePositions] = null;
                        for (int i3 = 0; i3 < this.numberOfDefinePositions; ++i3) {
                            Accessor accessor = this.accessors[i3];
                            if (!accessor.isColumnNumberAware) continue;
                            accessor.updateColumnNumber(i3);
                        }
                    }
                    this.moveAllTempLobsToFree();
                    this.doExecuteWithTimeout();
                    this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                    this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 91, e2.getMessage());
                }
            }
            this.scrollRset = ResultSetUtil.createScrollResultSet(this, this.currentResultSet, this.realRsetType);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocateRowidAccessor() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.accessors[0] = new RowidAccessor(this, 128, 1, -8, false);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleResultSet doScrollStmtExecuteQuery() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.doScrollExecuteCommon();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.scrollRset);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleResultSet oracleResultSet = this.scrollRset;
            return oracleResultSet;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDmlReturningBind() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.returnResultSet != null) {
                this.returnResultSet.close();
            }
            this.returnParamsFetched = false;
            this.returnParamRowBytes = 0;
            this.returnParamRowChars = 0;
            int count = 0;
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                Accessor accessor = this.returnParamAccessors[i2];
                if (accessor == null) continue;
                ++count;
                if (accessor.charLength > 0) {
                    this.returnParamRowChars += accessor.charLength;
                    continue;
                }
                this.returnParamRowBytes += accessor.byteLength;
            }
            if (this.isAutoGeneratedKey) {
                this.numReturnParams = count;
            } else {
                if (this.numReturnParams <= 0) {
                    this.numReturnParams = this.sqlObject.getReturnParameterCount();
                }
                if (this.numReturnParams != count) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 173);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 173);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            this.returnParamMeta[0] = this.numReturnParams;
            this.returnParamMeta[1] = this.returnParamRowBytes;
            this.returnParamMeta[2] = this.returnParamRowChars;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocateDmlReturnStorage() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.rowsDmlReturned == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            int totalBytes = this.returnParamRowBytes * this.rowsDmlReturned;
            int totalChars = this.returnParamRowChars * this.rowsDmlReturned;
            int indicatorLength = 2 * this.numReturnParams * this.rowsDmlReturned;
            this.returnParamBytes = new byte[totalBytes];
            this.returnParamChars = new char[totalChars];
            this.returnParamIndicators = new short[indicatorLength];
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                Accessor accessor = this.returnParamAccessors[i2];
                if (accessor == null || accessor.internalType != 111 && accessor.internalType != 109) continue;
                TypeAccessor typeAccessor = (TypeAccessor)accessor;
                if (typeAccessor.pickledBytes != null && typeAccessor.pickledBytes.length >= this.rowsDmlReturned) continue;
                typeAccessor.pickledBytes = new byte[this.rowsDmlReturned][];
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchDmlReturnParams() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupReturnParamAccessors() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.rowsDmlReturned == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            int byteOffset = 0;
            int charOffset = 0;
            int indOffset = 0;
            int lenOffset = this.numReturnParams * this.rowsDmlReturned;
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                Accessor accessor = this.returnParamAccessors[i2];
                if (accessor == null) continue;
                if (accessor.charLength > 0) {
                    accessor.rowSpaceChar = this.returnParamChars;
                    accessor.columnIndex = charOffset;
                    charOffset += this.rowsDmlReturned * accessor.charLength;
                } else {
                    accessor.rowSpaceByte = this.returnParamBytes;
                    accessor.columnIndex = byteOffset;
                    byteOffset += this.rowsDmlReturned * accessor.byteLength;
                }
                accessor.rowSpaceIndicator = this.returnParamIndicators;
                accessor.indicatorIndex = indOffset;
                indOffset += this.rowsDmlReturned;
                accessor.lengthIndex = lenOffset;
                lenOffset += this.rowsDmlReturned;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerReturnParameterInternal(int index, int internalType, int externalType, int maxSize, short form, String typeName) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(index) + ", " + OracleLog.argument(internalType) + ", " + OracleLog.argument(externalType) + ", " + OracleLog.argument(maxSize) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.returnParamAccessors == null) {
                this.returnParamAccessors = new Accessor[this.numberOfBindPositions];
            }
            if (this.returnParamMeta == null) {
                this.returnParamMeta = new int[3 + this.numberOfBindPositions * 4];
            }
            switch (externalType) {
                case -16: 
                case -15: 
                case -9: 
                case 2011: {
                    form = (short)2;
                    break;
                }
                case 2009: {
                    typeName = "SYS.XMLTYPE";
                    break;
                }
            }
            Accessor accessor = this.allocateAccessor(internalType, externalType, index + 1, maxSize, form, typeName, true);
            accessor.isDMLReturnedParam = true;
            this.returnParamAccessors[index] = accessor;
            boolean isCharType = accessor.charLength > 0;
            this.returnParamMeta[3 + index * 4 + 0] = accessor.defineType;
            this.returnParamMeta[3 + index * 4 + 1] = isCharType ? 1 : 0;
            this.returnParamMeta[3 + index * 4 + 2] = isCharType ? accessor.charLength : accessor.byteLength;
            this.returnParamMeta[3 + index * 4 + 3] = form;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int creationState() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.creationState);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = this.creationState;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColumnSetNull(int index) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(index));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.columnSetNull);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.columnSetNull;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNCHAR(int columnIndex) throws SQLException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            boolean result;
            int index;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.described) {
                this.describe();
            }
            if ((index = columnIndex - 1) < 0 || index >= this.numberOfDefinePositions) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean bl2 = result = this.accessors[index].formOfUse == 2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = result;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(OracleStatement child) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(child));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            child.nextChild = this.children;
            this.children = child;
            child.parent = this;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChild(OracleStatement child) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(child));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (child == this.children) {
                this.children = child.nextChild;
            } else {
                OracleStatement c2 = this.children;
                while (c2.nextChild != child) {
                    c2 = c2.nextChild;
                }
                c2.nextChild = child.nextChild;
            }
            child.parent = null;
            child.nextChild = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(current));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        OracleReturnResultSet oracleReturnResultSet;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (!this.isAutoGeneratedKey) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.returnParamAccessors == null || this.numReturnParams == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 144);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.returnResultSet == null) {
                this.returnResultSet = new OracleReturnResultSet(this);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.returnResultSet);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oracleReturnResultSet = this.returnResultSet;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oracleReturnResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int n2;
        long __ol_nanos__;
        block33: {
            int n3;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(autoGeneratedKeys));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.autoKeyInfo = new AutoKeyInfo(sql);
                if (autoGeneratedKeys != 2 && this.autoKeyInfo.isInsertSqlStmt()) break block33;
                this.autoKeyInfo = null;
                int __result__ = this.executeUpdate(sql);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n3 = __result__;
                if (!TRACE) return n3;
            }
            catch (Throwable throwable) {
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    throw throwable;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!OracleLog.recursiveEnter()) return n3;
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                return n3;
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        if (autoGeneratedKeys != 1) {
            this.autoKeyInfo = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            String newSql = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = 1;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            int __result__ = this.executeUpdateInternal(newSql);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        if (!TRACE) return n2;
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            return n2;
        }
        finally {
            OracleLog.recursiveExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int n2;
        long __ol_nanos__;
        block34: {
            int n3;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(columnIndexes));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (columnIndexes == null || columnIndexes.length == 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.autoKeyInfo = new AutoKeyInfo(sql, columnIndexes);
                if (this.autoKeyInfo.isInsertSqlStmt()) break block34;
                this.autoKeyInfo = null;
                int __result__ = this.executeUpdate(sql);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n3 = __result__;
                if (!TRACE) return n3;
            }
            catch (Throwable throwable) {
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    throw throwable;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!OracleLog.recursiveEnter()) return n3;
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                return n3;
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            this.connection.doDescribeTable(this.autoKeyInfo);
            String newSql = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = columnIndexes.length;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            int __result__ = this.executeUpdateInternal(newSql);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        if (!TRACE) return n2;
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            return n2;
        }
        finally {
            OracleLog.recursiveExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int n2;
        long __ol_nanos__;
        block34: {
            int n3;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(columnNames));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (columnNames == null || columnNames.length == 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.autoKeyInfo = new AutoKeyInfo(sql, columnNames);
                if (this.autoKeyInfo.isInsertSqlStmt()) break block34;
                this.autoKeyInfo = null;
                int __result__ = this.executeUpdate(sql);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n3 = __result__;
                if (!TRACE) return n3;
            }
            catch (Throwable throwable) {
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    throw throwable;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!OracleLog.recursiveEnter()) return n3;
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                return n3;
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            this.connection.doDescribeTable(this.autoKeyInfo);
            String newSql = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = columnNames.length;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            int __result__ = this.executeUpdateInternal(newSql);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        if (!TRACE) return n2;
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            return n2;
        }
        finally {
            OracleLog.recursiveExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean bl;
        long __ol_nanos__;
        block33: {
            boolean bl2;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(autoGeneratedKeys));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.autoKeyInfo = new AutoKeyInfo(sql);
                if (autoGeneratedKeys != 2 && this.autoKeyInfo.isInsertSqlStmt()) break block33;
                this.autoKeyInfo = null;
                boolean __result__ = this.execute(sql);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl2 = __result__;
                if (!TRACE) return bl2;
            }
            catch (Throwable throwable) {
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    throw throwable;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!OracleLog.recursiveEnter()) return bl2;
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                return bl2;
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        if (autoGeneratedKeys != 1) {
            this.autoKeyInfo = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            String newSql = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = 1;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            boolean __result__ = this.executeInternal(newSql);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        if (!TRACE) return bl;
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            return bl;
        }
        finally {
            OracleLog.recursiveExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean bl;
        long __ol_nanos__;
        block34: {
            boolean bl2;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(columnIndexes));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (columnIndexes == null || columnIndexes.length == 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.autoKeyInfo = new AutoKeyInfo(sql, columnIndexes);
                if (this.autoKeyInfo.isInsertSqlStmt()) break block34;
                this.autoKeyInfo = null;
                boolean __result__ = this.execute(sql);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl2 = __result__;
                if (!TRACE) return bl2;
            }
            catch (Throwable throwable) {
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    throw throwable;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!OracleLog.recursiveEnter()) return bl2;
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                return bl2;
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            this.connection.doDescribeTable(this.autoKeyInfo);
            String newSql = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = columnIndexes.length;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            boolean __result__ = this.executeInternal(newSql);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        if (!TRACE) return bl;
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            return bl;
        }
        finally {
            OracleLog.recursiveExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean bl;
        long __ol_nanos__;
        block34: {
            boolean bl2;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(columnNames));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (columnNames == null || columnNames.length == 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.autoKeyInfo = new AutoKeyInfo(sql, columnNames);
                if (this.autoKeyInfo.isInsertSqlStmt()) break block34;
                this.autoKeyInfo = null;
                boolean __result__ = this.execute(sql);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl2 = __result__;
                if (!TRACE) return bl2;
            }
            catch (Throwable throwable) {
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    throw throwable;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!OracleLog.recursiveEnter()) return bl2;
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                return bl2;
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.isAutoGeneratedKey = true;
            this.connection.doDescribeTable(this.autoKeyInfo);
            String newSql = this.autoKeyInfo.getNewSql();
            this.numberOfBindPositions = columnNames.length;
            this.autoKeyRegisterReturnParams();
            this.processDmlReturningBind();
            boolean __result__ = this.executeInternal(newSql);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        if (!TRACE) return bl;
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            return bl;
        }
        finally {
            OracleLog.recursiveExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetHoldability() throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = 1;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getcacheState() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.cacheState);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.cacheState;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getstatementType() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.statementType);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.statementType;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getserverCursor() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.serverCursor);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.serverCursor;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeIndicatorSubRange() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.bindIndicatorSubRange = 0;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoKeyRegisterReturnParams() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.initializeIndicatorSubRange();
            int preambleSize = this.bindIndicatorSubRange + 5 + this.numberOfBindPositions * 10;
            int indicatorSize = preambleSize + 2 * this.numberOfBindPositions;
            this.bindIndicators = new short[indicatorSize];
            int metadataOffset = this.bindIndicatorSubRange;
            this.bindIndicators[metadataOffset + 0] = (short)this.numberOfBindPositions;
            this.bindIndicators[metadataOffset + 1] = 0;
            this.bindIndicators[metadataOffset + 2] = 1;
            this.bindIndicators[metadataOffset + 3] = 0;
            this.bindIndicators[metadataOffset + 4] = 1;
            metadataOffset += 5;
            short[] formOfUses = this.autoKeyInfo.tableFormOfUses;
            int[] columnIndexes = this.autoKeyInfo.columnIndexes;
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                short form;
                this.bindIndicators[metadataOffset + 0] = 994;
                short s2 = form = this.connection.defaultnchar ? (short)2 : 1;
                if (formOfUses != null && columnIndexes != null && formOfUses[columnIndexes[i2] - 1] == 2) {
                    this.bindIndicators[metadataOffset + 9] = form = 2;
                }
                metadataOffset += 10;
                this.checkTypeForAutoKey(this.autoKeyInfo.returnTypes[i2]);
                String typeName = null;
                if (this.autoKeyInfo.returnTypes[i2] == 111) {
                    typeName = this.autoKeyInfo.tableTypeNames[columnIndexes[i2] - 1];
                }
                this.registerReturnParameterInternal(i2, this.autoKeyInfo.returnTypes[i2], this.autoKeyInfo.returnTypes[i2], -1, form, typeName);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setNonAutoKey() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.isAutoGeneratedKey = false;
            this.numberOfBindPositions = 0;
            this.bindIndicators = null;
            this.returnParamMeta = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDefineBuffersIfRequired(char[] tmpDefineChars, byte[] tmpDefineBytes, short[] tmpDefineIndicators, boolean isIndicatorsReused) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tmpDefineChars) + ", " + OracleLog.argument(tmpDefineBytes) + ", " + OracleLog.argument(tmpDefineIndicators) + ", " + OracleLog.argument(isIndicatorsReused));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (tmpDefineChars != this.defineChars) {
                this.connection.cacheBuffer(tmpDefineChars);
            }
            if (tmpDefineBytes != this.defineBytes) {
                this.connection.cacheBuffer(tmpDefineBytes);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkTypeForAutoKey(int type) throws SQLException {
        block18: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(type));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (type != 109) break block18;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 5);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 5);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    void moveAllTempLobsToFree() {
        if (this.oldTempClobsToFree != null) {
            if (this.tempClobsToFree == null) {
                this.tempClobsToFree = this.oldTempClobsToFree;
            } else {
                this.tempClobsToFree.add(this.oldTempClobsToFree);
            }
            this.oldTempClobsToFree = null;
        }
        if (this.oldTempBlobsToFree != null) {
            if (this.tempBlobsToFree == null) {
                this.tempBlobsToFree = this.oldTempBlobsToFree;
            } else {
                this.tempBlobsToFree.add(this.oldTempBlobsToFree);
            }
            this.oldTempBlobsToFree = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveTempLobsToFree(CLOB tclob) {
        long __ol_nanos__ = 0L;
        try {
            int index;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tclob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.oldTempClobsToFree != null && (index = this.oldTempClobsToFree.indexOf(tclob)) != -1) {
                this.addToTempLobsToFree(tclob);
                this.oldTempClobsToFree.remove(index);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveTempLobsToFree(BLOB tblob) {
        long __ol_nanos__ = 0L;
        try {
            int index;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tblob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.oldTempBlobsToFree != null && (index = this.oldTempBlobsToFree.indexOf(tblob)) != -1) {
                this.addToTempLobsToFree(tblob);
                this.oldTempBlobsToFree.remove(index);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToTempLobsToFree(CLOB tclob) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tclob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.tempClobsToFree == null) {
                this.tempClobsToFree = new ArrayList();
            }
            this.tempClobsToFree.add(tclob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToTempLobsToFree(BLOB tblob) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tblob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.tempBlobsToFree == null) {
                this.tempBlobsToFree = new ArrayList();
            }
            this.tempBlobsToFree.add(tblob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToOldTempLobsToFree(CLOB tclob) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tclob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.oldTempClobsToFree == null) {
                this.oldTempClobsToFree = new ArrayList();
            }
            this.oldTempClobsToFree.add(tclob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToOldTempLobsToFree(BLOB tblob) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tblob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.oldTempBlobsToFree == null) {
                this.oldTempBlobsToFree = new ArrayList();
            }
            this.oldTempBlobsToFree.add(tblob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAllTempLobs() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.cleanTempClobs(this.tempClobsToFree);
            this.tempClobsToFree = null;
            this.cleanTempBlobs(this.tempBlobsToFree);
            this.tempBlobsToFree = null;
            this.cleanTempClobs(this.oldTempClobsToFree);
            this.oldTempClobsToFree = null;
            this.cleanTempBlobs(this.oldTempBlobsToFree);
            this.oldTempBlobsToFree = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanOldTempLobs() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.cleanTempClobs(this.oldTempClobsToFree);
            this.cleanTempBlobs(this.oldTempBlobsToFree);
            this.oldTempClobsToFree = this.tempClobsToFree;
            this.tempClobsToFree = null;
            this.oldTempBlobsToFree = this.tempBlobsToFree;
            this.tempBlobsToFree = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanTempClobs(ArrayList x) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (x != null) {
                Iterator iter = x.iterator();
                while (iter.hasNext()) {
                    try {
                        ((CLOB)iter.next()).freeTemporary();
                    }
                    catch (SQLException e2) {
                        if (!TRACE || !OracleLog.recursiveEnter()) continue;
                        try {
                            OracleStatement.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + " exception " + e2.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanTempBlobs(ArrayList x) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(x));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (x != null) {
                Iterator iter = x.iterator();
                while (iter.hasNext()) {
                    try {
                        ((BLOB)iter.next()).freeTemporary();
                    }
                    catch (SQLException e2) {
                        if (!TRACE || !OracleLog.recursiveEnter()) continue;
                        try {
                            OracleStatement.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + " exception " + e2.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    TimeZone getDefaultTimeZone() throws SQLException {
        return this.getDefaultTimeZone(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimeZone getDefaultTimeZone(boolean processDST) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.defaultTimeZone == null) {
                block25: {
                    try {
                        this.defaultTimeZone = this.connection.getDefaultTimeZone();
                    }
                    catch (SQLException ea) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block25;
                        try {
                            OracleStatement.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + " exception XXXXX " + ea.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                if (this.defaultTimeZone == null) {
                    this.defaultTimeZone = TimeZone.getDefault();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.defaultTimeZone);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TimeZone timeZone = this.defaultTimeZone;
            return timeZone;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public void setDatabaseChangeRegistration(DatabaseChangeRegistration _registration) throws SQLException {
        this.registration = (NTFDCNRegistration)_registration;
    }

    @Override
    public String[] getRegisteredTableNames() throws SQLException {
        return this.dcnTableName;
    }

    @Override
    public long getRegisteredQueryId() throws SQLException {
        return this.dcnQueryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Calendar getDefaultCalendar() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.defaultCalendar == null) {
                this.defaultCalendar = Calendar.getInstance(this.getDefaultTimeZone(), Locale.US);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.defaultCalendar);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Calendar calendar = this.defaultCalendar;
            return calendar;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    void releaseBuffers() {
        this.cachedDefineIndicatorSize = this.defineIndicators != null ? this.defineIndicators.length : 0;
        this.cachedDefineMetaDataSize = this.defineMetaData != null ? this.defineMetaData.length : 0;
        this.connection.cacheBuffer(this.defineChars);
        this.defineChars = null;
        this.connection.cacheBuffer(this.defineBytes);
        this.defineBytes = null;
        this.defineIndicators = null;
        this.defineMetaData = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPoolable() throws SQLException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean bl2 = __result__ = this.cacheState != 3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(poolable));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.cacheState = poolable ? 1 : 3;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        block24: {
            boolean bl;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(iface));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!iface.isInterface()) break block24;
                boolean __result__ = iface.isInstance(this);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 177);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        block24: {
            OracleStatement oracleStatement;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(iface));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!iface.isInterface() || !iface.isInstance(this)) break block24;
                OracleStatement __result__ = this;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleStatement = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return (T)oracleStatement;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 177);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PhysicalConnection physicalConnection = this.connection;
            return physicalConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Calendar getGMTCalendar() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.gmtCalendar == null) {
                this.gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.gmtCalendar);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Calendar calendar = this.gmtCalendar;
            return calendar;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    void extractNioDefineBuffers(int value) throws SQLException {
    }

    void processLobPrefetchMetaData(Object[] lobPrefetchMetaData) {
    }

    void internalClose() throws SQLException {
        this.closed = true;
        if (this.currentResultSet != null) {
            this.currentResultSet.closed = true;
        }
        this.cleanupDefines();
        this.bindBytes = null;
        this.bindChars = null;
        this.bindIndicators = null;
        this.outBindAccessors = null;
        this.parameterStream = null;
        this.userStream = null;
        this.ibtBindBytes = null;
        this.ibtBindChars = null;
        this.ibtBindIndicators = null;
        this.lobPrefetchMetaData = null;
        this.tmpByteArray = null;
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        if (this.wrapper != null) {
            this.wrapper.close();
        }
    }

    void calculateCheckSum() throws SQLException {
        if (!this.connection.calculateChecksum) {
            return;
        }
        this._checkSum = this.checkSum;
        if (this.accessors != null) {
            this.accessorChecksum(this.accessors);
        }
        if (this.outBindAccessors != null) {
            this.accessorChecksum(this.outBindAccessors);
        }
        if (this.returnParamAccessors != null && this.returnParamsFetched) {
            this.accessorChecksum(this.returnParamAccessors);
        }
        this.checkSum = this._checkSum = CRC64.updateChecksum(this._checkSum, this.validRows);
        this._checkSum = 0L;
    }

    void accessorChecksum(Accessor[] _accessors) throws SQLException {
        int count = 0;
        boolean areAllColumnsLobs = false;
        block4: for (Accessor a2 : _accessors) {
            if (a2 == null) continue;
            switch (a2.internalType) {
                case 112: 
                case 113: 
                case 114: {
                    if (count != 0) continue block4;
                    areAllColumnsLobs = true;
                    continue block4;
                }
                case 8: 
                case 24: {
                    areAllColumnsLobs = false;
                    break block4;
                }
                default: {
                    areAllColumnsLobs = false;
                    ++count;
                    for (int row = 0; row < this.validRows; ++row) {
                        if (a2.rowSpaceIndicator == null) continue;
                        this._checkSum = a2.updateChecksum(this._checkSum, row);
                    }
                }
            }
        }
        if (areAllColumnsLobs) {
            this.checkSumComputationFailure = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getChecksum() throws SQLException {
        long l2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.checkSumComputationFailure) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long __result__ = this.checkSum;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            l2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleStatement.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return l2;
    }

    static final byte convertSqlKindEnumToByte(OracleStatement.SqlKind kind) {
        switch (kind) {
            case DELETE: {
                return 2;
            }
            case INSERT: {
                return 4;
            }
            case MERGE: {
                return 8;
            }
            case UPDATE: {
                return 16;
            }
            case ALTER_SESSION: 
            case OTHER: {
                return -128;
            }
            case PLSQL_BLOCK: {
                return 32;
            }
            case CALL_BLOCK: {
                return 64;
            }
            case SELECT_FOR_UPDATE: 
            case SELECT: {
                return 1;
            }
        }
        if (kind.isPlsqlOrCall()) {
            return 96;
        }
        if (kind.isDML()) {
            return 30;
        }
        return 0;
    }

    static final OracleStatement.SqlKind convertSqlKindByteToEnum(byte kind) {
        switch (kind) {
            case 2: {
                return OracleStatement.SqlKind.DELETE;
            }
            case 4: {
                return OracleStatement.SqlKind.INSERT;
            }
            case 8: {
                return OracleStatement.SqlKind.MERGE;
            }
            case 16: {
                return OracleStatement.SqlKind.UPDATE;
            }
            case -128: {
                return OracleStatement.SqlKind.OTHER;
            }
            case 32: {
                return OracleStatement.SqlKind.PLSQL_BLOCK;
            }
            case 64: {
                return OracleStatement.SqlKind.CALL_BLOCK;
            }
            case 1: {
                return OracleStatement.SqlKind.SELECT;
            }
        }
        return OracleStatement.SqlKind.UNINITIALIZED;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

