/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.pool.OracleOCIConnectionPool;

public abstract class OracleOCIConnection
extends T2CConnection {
    OracleOCIConnectionPool ociConnectionPool;
    boolean isPool;
    boolean aliasing;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleOCIConnection(String ur, Properties info, Object ext) throws SQLException {
        block12: {
            this(ur, info, (OracleDriverExtension)ext);
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(ur) + ", " + OracleLog.argument(info) + ", " + OracleLog.argument(ext));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleOCIConnection(String ur, Properties info, OracleDriverExtension ext) throws SQLException {
        block12: {
            super(ur, info, ext);
            this.ociConnectionPool = null;
            this.isPool = false;
            this.aliasing = false;
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(ur) + ", " + OracleLog.argument(info) + ", " + OracleLog.argument(ext));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getConnectionId() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            byte[] connId;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((connId = this.t2cGetConnectionId(this.m_nativeState)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleOCIConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 254 + "Cannot create a ByteArray for the connectionId");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 254, "Cannot create a ByteArray for the connectionId");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.aliasing = true;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + connId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = connId;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void passwordChange(String user, String oldPassword, String newPassword) throws SQLException, IOException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(user) + ", " + OracleLog.argument("******") + ", " + OracleLog.argument("******"));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.ociPasswordChange(user, oldPassword, newPassword);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.lifecycle == 2 || this.lifecycle == 4 || this.aliasing) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            super.close();
            this.ociConnectionPool.connectionClosed((oracle.jdbc.oci.OracleOCIConnection)this);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConnectionPool(OracleOCIConnectionPool cpool) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cpool));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.ociConnectionPool = cpool;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(size) + ", " + OracleLog.argument(clearMetaData));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            super.setStmtCacheSize(size, clearMetaData);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleOCIConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

