/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.NTFConnection;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.OracleLog;

class NTFListener
extends Thread {
    private NTFConnection[] connections = null;
    private int nbOfConnections = 0;
    private boolean needsToBeClosed = false;
    NTFManager dcnManager;
    ServerSocketChannel ssChannel;
    int tcpport;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFListener(NTFManager _dcnManager, ServerSocketChannel _ssChannel, int _tcpport) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_dcnManager) + ", " + OracleLog.argument(_ssChannel));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.dcnManager = _dcnManager;
            this.connections = new NTFConnection[10];
            this.ssChannel = _ssChannel;
            this.tcpport = _tcpport;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block31: {
            long __ol_nanos__ = 0L;
            try {
                block30: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NTFListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    try {
                        Selector selector = Selector.open();
                        this.ssChannel.register(selector, 16);
                        block22: while (true) {
                            selector.select();
                            if (this.needsToBeClosed) break;
                            Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block22;
                                SelectionKey aKey = iterator.next();
                                if ((aKey.readyOps() & 0x10) != 16) continue;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        NTFListener.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFListener (tcpport=" + this.tcpport + ") thread: OP_ACCEPT");
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                ServerSocketChannel server = (ServerSocketChannel)aKey.channel();
                                SocketChannel connectionChannel = server.accept();
                                NTFConnection conn = new NTFConnection(this.dcnManager, connectionChannel);
                                if (this.connections.length == this.nbOfConnections) {
                                    NTFConnection[] connections2 = new NTFConnection[this.connections.length * 2];
                                    System.arraycopy(this.connections, 0, connections2, 0, this.connections.length);
                                    this.connections = connections2;
                                }
                                this.connections[this.nbOfConnections++] = conn;
                                conn.start();
                                iterator.remove();
                            }
                            break;
                        }
                        selector.close();
                        this.ssChannel.close();
                    }
                    catch (IOException ioe) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block30;
                        try {
                            NTFListener.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFListener (tcpport=" + this.tcpport + "): ERROR: got IOException during thread execution: " + ioe.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block31;
                try {
                    NTFListener.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFListener (tcpport=" + this.tcpport + "): end of run method. Thread will be closed.");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeThisListener() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            for (int i2 = 0; i2 < this.nbOfConnections; ++i2) {
                this.connections[i2].closeThisConnection();
                this.connections[i2].interrupt();
            }
            this.needsToBeClosed = true;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFListener.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver.ntf");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFListener"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

