/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.dcn.QueryChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.NTFDCNTableChanges;
import oracle.jdbc.driver.OracleLog;

class NTFDCNQueryChanges
implements QueryChangeDescription {
    private final long queryId;
    private final QueryChangeDescription.QueryChangeEventType queryopflags;
    private final int numberOfTables;
    private final NTFDCNTableChanges[] tcdesc;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFDCNQueryChanges(ByteBuffer data, int csid) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNQueryChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(data) + ", " + OracleLog.argument(csid));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            long queryId1 = data.getInt() & 0xFFFFFFFF;
            long queryId2 = data.getInt() & 0xFFFFFFFF;
            this.queryId = queryId1 | queryId2 << 32;
            this.queryopflags = QueryChangeDescription.QueryChangeEventType.getQueryChangeEventType(data.getInt());
            this.numberOfTables = data.getShort();
            this.tcdesc = new NTFDCNTableChanges[this.numberOfTables];
            for (int j2 = 0; j2 < this.tcdesc.length; ++j2) {
                this.tcdesc[j2] = new NTFDCNTableChanges(data, csid);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNQueryChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getQueryId() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNQueryChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNQueryChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.queryId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = this.queryId;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNQueryChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryChangeDescription.QueryChangeEventType getQueryChangeEventType() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNQueryChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNQueryChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.queryopflags));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            QueryChangeDescription.QueryChangeEventType queryChangeEventType = this.queryopflags;
            return queryChangeEventType;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNQueryChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableChangeDescription[] getTableChangeDescription() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNQueryChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNQueryChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.tcdesc);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TableChangeDescription[] tableChangeDescriptionArray = this.tcdesc;
            return tableChangeDescriptionArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNQueryChanges.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNQueryChanges.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            StringBuffer sb = new StringBuffer();
            sb.append("  query ID=" + this.queryId + ", query change event type=" + (Object)((Object)this.queryopflags) + "\n");
            TableChangeDescription[] rdesc = this.getTableChangeDescription();
            if (rdesc != null) {
                sb.append("  Table Change Description (length=" + rdesc.length + "):");
                for (int i2 = 0; i2 < rdesc.length; ++i2) {
                    sb.append(rdesc[i2].toString());
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNQueryChanges.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sb.toString());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNQueryChanges.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNQueryChanges.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver.ntf");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFDCNQueryChanges"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

