/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.dcn.DatabaseChangeEvent;
import oracle.jdbc.dcn.QueryChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.NTFConnection;
import oracle.jdbc.driver.NTFDCNQueryChanges;
import oracle.jdbc.driver.NTFDCNTableChanges;
import oracle.jdbc.driver.OracleLog;

class NTFDCNEvent
extends DatabaseChangeEvent {
    private int notifVersion = 0;
    private int notifRegid = 0;
    private DatabaseChangeEvent.EventType eventType;
    private DatabaseChangeEvent.AdditionalEventType additionalEventType = DatabaseChangeEvent.AdditionalEventType.NONE;
    private String databaseName = null;
    private byte[] notifXid = new byte[8];
    private int notifScn1 = 0;
    private int notifScn2 = 0;
    private int numberOfTables = 0;
    private NTFDCNTableChanges[] tcdesc = null;
    private int numberOfQueries = 0;
    private NTFDCNQueryChanges[] qdesc = null;
    private long registrationId;
    private NTFConnection conn;
    private int csid;
    private boolean isReady = false;
    private ByteBuffer dataBuffer;
    private boolean isDeregistrationEvent = false;
    private short databaseVersion;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFDCNEvent(NTFConnection _conn, short _databaseVersion) throws IOException, InterruptedException {
        super(_conn);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.conn = _conn;
            this.csid = this.conn.charset.getOracleId();
            int lengthDataHandle = this.conn.readInt();
            byte[] data = new byte[lengthDataHandle];
            this.conn.readBuffer(data, 0, lengthDataHandle);
            this.dataBuffer = ByteBuffer.wrap(data);
            this.databaseVersion = _databaseVersion;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEvent() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte registrationType = this.dataBuffer.get();
            int registrationLength = this.dataBuffer.getInt();
            byte[] registrationBuffer = new byte[registrationLength];
            this.dataBuffer.get(registrationBuffer, 0, registrationLength);
            String registrationString = null;
            try {
                registrationString = new String(registrationBuffer, "UTF-8");
            }
            catch (Exception ex1) {
                // empty catch block
            }
            registrationString = registrationString.replaceFirst("CHNF", "");
            this.registrationId = Long.parseLong(registrationString);
            byte namespaceType = this.dataBuffer.get();
            int namespaceLength = this.dataBuffer.getInt();
            byte[] namespaceBuffer = new byte[namespaceLength];
            this.dataBuffer.get(namespaceBuffer, 0, namespaceLength);
            byte notificationType = this.dataBuffer.get();
            int notificationLength = this.dataBuffer.getInt();
            if (this.dataBuffer.hasRemaining()) {
                this.notifVersion = this.dataBuffer.getShort();
                this.notifRegid = this.dataBuffer.getInt();
                this.eventType = DatabaseChangeEvent.EventType.getEventType(this.dataBuffer.getInt());
                short notifDatabaseNameLength = this.dataBuffer.getShort();
                byte[] notifDatabaseNameBuffer = new byte[notifDatabaseNameLength];
                this.dataBuffer.get(notifDatabaseNameBuffer, 0, notifDatabaseNameLength);
                try {
                    this.databaseName = new String(notifDatabaseNameBuffer, "UTF-8");
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                this.dataBuffer.get(this.notifXid);
                this.notifScn1 = this.dataBuffer.getInt();
                this.notifScn2 = this.dataBuffer.getShort();
                if (this.eventType == DatabaseChangeEvent.EventType.OBJCHANGE) {
                    this.numberOfTables = this.dataBuffer.getShort();
                    this.tcdesc = new NTFDCNTableChanges[this.numberOfTables];
                    for (int i2 = 0; i2 < this.tcdesc.length; ++i2) {
                        this.tcdesc[i2] = new NTFDCNTableChanges(this.dataBuffer, this.csid);
                    }
                } else if (this.eventType == DatabaseChangeEvent.EventType.QUERYCHANGE) {
                    this.numberOfQueries = this.dataBuffer.getShort();
                    this.qdesc = new NTFDCNQueryChanges[this.numberOfQueries];
                    for (int i3 = 0; i3 < this.numberOfQueries; ++i3) {
                        this.qdesc[i3] = new NTFDCNQueryChanges(this.dataBuffer, this.csid);
                    }
                }
            }
            this.isReady = true;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDatabaseName() {
        String string;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.isReady) {
                this.initEvent();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.databaseName);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.databaseName;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableChangeDescription[] getTableChangeDescription() {
        long __ol_nanos__;
        block29: {
            TableChangeDescription[] tableChangeDescriptionArray;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFDCNEvent.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!this.isReady) {
                    this.initEvent();
                }
                if (this.eventType != DatabaseChangeEvent.EventType.OBJCHANGE) break block29;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFDCNEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.tcdesc);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                tableChangeDescriptionArray = this.tcdesc;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return tableChangeDescriptionArray;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        TableChangeDescription[] tableChangeDescriptionArray = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tableChangeDescriptionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryChangeDescription[] getQueryChangeDescription() {
        long __ol_nanos__;
        block29: {
            QueryChangeDescription[] queryChangeDescriptionArray;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFDCNEvent.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!this.isReady) {
                    this.initEvent();
                }
                if (this.eventType != DatabaseChangeEvent.EventType.QUERYCHANGE) break block29;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFDCNEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.qdesc);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                queryChangeDescriptionArray = this.qdesc;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return queryChangeDescriptionArray;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        QueryChangeDescription[] queryChangeDescriptionArray = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return queryChangeDescriptionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getTransactionId() {
        byte[] byArray;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.isReady) {
                this.initEvent();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.notifXid);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byArray = this.notifXid;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTransactionId(boolean isLittleEndian) {
        String string;
        long __ol_nanos__ = 0L;
        try {
            long xid_seq;
            int xid_slot;
            int xid_undo_seg;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.isReady) {
                this.initEvent();
            }
            if (!isLittleEndian) {
                xid_undo_seg = (this.notifXid[0] & 0xFF) << 8 | this.notifXid[1] & 0xFF;
                xid_slot = (this.notifXid[2] & 0xFF) << 8 | this.notifXid[3] & 0xFF;
                xid_seq = ((this.notifXid[4] & 0xFF) << 24 | (this.notifXid[5] & 0xFF) << 16 | (this.notifXid[6] & 0xFF) << 8 | this.notifXid[7] & 0xFF) & 0xFFFFFFFF;
            } else {
                xid_undo_seg = (this.notifXid[1] & 0xFF) << 8 | this.notifXid[0] & 0xFF;
                xid_slot = (this.notifXid[3] & 0xFF) << 8 | this.notifXid[2] & 0xFF;
                xid_seq = ((this.notifXid[7] & 0xFF) << 24 | (this.notifXid[6] & 0xFF) << 16 | (this.notifXid[5] & 0xFF) << 8 | this.notifXid[4] & 0xFF) & 0xFFFFFFFF;
            }
            String ret = "" + xid_undo_seg + "." + xid_slot + "." + xid_seq;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEventType(DatabaseChangeEvent.EventType _type) throws IOException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument((Object)_type));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.isReady) {
                this.initEvent();
            }
            this.eventType = _type;
            if (this.eventType == DatabaseChangeEvent.EventType.DEREG) {
                this.isDeregistrationEvent = true;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAdditionalEventType(DatabaseChangeEvent.AdditionalEventType _adtype) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument((Object)_adtype));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.additionalEventType = _adtype;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseChangeEvent.EventType getEventType() {
        DatabaseChangeEvent.EventType eventType;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.isReady) {
                this.initEvent();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.eventType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            eventType = this.eventType;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseChangeEvent.AdditionalEventType getAdditionalEventType() {
        DatabaseChangeEvent.AdditionalEventType additionalEventType;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.additionalEventType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            additionalEventType = this.additionalEventType;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return additionalEventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDeregistrationEvent() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.isDeregistrationEvent);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.isDeregistrationEvent;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionInformation() {
        String string;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.conn.connectionDescription);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.conn.connectionDescription;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRegistrationId() {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.isReady) {
                this.initEvent();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (int)this.registrationId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = (int)this.registrationId;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRegId() {
        long l2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.isReady) {
                this.initEvent();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.registrationId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            l2 = this.registrationId;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFDCNEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        long __ol_nanos__ = 0L;
        try {
            QueryChangeDescription[] qcd;
            TableChangeDescription[] tcd;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.isReady) {
                this.initEvent();
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Connection information  : " + this.conn.connectionDescription + "\n");
            sb.append("Registration ID         : " + this.registrationId + "\n");
            sb.append("Notification version    : " + this.notifVersion + "\n");
            sb.append("Event type              : " + (Object)((Object)this.eventType) + "\n");
            if (this.additionalEventType != DatabaseChangeEvent.AdditionalEventType.NONE) {
                sb.append("Additional event type   : " + (Object)((Object)this.additionalEventType) + "\n");
            }
            if (this.databaseName != null) {
                sb.append("Database name           : " + this.databaseName + "\n");
            }
            if ((tcd = this.getTableChangeDescription()) != null) {
                sb.append("Table Change Description (length=" + this.numberOfTables + ")\n");
                for (int i2 = 0; i2 < tcd.length; ++i2) {
                    sb.append(tcd[i2].toString());
                }
            }
            if ((qcd = this.getQueryChangeDescription()) != null) {
                sb.append("Query Change Description (length=" + this.numberOfQueries + ")\n");
                for (int i3 = 0; i3 < qcd.length; ++i3) {
                    sb.append(qcd[i3].toString());
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sb.toString());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFDCNEvent.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver.ntf");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFDCNEvent"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

