/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQNotificationEvent;
import oracle.jdbc.dcn.DatabaseChangeEvent;
import oracle.jdbc.driver.NTFAQEvent;
import oracle.jdbc.driver.NTFDCNEvent;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.NTFRegistration;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterSet;

class NTFConnection
extends Thread {
    private static final int NS_HEADER_SIZE = 10;
    private SocketChannel channel;
    private ByteBuffer inBuffer;
    private ByteBuffer outBuffer;
    private int currentNSPacketLength;
    private int currentNSPacketType;
    private ByteBuffer currentNSPacketDataBuffer;
    private boolean needsToBeClosed;
    private NTFManager ntfManager;
    private Selector selector;
    private Iterator iterator;
    private SelectionKey aKey;
    int remotePort;
    String remoteAddress;
    String remoteName;
    int localPort;
    String localAddress;
    String localName;
    String connectionDescription;
    CharacterSet charset;
    static final int NSPTCN = 1;
    static final int NSPTAC = 2;
    static final int NSPTAK = 3;
    static final int NSPTRF = 4;
    static final int NSPTRD = 5;
    static final int NSPTDA = 6;
    static final int NSPTNL = 7;
    static final int NSPTAB = 9;
    static final int NSPTRS = 11;
    static final int NSPTMK = 12;
    static final int NSPTAT = 13;
    static final int NSPTCNL = 14;
    static final int NSPTHI = 19;
    static final short KPDNFY_TIMEOUT = 1;
    static final short KPDNFY_GROUPING = 2;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFConnection(NTFManager _ntfManager, SocketChannel _channel) {
        block22: {
            this.inBuffer = null;
            this.outBuffer = null;
            this.needsToBeClosed = false;
            this.selector = null;
            this.iterator = null;
            this.aKey = null;
            this.charset = null;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_ntfManager) + ", " + OracleLog.argument(_channel));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    this.ntfManager = _ntfManager;
                    this.channel = _channel;
                    this.channel.configureBlocking(false);
                    this.inBuffer = ByteBuffer.allocate(4096);
                    this.outBuffer = ByteBuffer.allocate(2048);
                    Socket socket = this.channel.socket();
                    InetAddress desIa = socket.getInetAddress();
                    InetAddress locIa = socket.getLocalAddress();
                    this.remotePort = socket.getPort();
                    this.localPort = socket.getLocalPort();
                    this.remoteAddress = desIa.getHostAddress();
                    this.remoteName = desIa.getHostName();
                    this.localAddress = locIa.getHostAddress();
                    this.localName = locIa.getHostName();
                    this.connectionDescription = "local=" + this.localName + "/" + this.localAddress + ":" + this.localPort + ", remote=" + this.remoteName + "/" + this.remoteAddress + ":" + this.remotePort;
                    if (!TRACE || !OracleLog.recursiveEnter()) break block22;
                    try {
                        NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection established: " + this.connectionDescription);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                catch (IOException ioex) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block22;
                    try {
                        NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnnection (" + this.connectionDescription + "): ERROR: got IOException in constructor: " + ioex.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block52: {
            long __ol_nanos__ = 0L;
            try {
                block50: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    try {
                        this.selector = Selector.open();
                        this.channel.register(this.selector, 1);
                        int bytesReadFromNetwork = 0;
                        this.inBuffer.limit(0);
                        while (!this.needsToBeClosed) {
                            if (!this.inBuffer.hasRemaining()) {
                                while ((bytesReadFromNetwork = this.readFromNetwork()) == 0) {
                                }
                            }
                            this.unmarshalOneNSPacket();
                        }
                    }
                    catch (IOException ioex) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block50;
                        try {
                            NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): ERROR: got IOException during thread execution: " + ioex.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    catch (InterruptedException intex) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block50;
                        try {
                            NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): ERROR: got InterruptedException during thread execution: " + intex.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    finally {
                        block51: {
                            try {
                                this.selector.close();
                                this.channel.close();
                            }
                            catch (IOException ioex2) {
                                if (!TRACE || !OracleLog.recursiveEnter()) break block51;
                                try {
                                    NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): ERROR: got IOException during thread execution: " + ioex2.getMessage());
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                        }
                    }
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block52;
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): end of run method. Thread will be closed.");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readFromNetwork() throws IOException, InterruptedException {
        long __ol_nanos__ = 0L;
        try {
            int ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.inBuffer.compact();
            while (true) {
                if (this.iterator == null || !this.iterator.hasNext()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + ") thread: select()");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.selector.select();
                    if (this.needsToBeClosed) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + ") was interrupted.");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new InterruptedException();
                    }
                    this.iterator = this.selector.selectedKeys().iterator();
                    continue;
                }
                this.aKey = (SelectionKey)this.iterator.next();
                if ((this.aKey.readyOps() & 1) == 1) break;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + ") thread: OP_READ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((ret = this.channel.read(this.inBuffer)) < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + ") was closed by remote peer.");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new EOFException();
            }
            if (ret > 0) {
                this.inBuffer.flip();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + ") received packet: \n" + this.packetToString(this.inBuffer));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            this.iterator.remove();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = ret;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNextNSPacket() throws IOException, InterruptedException {
        long __ol_nanos__ = 0L;
        try {
            int bytesReadFromNetwork;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            while (!this.inBuffer.hasRemaining() || this.inBuffer.remaining() < 10) {
                bytesReadFromNetwork = this.readFromNetwork();
            }
            this.currentNSPacketLength = this.inBuffer.getShort();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): currentNSPacketLength is " + this.currentNSPacketLength);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.currentNSPacketLength <= 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + "Invalid NS packet length.");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IOException("Invalid NS packet length.");
            }
            this.inBuffer.position(this.inBuffer.position() + 2);
            this.currentNSPacketType = this.inBuffer.get();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): currentNSPacketType is " + this.currentNSPacketType);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.validatePacketType();
            this.inBuffer.position(this.inBuffer.position() + 5);
            while (this.inBuffer.remaining() < this.currentNSPacketLength - 10) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): need to read another " + (this.currentNSPacketLength - 10) + " bytes.");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bytesReadFromNetwork = this.readFromNetwork();
            }
            int limitBack = this.inBuffer.limit();
            int positionOfEndOfNSPacket = this.inBuffer.position() + this.currentNSPacketLength - 10;
            this.inBuffer.limit(positionOfEndOfNSPacket);
            this.currentNSPacketDataBuffer = this.inBuffer.slice();
            this.inBuffer.limit(limitBack);
            this.inBuffer.position(positionOfEndOfNSPacket);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void unmarshalOneNSPacket() throws IOException, InterruptedException {
        block45: {
            __ol_nanos__ = 0L;
            try {
                block47: {
                    if (NTFConnection.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    this.getNextNSPacket();
                    if (!this.currentNSPacketDataBuffer.hasRemaining()) break block47;
                    if (NTFConnection.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): switching on packet type " + this.currentNSPacketType);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    switch (this.currentNSPacketType) {
                        case 1: {
                            if (NTFConnection.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + ") got a NSPTCN packet.");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            answer = new byte[]{0, 24, 0, 0, 2, 0, 0, 0, 1, 52, 0, 0, 8, 0, 127, -1, 1, 0, 0, 0, 0, 24, 65, 1};
                            this.outBuffer.clear();
                            this.outBuffer.put(answer);
                            this.outBuffer.limit(24);
                            this.outBuffer.rewind();
                            this.channel.write(this.outBuffer);
                            break;
                        }
                        case 6: {
                            if (NTFConnection.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + ") got a NSPTDA packet.");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            if (this.currentNSPacketDataBuffer.get(0) != -34 || this.currentNSPacketDataBuffer.get(1) != -83) ** GOTO lbl77
                            if (NTFConnection.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): NSPTDA packet is DEADBEEF");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            anoAnswer = new byte[]{0, 127, 0, 0, 6, 0, 0, 0, 0, 0, -34, -83, -66, -17, 0, 117, 10, 32, 1, 0, 0, 4, 0, 0, 4, 0, 3, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 2, 0, 6, 0, 31, 0, 14, 0, 1, -34, -83, -66, -17, 0, 3, 0, 0, 0, 2, 0, 4, 0, 1, 0, 1, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 2, 0, 6, -5, -1, 0, 2, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 1, 0, 2, 0, 0, 3, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 1, 0, 2, 0};
                            this.outBuffer.clear();
                            this.outBuffer.put(anoAnswer);
                            this.outBuffer.limit(anoAnswer.length);
                            this.outBuffer.rewind();
                            this.channel.write(this.outBuffer);
                            if (!NTFConnection.TRACE || !OracleLog.recursiveEnter()) break block45;
                            try {
                                NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): Response to DEADBEEF sent.");
                                break block45;
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
lbl77:
                            // 1 sources

                            if (NTFConnection.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): Got a notification.");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            this.unmarshalNSDataPacket();
                        }
                    }
                    break block45;
                }
                if (!NTFConnection.TRACE || !OracleLog.recursiveEnter()) break block45;
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): there was no NS data.");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (NTFConnection.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmarshalNSDataPacket() throws IOException, InterruptedException {
        block62: {
            long __ol_nanos__ = 0L;
            try {
                int i2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                short nbOfHandles = this.readShort();
                int lengthOfHeaderHandler = this.readInt();
                byte csidType = this.readByte();
                int csidLength = this.readInt();
                short csid = this.readShort();
                if (this.charset == null || this.charset.getOracleId() != csid) {
                    this.charset = CharacterSet.make(csid);
                }
                byte presentationType = this.readByte();
                int presentationLength = this.readInt();
                short presentation = this.readShort();
                byte versionType = this.readByte();
                int versionLength = this.readInt();
                short version = this.readShort();
                int nbOfRegistrations = (lengthOfHeaderHandler - 21) / 9;
                int[] contextArr = new int[nbOfRegistrations];
                for (int i3 = 0; i3 < nbOfRegistrations; ++i3) {
                    byte contextType = this.readByte();
                    int contextLength = this.readInt();
                    byte[] contextBuffer = new byte[contextLength];
                    this.readBuffer(contextBuffer, 0, contextLength);
                    for (int j2 = 0; j2 < contextLength; ++j2) {
                        if (j2 >= 4) continue;
                        int n2 = i3;
                        contextArr[n2] = contextArr[n2] | (contextBuffer[j2] & 0xFF) << 8 * (contextLength - j2 - 1);
                    }
                }
                NTFDCNEvent dcnevent = null;
                NTFAQEvent aqevent = null;
                int namespace = 0;
                short databaseVersion = 0;
                NTFRegistration[] ntfRegistrationArr = null;
                if (nbOfHandles >= 2) {
                    short ignore = this.readShort();
                    ntfRegistrationArr = new NTFRegistration[contextArr.length];
                    for (i2 = 0; i2 < contextArr.length; ++i2) {
                        ntfRegistrationArr[i2] = this.ntfManager.getRegistration(contextArr[i2]);
                        if (ntfRegistrationArr[i2] == null) continue;
                        namespace = ntfRegistrationArr[i2].getNamespace();
                        databaseVersion = ntfRegistrationArr[i2].getDatabaseVersion();
                    }
                    if (namespace == 2) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): Got a DCN notification.");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        dcnevent = new NTFDCNEvent(this, databaseVersion);
                    } else if (namespace == 1) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): Got an AQ notification.");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        aqevent = new NTFAQEvent(this, databaseVersion);
                    } else if (namespace == 0) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): Got an ANONYMOUS notification.");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                    } else if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): ERROR: unrecognized namespace.");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                short notifyDescriptor = 0;
                if (nbOfHandles >= 3) {
                    short ignore = this.readShort();
                    int lengthThirdHandle = this.readInt();
                    byte ttype = this.readByte();
                    int llength = this.readInt();
                    notifyDescriptor = this.readShort();
                    if (namespace == 2 && dcnevent != null) {
                        dcnevent.setAdditionalEventType(DatabaseChangeEvent.AdditionalEventType.getEventType(notifyDescriptor));
                        if (notifyDescriptor == 1) {
                            dcnevent.setEventType(DatabaseChangeEvent.EventType.DEREG);
                        }
                    } else if (namespace == 1 && aqevent != null) {
                        aqevent.setAdditionalEventType(AQNotificationEvent.AdditionalEventType.getEventType(notifyDescriptor));
                        if (notifyDescriptor == 1) {
                            aqevent.setEventType(AQNotificationEvent.EventType.DEREG);
                        }
                    }
                }
                if (nbOfHandles > 3 && TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): ERROR: The notification contains more than 3 handles.");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (ntfRegistrationArr == null) break block62;
                if (namespace == 2) {
                    for (i2 = 0; i2 < ntfRegistrationArr.length; ++i2) {
                        if (ntfRegistrationArr[i2] == null || dcnevent == null) continue;
                        ntfRegistrationArr[i2].notify(dcnevent);
                    }
                    break block62;
                }
                if (namespace == 1) {
                    for (i2 = 0; i2 < ntfRegistrationArr.length; ++i2) {
                        if (ntfRegistrationArr[i2] == null || aqevent == null) continue;
                        ntfRegistrationArr[i2].notify(aqevent);
                    }
                    break block62;
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block62;
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): unknown namespace.");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeThisConnection() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.needsToBeClosed = true;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte readByte() throws IOException, InterruptedException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte ret = 0;
            if (this.currentNSPacketDataBuffer.hasRemaining()) {
                ret = this.currentNSPacketDataBuffer.get();
            } else {
                this.getNextNSPacket();
                ret = this.currentNSPacketDataBuffer.get();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by = ret;
            return by;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    short readShort() throws IOException, InterruptedException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            short ret = 0;
            if (this.currentNSPacketDataBuffer.remaining() >= 2) {
                ret = this.currentNSPacketDataBuffer.getShort();
            } else {
                int b1 = this.readByte() & 0xFF;
                int b2 = this.readByte() & 0xFF;
                ret = (short)(b1 << 8 | b2);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short s2 = ret;
            return s2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readInt() throws IOException, InterruptedException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int ret = 0;
            if (this.currentNSPacketDataBuffer.remaining() >= 4) {
                ret = this.currentNSPacketDataBuffer.getInt();
            } else {
                int b1 = this.readByte() & 0xFF;
                int b2 = this.readByte() & 0xFF;
                int b3 = this.readByte() & 0xFF;
                int b4 = this.readByte() & 0xFF;
                ret = b1 << 24 | b2 << 16 | b3 << 8 | b4;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = ret;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long readLong() throws IOException, InterruptedException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            long ret = 0L;
            if (this.currentNSPacketDataBuffer.remaining() >= 8) {
                ret = this.currentNSPacketDataBuffer.getLong();
            } else {
                long b1 = this.readByte() & 0xFF;
                long b2 = this.readByte() & 0xFF;
                long b3 = this.readByte() & 0xFF;
                long b4 = this.readByte() & 0xFF;
                long b5 = this.readByte() & 0xFF;
                long b6 = this.readByte() & 0xFF;
                long b7 = this.readByte() & 0xFF;
                long b8 = this.readByte() & 0xFF;
                ret = b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = ret;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readBuffer(byte[] buff, int offset, int length) throws IOException, InterruptedException {
        block24: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buff) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(length));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.currentNSPacketDataBuffer.remaining() >= length) {
                    this.currentNSPacketDataBuffer.get(buff, offset, length);
                    break block24;
                }
                boolean done = false;
                int bytesAlreadyRead = 0;
                int bytesToRead = 0;
                int remainingBytesInCurrentBuffer = this.currentNSPacketDataBuffer.remaining();
                this.currentNSPacketDataBuffer.get(buff, offset, remainingBytesInCurrentBuffer);
                offset += remainingBytesInCurrentBuffer;
                bytesAlreadyRead += remainingBytesInCurrentBuffer;
                while (!done) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NTFConnection.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): bytesAlreadyRead = " + bytesAlreadyRead);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.getNextNSPacket();
                    remainingBytesInCurrentBuffer = this.currentNSPacketDataBuffer.remaining();
                    bytesToRead = Math.min(remainingBytesInCurrentBuffer, length - bytesAlreadyRead);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            NTFConnection.logger().log(Level.FINEST, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "NTFConnection (" + this.connectionDescription + "): bytesToRead = " + bytesToRead);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.currentNSPacketDataBuffer.get(buff, offset, bytesToRead);
                    offset += bytesToRead;
                    if ((bytesAlreadyRead += bytesToRead) != length) continue;
                    done = true;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String packetToString(ByteBuffer buff) throws IOException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buff));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int offset = 0;
            char[] byteArr = new char[8];
            StringBuffer strbuff = new StringBuffer();
            int initialPosition = buff.position();
            while (buff.hasRemaining()) {
                byte b2 = buff.get();
                String hexRep = Integer.toHexString(b2 & 0xFF);
                if ((hexRep = hexRep.toUpperCase()).length() == 1) {
                    hexRep = "0" + hexRep;
                }
                strbuff.append(hexRep);
                strbuff.append(' ');
                byteArr[offset] = b2 > 32 && b2 < 127 ? (int)b2 : 46;
                if (++offset != 8) continue;
                strbuff.append('|');
                strbuff.append(byteArr);
                strbuff.append('|');
                strbuff.append('\n');
                offset = 0;
            }
            if (offset != 0) {
                int i2;
                int nbSpacesMissing = 8 - offset;
                for (i2 = 0; i2 < nbSpacesMissing * 3; ++i2) {
                    strbuff.append(' ');
                }
                strbuff.append('|');
                strbuff.append(byteArr, 0, offset);
                for (i2 = 0; i2 < nbSpacesMissing; ++i2) {
                    strbuff.append(' ');
                }
                strbuff.append('|');
                strbuff.append('\n');
            }
            strbuff.append("\nEnd of Packet\n\n");
            buff.position(initialPosition);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + strbuff.toString());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = strbuff.toString();
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validatePacketType() throws IOException {
        block18: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.currentNSPacketType >= 1 && this.currentNSPacketType <= 19) break block18;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + "Invalid NS packet type.");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IOException("Invalid NS packet type.");
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NTFConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver.ntf");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

