/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleStatementCacheEntry;
import oracle.jdbc.internal.OracleConnection;

class LRUStatementCache {
    private int cacheSize;
    private int numElements;
    private OracleStatementCacheEntry applicationCacheStart;
    private OracleStatementCacheEntry applicationCacheEnd;
    private OracleStatementCacheEntry implicitCacheStart;
    private OracleStatementCacheEntry explicitCacheStart;
    boolean implicitCacheEnabled;
    boolean explicitCacheEnabled;
    private boolean debug = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LRUStatementCache(int size) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(size));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (size < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LRUStatementCache.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 123);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 123);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.cacheSize = size;
            this.numElements = 0;
            this.implicitCacheStart = null;
            this.explicitCacheStart = null;
            this.implicitCacheEnabled = false;
            this.explicitCacheEnabled = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resize(int newSize) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(newSize));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (newSize < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LRUStatementCache.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 123);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 123);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (newSize >= this.cacheSize || newSize >= this.numElements) {
                this.cacheSize = newSize;
            } else {
                OracleStatementCacheEntry e2 = this.applicationCacheEnd;
                while (this.numElements > newSize) {
                    this.purgeCacheEntry(e2);
                    e2 = e2.applicationPrev;
                }
                this.cacheSize = newSize;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImplicitCachingEnabled(boolean cache) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cache));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!cache) {
                this.purgeImplicitCache();
            }
            this.implicitCacheEnabled = cache;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getImplicitCachingEnabled() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean retValue = this.cacheSize == 0 ? false : this.implicitCacheEnabled;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + retValue);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = retValue;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExplicitCachingEnabled(boolean cache) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cache));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!cache) {
                this.purgeExplicitCache();
            }
            this.explicitCacheEnabled = cache;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getExplicitCachingEnabled() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean retValue = this.cacheSize == 0 ? false : this.explicitCacheEnabled;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + retValue);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = retValue;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToImplicitCache(OraclePreparedStatement stmt, String sql, int statementType, int scrollType) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(statementType) + ", " + OracleLog.argument(scrollType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.implicitCacheEnabled || this.cacheSize == 0 || stmt.cacheState == 2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LRUStatementCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "implicit caching not enabled or already cached, returning...");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            if (this.numElements == this.cacheSize) {
                this.purgeCacheEntry(this.applicationCacheEnd);
            }
            stmt.enterImplicitCache();
            OracleStatementCacheEntry entry = new OracleStatementCacheEntry();
            entry.statement = stmt;
            entry.onImplicit = true;
            entry.sql = sql;
            entry.statementType = statementType;
            entry.scrollType = scrollType;
            entry.applicationNext = this.applicationCacheStart;
            entry.applicationPrev = null;
            if (this.applicationCacheStart != null) {
                this.applicationCacheStart.applicationPrev = entry;
            }
            this.applicationCacheStart = entry;
            entry.implicitNext = this.implicitCacheStart;
            entry.implicitPrev = null;
            if (this.implicitCacheStart != null) {
                this.implicitCacheStart.implicitPrev = entry;
            }
            this.implicitCacheStart = entry;
            if (this.applicationCacheEnd == null) {
                this.applicationCacheEnd = entry;
            }
            ++this.numElements;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToExplicitCache(OraclePreparedStatement stmt, String key) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(key));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.explicitCacheEnabled || this.cacheSize == 0 || stmt.cacheState == 2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            if (this.numElements == this.cacheSize) {
                this.purgeCacheEntry(this.applicationCacheEnd);
            }
            stmt.enterExplicitCache();
            OracleStatementCacheEntry entry = new OracleStatementCacheEntry();
            entry.statement = stmt;
            entry.sql = key;
            entry.onImplicit = false;
            entry.applicationNext = this.applicationCacheStart;
            entry.applicationPrev = null;
            if (this.applicationCacheStart != null) {
                this.applicationCacheStart.applicationPrev = entry;
            }
            this.applicationCacheStart = entry;
            entry.explicitNext = this.explicitCacheStart;
            entry.explicitPrev = null;
            if (this.explicitCacheStart != null) {
                this.explicitCacheStart.explicitPrev = entry;
            }
            this.explicitCacheStart = entry;
            if (this.applicationCacheEnd == null) {
                this.applicationCacheEnd = entry;
            }
            ++this.numElements;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleStatement searchImplicitCache(String sql, int statementType, int scrollType) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(statementType) + ", " + OracleLog.argument(scrollType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.implicitCacheEnabled) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleStatement oracleStatement = null;
                return oracleStatement;
            }
            OracleStatementCacheEntry entry = null;
            entry = this.implicitCacheStart;
            while (!(entry == null || entry.statementType == statementType && entry.scrollType == scrollType && entry.sql.equals(sql))) {
                entry = entry.implicitNext;
            }
            if (entry != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LRUStatementCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "searchImplicitCache: Found statement with key " + sql + "$$" + statementType + "$$" + scrollType);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (entry.applicationPrev != null) {
                    entry.applicationPrev.applicationNext = entry.applicationNext;
                }
                if (entry.applicationNext != null) {
                    entry.applicationNext.applicationPrev = entry.applicationPrev;
                }
                if (this.applicationCacheStart == entry) {
                    this.applicationCacheStart = entry.applicationNext;
                }
                if (this.applicationCacheEnd == entry) {
                    this.applicationCacheEnd = entry.applicationPrev;
                }
                if (entry.implicitPrev != null) {
                    entry.implicitPrev.implicitNext = entry.implicitNext;
                }
                if (entry.implicitNext != null) {
                    entry.implicitNext.implicitPrev = entry.implicitPrev;
                }
                if (this.implicitCacheStart == entry) {
                    this.implicitCacheStart = entry.implicitNext;
                }
                --this.numElements;
                entry.statement.exitImplicitCacheToActive();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + entry.statement);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OraclePreparedStatement oraclePreparedStatement = entry.statement;
                return oraclePreparedStatement;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleStatement oracleStatement = null;
            return oracleStatement;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleStatement searchExplicitCache(String key) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(key));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.explicitCacheEnabled) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleStatement oracleStatement = null;
                return oracleStatement;
            }
            OracleStatementCacheEntry entry = null;
            entry = this.explicitCacheStart;
            while (entry != null && !entry.sql.equals(key)) {
                entry = entry.explicitNext;
            }
            if (entry != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LRUStatementCache.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "searchExplicitCache: Found statement with key " + entry.sql);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (entry.applicationPrev != null) {
                    entry.applicationPrev.applicationNext = entry.applicationNext;
                }
                if (entry.applicationNext != null) {
                    entry.applicationNext.applicationPrev = entry.applicationPrev;
                }
                if (this.applicationCacheStart == entry) {
                    this.applicationCacheStart = entry.applicationNext;
                }
                if (this.applicationCacheEnd == entry) {
                    this.applicationCacheEnd = entry.applicationPrev;
                }
                if (entry.explicitPrev != null) {
                    entry.explicitPrev.explicitNext = entry.explicitNext;
                }
                if (entry.explicitNext != null) {
                    entry.explicitNext.explicitPrev = entry.explicitPrev;
                }
                if (this.explicitCacheStart == entry) {
                    this.explicitCacheStart = entry.explicitNext;
                }
                --this.numElements;
                entry.statement.exitExplicitCacheToActive();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + entry.statement);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OraclePreparedStatement oraclePreparedStatement = entry.statement;
                return oraclePreparedStatement;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleStatement oracleStatement = null;
            return oracleStatement;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeImplicitCache() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleStatementCacheEntry entry = this.implicitCacheStart;
            while (entry != null) {
                this.purgeCacheEntry(entry);
                entry = entry.implicitNext;
            }
            this.implicitCacheStart = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeExplicitCache() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleStatementCacheEntry entry = this.explicitCacheStart;
            while (entry != null) {
                this.purgeCacheEntry(entry);
                entry = entry.explicitNext;
            }
            this.explicitCacheStart = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeCacheEntry(OracleStatementCacheEntry entry) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(entry));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (entry.applicationNext != null) {
                entry.applicationNext.applicationPrev = entry.applicationPrev;
            }
            if (entry.applicationPrev != null) {
                entry.applicationPrev.applicationNext = entry.applicationNext;
            }
            if (this.applicationCacheStart == entry) {
                this.applicationCacheStart = entry.applicationNext;
            }
            if (this.applicationCacheEnd == entry) {
                this.applicationCacheEnd = entry.applicationPrev;
            }
            if (entry.onImplicit) {
                if (entry.implicitNext != null) {
                    entry.implicitNext.implicitPrev = entry.implicitPrev;
                }
                if (entry.implicitPrev != null) {
                    entry.implicitPrev.implicitNext = entry.implicitNext;
                }
                if (this.implicitCacheStart == entry) {
                    this.implicitCacheStart = entry.implicitNext;
                }
            } else {
                if (entry.explicitNext != null) {
                    entry.explicitNext.explicitPrev = entry.explicitPrev;
                }
                if (entry.explicitPrev != null) {
                    entry.explicitPrev.explicitNext = entry.explicitNext;
                }
                if (this.explicitCacheStart == entry) {
                    this.explicitCacheStart = entry.explicitNext;
                }
            }
            --this.numElements;
            if (entry.onImplicit) {
                entry.statement.exitImplicitCacheToClose();
            } else {
                entry.statement.exitExplicitCacheToClose();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCacheSize() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.cacheSize);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.cacheSize;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public void printCache(String msg) throws SQLException {
        System.out.println("*** Start of Statement Cache Dump (" + msg + ") ***");
        System.out.println("cache size: " + this.cacheSize + " num elements: " + this.numElements + " implicit enabled: " + this.implicitCacheEnabled + " explicit enabled: " + this.explicitCacheEnabled);
        System.out.println("applicationStart: " + this.applicationCacheStart + "  applicationEnd: " + this.applicationCacheEnd);
        OracleStatementCacheEntry e2 = this.applicationCacheStart;
        while (e2 != null) {
            e2.print();
            e2 = e2.applicationNext;
        }
        System.out.println("implicitStart: " + this.implicitCacheStart);
        e2 = this.implicitCacheStart;
        while (e2 != null) {
            e2.print();
            e2 = e2.implicitNext;
        }
        System.out.println("explicitStart: " + this.explicitCacheStart);
        e2 = this.explicitCacheStart;
        while (e2 != null) {
            e2.print();
            e2 = e2.explicitNext;
        }
        System.out.println("*** End of Statement Cache Dump (" + msg + ") ***");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleStatementCacheEntry entry = this.applicationCacheStart;
            while (entry != null) {
                if (entry.onImplicit) {
                    entry.statement.exitImplicitCacheToClose();
                } else {
                    entry.statement.exitExplicitCacheToClose();
                }
                entry = entry.applicationNext;
            }
            this.applicationCacheStart = null;
            this.applicationCacheEnd = null;
            this.implicitCacheStart = null;
            this.explicitCacheStart = null;
            this.numElements = 0;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LRUStatementCache.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.LRUStatementCache"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

