/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.OPAQUE;

public class ClassRef {
    static final XMLTypeClassRef XMLTYPE = XMLTypeClassRef.newInstance();
    public static final Locale LOCALE = Locale.newInstance();
    private final String className;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ClassRef newInstance(String name) throws ClassNotFoundException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ClassRef __result__ = new ClassRef(name);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ClassRef classRef = __result__;
            return classRef;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassRef(String name) throws ClassNotFoundException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.className = name;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class get() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ClassRef.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + Class.forName(this.className, true, Thread.currentThread().getContextClassLoader()));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Class<?> clazz = Class.forName(this.className, true, Thread.currentThread().getContextClassLoader());
                return clazz;
            }
            catch (ClassNotFoundException ex) {
                NoClassDefFoundError e2 = new NoClassDefFoundError(ex.getMessage());
                e2.initCause(ex);
                throw e2;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ClassRef.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ClassRef"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Locale {
        protected final Method localeJDK7getDefault;
        protected final Object localeCategoryEnumFORMAT;

        static final Locale newInstance() {
            try {
                return new Locale();
            }
            catch (Exception exception) {
                return null;
            }
        }

        private Locale() {
            LocaleCategoryClassRef localeCategoryEnum = LocaleCategoryClassRef.newInstance();
            Method m2 = null;
            Object fmt = null;
            if (localeCategoryEnum != null) {
                try {
                    T[] eConst;
                    for (Object e2 : eConst = localeCategoryEnum.get().getEnumConstants()) {
                        if (((Enum)e2).name() != "FORMAT") continue;
                        fmt = e2;
                        break;
                    }
                    m2 = java.util.Locale.class.getDeclaredMethod("getDefault", localeCategoryEnum.get());
                }
                catch (Throwable e3) {
                    m2 = null;
                    fmt = null;
                }
            }
            this.localeJDK7getDefault = m2;
            this.localeCategoryEnumFORMAT = fmt;
        }

        public java.util.Locale getDefault() {
            try {
                if (this.localeJDK7getDefault == null) {
                    return java.util.Locale.getDefault();
                }
                return (java.util.Locale)this.localeJDK7getDefault.invoke(null, this.localeCategoryEnumFORMAT);
            }
            catch (IllegalAccessException x) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }
    }

    public static class LocaleCategoryClassRef
    extends ClassRef {
        static final LocaleCategoryClassRef newInstance() {
            try {
                return new LocaleCategoryClassRef();
            }
            catch (ClassNotFoundException ex) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return null;
        }

        private LocaleCategoryClassRef() throws ClassNotFoundException {
            super("java.util.Locale$Category");
        }
    }

    static class XMLTypeClassRef
    extends ClassRef {
        protected final Method CREATEXML;

        static final XMLTypeClassRef newInstance() {
            try {
                return new XMLTypeClassRef();
            }
            catch (ClassNotFoundException ex) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return null;
        }

        private XMLTypeClassRef() throws ClassNotFoundException {
            super("oracle.xdb.XMLType");
            Method c2 = null;
            try {
                c2 = this.get().getDeclaredMethod("createXML", OPAQUE.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.CREATEXML = c2;
        }

        OPAQUE createXML(OPAQUE data) throws SQLException {
            this.get();
            try {
                return (OPAQUE)this.CREATEXML.invoke(null, data);
            }
            catch (IllegalAccessException x) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }
    }
}

