/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Logger;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;

abstract class CharCopyingBinder
extends Binder {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    CharCopyingBinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Binder copyingBinder() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCopyingBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCopyingBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharCopyingBinder charCopyingBinder = this;
            return charCopyingBinder;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCopyingBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) {
        long __ol_nanos__ = 0L;
        try {
            int len;
            int fromCharOffset;
            char[] fromChars;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCopyingBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(bindPosition) + ", " + OracleLog.argument(rankInBuffer) + ", " + OracleLog.argument(rank) + ", " + OracleLog.argument(bindBytes) + ", " + OracleLog.argument(bindChars) + ", " + OracleLog.argument(bindIndicators) + ", " + OracleLog.argument(bytePitch) + ", " + OracleLog.argument(charPitch) + ", " + OracleLog.argument(byteoffset) + ", " + OracleLog.argument(charoffset) + ", " + OracleLog.argument(lenoffset) + ", " + OracleLog.argument(indoffset) + ", " + OracleLog.argument(clearPriorBindValues));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (rankInBuffer == 0) {
                fromChars = stmt.lastBoundChars;
                fromCharOffset = stmt.lastBoundCharOffsets[bindPosition];
                bindIndicators[indoffset] = stmt.lastBoundInds[bindPosition];
                bindIndicators[lenoffset] = stmt.lastBoundLens[bindPosition];
                if (fromChars == bindChars && fromCharOffset == charoffset) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharCopyingBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    return;
                }
                len = stmt.lastBoundCharLens[bindPosition];
                if (len > charPitch) {
                    len = charPitch;
                }
            } else {
                fromChars = bindChars;
                fromCharOffset = charoffset - charPitch;
                bindIndicators[indoffset] = bindIndicators[indoffset - 1];
                bindIndicators[lenoffset] = bindIndicators[lenoffset - 1];
                len = charPitch;
            }
            System.arraycopy(fromChars, fromCharOffset, bindChars, charoffset, len);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCopyingBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.CharCopyingBinder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

