/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

class ArrayLocatorResultSet
extends OracleResultSetImpl {
    static int COUNT_UNLIMITED = -1;
    Map map;
    long beginIndex;
    int count;
    long currentIndex;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayLocatorResultSet(OracleConnection conn, ArrayDescriptor descriptor, byte[] locator, Map map) throws SQLException {
        block12: {
            this(conn, descriptor, locator, 0L, COUNT_UNLIMITED, map);
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    ArrayLocatorResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(descriptor) + ", " + OracleLog.argument(locator) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayLocatorResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayLocatorResultSet(OracleConnection conn, ArrayDescriptor descriptor, byte[] locator, long beginIndex, int count, Map map) throws SQLException {
        super((PhysicalConnection)conn, null);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayLocatorResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(descriptor) + ", " + OracleLog.argument(locator) + ", " + OracleLog.argument(beginIndex) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (descriptor == null || conn == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayLocatorResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Invalid arguments");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid arguments");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.close_statement_on_close = true;
            this.count = count;
            this.currentIndex = 0L;
            this.beginIndex = beginIndex;
            this.map = map;
            OraclePreparedStatement pstmt = null;
            ARRAY tmpObj = new ARRAY(descriptor, conn, (Object)null);
            tmpObj.setLocator(locator);
            pstmt = descriptor.getBaseType() == 2002 || descriptor.getBaseType() == 2008 ? (OraclePreparedStatement)((OraclePreparedStatementWrapper)conn.prepareStatement((String)new StringBuilder().append((String)"SELECT ROWNUM, SYS_NC_ROWINFO$ FROM TABLE( CAST(:1 AS ").append((String)descriptor.getName()).append((String)") )").toString())).preparedStatement : (OraclePreparedStatement)((OraclePreparedStatementWrapper)conn.prepareStatement((String)new StringBuilder().append((String)"SELECT ROWNUM, COLUMN_VALUE FROM TABLE( CAST(:1 AS ").append((String)descriptor.getName()).append((String)") )").toString())).preparedStatement;
            pstmt.setArray(1, tmpObj);
            pstmt.executeQuery();
            this.statement = pstmt;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayLocatorResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block60: {
                block57: {
                    block52: {
                        boolean bl;
                        __ol_nanos__ = 0L;
                        try {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    ArrayLocatorResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                                __ol_nanos__ = System.nanoTime();
                            }
                            if (this.currentIndex >= this.beginIndex) break block52;
                            while (this.currentIndex < this.beginIndex) {
                                ++this.currentIndex;
                                if (super.next()) continue;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        ArrayLocatorResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                bl = false;
                                if (!TRACE) return bl;
                            }
                        }
                        catch (Throwable throwable) {
                            if (!TRACE) throw throwable;
                            if (!OracleLog.recursiveEnter()) throw throwable;
                            try {
                                ArrayLocatorResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                                throw throwable;
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        {
                            if (!OracleLog.recursiveEnter()) return bl;
                            try {
                                ArrayLocatorResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                            return bl;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayLocatorResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        boolean bl2 = true;
                        if (!TRACE) return bl2;
                        if (!OracleLog.recursiveEnter()) return bl2;
                        try {
                            ArrayLocatorResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        return bl2;
                    }
                    if (this.count != COUNT_UNLIMITED) break block57;
                    boolean __result__ = super.next();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayLocatorResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = __result__;
                    if (!TRACE) return bl;
                    if (!OracleLog.recursiveEnter()) return bl;
                    try {
                        ArrayLocatorResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    return bl;
                }
                if (this.currentIndex >= this.beginIndex + (long)this.count - 1L) break block60;
                ++this.currentIndex;
                boolean __result__ = super.next();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayLocatorResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = __result__;
                if (!TRACE) return bl;
                if (!OracleLog.recursiveEnter()) return bl;
                try {
                    ArrayLocatorResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayLocatorResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            if (!TRACE) return bl;
            if (!OracleLog.recursiveEnter()) return bl;
            try {
                ArrayLocatorResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayLocatorResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                Object __result__ = this.getObject(columnIndex, this.map);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayLocatorResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                object = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayLocatorResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayLocatorResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int findColumn(String columnName) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block35: {
                long __ol_nanos__;
                block32: {
                    int n2;
                    __ol_nanos__ = 0L;
                    try {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayLocatorResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                            __ol_nanos__ = System.nanoTime();
                        }
                        if (!columnName.equalsIgnoreCase("index")) break block32;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayLocatorResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        n2 = 1;
                        if (!TRACE) return n2;
                    }
                    catch (Throwable throwable) {
                        if (!TRACE) throw throwable;
                        if (!OracleLog.recursiveEnter()) throw throwable;
                        try {
                            ArrayLocatorResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                            throw throwable;
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (!OracleLog.recursiveEnter()) return n2;
                    try {
                        ArrayLocatorResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    return n2;
                }
                if (!columnName.equalsIgnoreCase("value")) break block35;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayLocatorResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = 2;
                if (!TRACE) return n3;
                if (!OracleLog.recursiveEnter()) return n3;
                try {
                    ArrayLocatorResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return n3;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayLocatorResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6 + "get_column_index");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, "get_column_index");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ArrayLocatorResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

