/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class ArrayDataResultSet
extends BaseResultSet {
    Datum[] data;
    Map map;
    private int currentIndex;
    private int lastIndex;
    PhysicalConnection connection;
    private Boolean wasNull;
    private int fetchSize;
    ARRAY array;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayDataResultSet(OracleConnection conn, Datum[] data, Map map) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(data) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.connection = (PhysicalConnection)conn;
            this.data = data;
            this.map = map;
            this.currentIndex = 0;
            this.lastIndex = this.data == null ? 0 : this.data.length;
            this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayDataResultSet(OracleConnection conn, Datum[] data, long index, int count, Map map) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(data) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.connection = (PhysicalConnection)conn;
            this.data = data;
            this.map = map;
            this.currentIndex = (int)index - 1;
            int length = this.data == null ? 0 : this.data.length;
            this.lastIndex = this.currentIndex + Math.min(length - this.currentIndex, count);
            this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayDataResultSet(OracleConnection conn, ARRAY array, long index, int count, Map map) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(array) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.connection = (PhysicalConnection)conn;
            this.array = array;
            this.map = map;
            this.currentIndex = (int)index - 1;
            int length = this.array == null ? 0 : array.length();
            this.lastIndex = this.currentIndex + (count == -1 ? length - this.currentIndex : Math.min(length - this.currentIndex, count));
            this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10 + "next");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "next");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            ++this.currentIndex;
            boolean bl2 = __result__ = this.currentIndex <= this.lastIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                super.close();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.wasNull == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 24 + null);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24, null);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                boolean __result__ = this.wasNull;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getString(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                String string;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    String __result__ = datum.stringValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    string = __result__;
                    if (!TRACE) return string;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return string;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return string;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            if (!TRACE) return string;
            if (!OracleLog.recursiveEnter()) return string;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCursor(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getCursor");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Datum getOracleObject(int columnIndex) throws SQLException {
        block58: {
            block55: {
                block52: {
                    __ol_nanos__ = 0L;
                    try {
                        if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                            __ol_nanos__ = System.nanoTime();
                        }
                        if (this.currentIndex <= 0) {
                            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14 + null);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14, null);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        if (columnIndex != 1) break block52;
                        this.wasNull = Boolean.FALSE;
                        __result__ = new NUMBER(this.currentIndex);
                        if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        var5_10 = __result__;
                    }
                    catch (Throwable var14_20) {
                        if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw var14_20;
                    }
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    return var5_10;
                }
                if (columnIndex != 2) ** GOTO lbl115
                if (this.data == null) break block55;
                v0 = this.wasNull = this.data[this.currentIndex - 1] == null ? Boolean.TRUE : Boolean.FALSE;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.data[this.currentIndex - 1]);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                __result__ = this.data[this.currentIndex - 1];
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return __result__;
            }
            if (this.array == null || (darray = this.array.getOracleArray(this.currentIndex, 1)) == null || darray.length < 1) break block58;
            v1 = this.wasNull = darray[0] == null ? Boolean.TRUE : Boolean.FALSE;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + darray[0]);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var5_11 = darray[0];
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var5_11;
        }
        if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Out of sync");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Out of sync");
        __ex__.fillInStackTrace();
        throw __ex__;
lbl115:
        // 1 sources

        if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + null);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, null);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ROWID getROWID(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof ROWID)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (ROWID)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (ROWID)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getROWID");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public NUMBER getNUMBER(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof NUMBER)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (NUMBER)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (NUMBER)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getNUMBER");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public DATE getDATE(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof DATE)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (DATE)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (DATE)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getDATE");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ARRAY getARRAY(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof ARRAY)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (ARRAY)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (ARRAY)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getARRAY");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public STRUCT getSTRUCT(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof STRUCT)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (STRUCT)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (STRUCT)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getSTRUCT");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof OPAQUE)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (OPAQUE)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (OPAQUE)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getOPAQUE");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public REF getREF(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof REF)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (REF)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (REF)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getREF");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public CHAR getCHAR(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof CHAR)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (CHAR)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (CHAR)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getCHAR");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public RAW getRAW(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof RAW)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (RAW)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (RAW)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getRAW");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public BLOB getBLOB(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof BLOB)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (BLOB)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (BLOB)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getBLOB");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public CLOB getCLOB(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof CLOB)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (CLOB)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (CLOB)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getCLOB");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public BFILE getBFILE(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof BFILE)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (BFILE)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (BFILE)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getBFILE");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public INTERVALDS getINTERVALDS(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof INTERVALDS)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (INTERVALDS)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (INTERVALDS)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public INTERVALYM getINTERVALYM(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof INTERVALYM)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (INTERVALYM)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (INTERVALYM)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBfile(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                BFILE __result__ = this.getBFILE(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bFILE = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof TIMESTAMP)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (TIMESTAMP)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (TIMESTAMP)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getTIMESTAMP");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof TIMESTAMPTZ)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (TIMESTAMPTZ)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (TIMESTAMPTZ)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getTIMESTAMPTZ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl50
                if (!(datum instanceof TIMESTAMPLTZ)) break block37;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (TIMESTAMPLTZ)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = (TIMESTAMPLTZ)datum;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var6_7;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getTIMESTAMPLTZ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl50:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_9 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_9;
            {
                catch (Throwable var11_14) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var11_14;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                boolean bl;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    boolean __result__ = datum.booleanValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    bl = __result__;
                    if (!TRACE) return bl;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return bl;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            if (!TRACE) return bl;
            if (!OracleLog.recursiveEnter()) return bl;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int columnIndex) throws SQLException {
        OracleResultSet.AuthorizationIndicator authorizationIndicator;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            authorizationIndicator = null;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return authorizationIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte getByte(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                byte by;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    byte __result__ = datum.byteValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    by = __result__;
                    if (!TRACE) return by;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return by;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return by;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by = 0;
            if (!TRACE) return by;
            if (!OracleLog.recursiveEnter()) return by;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            short s2;
            long __ol_nanos__ = 0L;
            try {
                long result;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((result = this.getLong(columnIndex)) > 65537L || result < -65538L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 26 + "getShort");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (short)result);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                s2 = (short)result;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return s2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getInt(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                int n2;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    int __result__ = datum.intValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    n2 = __result__;
                    if (!TRACE) return n2;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return n2;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return n2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = 0;
            if (!TRACE) return n3;
            if (!OracleLog.recursiveEnter()) return n3;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getLong(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                long l2;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    long __result__ = datum.longValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    l2 = __result__;
                    if (!TRACE) return l2;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return l2;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return l2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = 0L;
            if (!TRACE) return l3;
            if (!OracleLog.recursiveEnter()) return l3;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public float getFloat(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                float f2;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    float __result__ = datum.floatValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    f2 = __result__;
                    if (!TRACE) return f2;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return f2;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return f2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            float f3 = 0.0f;
            if (!TRACE) return f3;
            if (!OracleLog.recursiveEnter()) return f3;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return f3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public double getDouble(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block29: {
                double d2;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block29;
                    double __result__ = datum.doubleValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    d2 = __result__;
                    if (!TRACE) return d2;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return d2;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return d2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            double d3 = 0.0;
            if (!TRACE) return d3;
            if (!OracleLog.recursiveEnter()) return d3;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return d3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                BigDecimal bigDecimal;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    BigDecimal __result__ = datum.bigDecimalValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    bigDecimal = __result__;
                    if (!TRACE) return bigDecimal;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return bigDecimal;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return bigDecimal;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal = null;
            if (!TRACE) return bigDecimal;
            if (!OracleLog.recursiveEnter()) return bigDecimal;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                __ol_nanos__ = 0L;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl51
                if (!(datum instanceof RAW)) break block37;
                __result__ = ((RAW)datum).shareBytes();
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var7_10 = __result__;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var7_10;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getBytes");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBytes");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl51:
            // 1 sources

            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_8 = null;
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var6_8;
            {
                catch (Throwable var12_15) {
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var12_15;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Date getDate(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                Date date;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    Date __result__ = datum.dateValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    date = __result__;
                    if (!TRACE) return date;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return date;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return date;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Date date = null;
            if (!TRACE) return date;
            if (!OracleLog.recursiveEnter()) return date;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Time getTime(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                Time time;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    Time __result__ = datum.timeValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    time = __result__;
                    if (!TRACE) return time;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return time;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return time;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time = null;
            if (!TRACE) return time;
            if (!OracleLog.recursiveEnter()) return time;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                Timestamp timestamp;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    Timestamp __result__ = datum.timestampValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    timestamp = __result__;
                    if (!TRACE) return timestamp;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return timestamp;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return timestamp;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp = null;
            if (!TRACE) return timestamp;
            if (!OracleLog.recursiveEnter()) return timestamp;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            long __ol_nanos__ = 0L;
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) != null) {
                    datum.asciiStreamValue();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                inputStream = null;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            __ol_nanos__ = 0L;
            try {
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl84
                dbconv = this.connection.conversion;
                bytes = datum.shareBytes();
                if (datum instanceof RAW) {
                    __result__ = dbconv.ConvertStream(new ByteArrayInputStream(bytes), 3);
                    if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var9_13 = __result__;
                    if (ArrayDataResultSet.TRACE == false) return var9_13;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var16_21) {
                if (ArrayDataResultSet.TRACE == false) throw var16_21;
                if (OracleLog.recursiveEnter() == false) throw var16_21;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    throw var16_21;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (OracleLog.recursiveEnter() == false) return var9_13;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var9_13;
lbl-1000:
            // 1 sources

            {
                if (!(datum instanceof CHAR)) ** GOTO lbl-1000
                __result__ = dbconv.ConvertStream(new ByteArrayInputStream(bytes), 1);
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_14 = __result__;
                if (ArrayDataResultSet.TRACE == false) return var9_14;
            }
            if (OracleLog.recursiveEnter() == false) return var9_14;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var9_14;
lbl-1000:
            // 1 sources

            {
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getUnicodeStream");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream");
                __ex__.fillInStackTrace();
                throw __ex__;
lbl84:
                // 1 sources

                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_7 = null;
                if (ArrayDataResultSet.TRACE == false) return var6_7;
            }
            if (OracleLog.recursiveEnter() == false) return var6_7;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var6_7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                InputStream inputStream;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    InputStream __result__ = datum.binaryStreamValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    inputStream = __result__;
                    if (!TRACE) return inputStream;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return inputStream;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return inputStream;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = null;
            if (!TRACE) return inputStream;
            if (!OracleLog.recursiveEnter()) return inputStream;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int columnIndex, OracleDataFactory oracleDataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleData oracleData;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(oracleDataFactory));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                Object jdbcObject = this.getObject(columnIndex);
                OracleData __result__ = oracleDataFactory.create(jdbcObject, 0);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleData = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                Object __result__ = this.getObject(columnIndex, this.map);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                object = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory factory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CustomDatum customDatum;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(factory));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                Datum d2 = this.getOracleObject(columnIndex);
                CustomDatum __result__ = factory.create(d2, 0);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                customDatum = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return customDatum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(int columnIndex, ORADataFactory factory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ORAData oRAData;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(factory));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                Datum d2 = this.getOracleObject(columnIndex);
                ORAData __result__ = factory.create(d2, 0);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oRAData = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oRAData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10 + "getMetaData");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getMetaData");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23 + "getMetaData");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getMetaData");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int findColumn(String columnName) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block35: {
                long __ol_nanos__;
                block32: {
                    int n2;
                    __ol_nanos__ = 0L;
                    try {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                            __ol_nanos__ = System.nanoTime();
                        }
                        if (!columnName.equalsIgnoreCase("index")) break block32;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        n2 = 1;
                        if (!TRACE) return n2;
                    }
                    catch (Throwable throwable) {
                        if (!TRACE) throw throwable;
                        if (!OracleLog.recursiveEnter()) throw throwable;
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                            throw throwable;
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (!OracleLog.recursiveEnter()) return n2;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    return n2;
                }
                if (!columnName.equalsIgnoreCase("value")) break block35;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = 2;
                if (!TRACE) return n3;
                if (!OracleLog.recursiveEnter()) return n3;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return n3;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6 + "get_column_index");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, "get_column_index");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() throws SQLException {
        Statement statement;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            statement = null;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getObject(int columnIndex, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block35: {
                Datum datum;
                block36: {
                    Object object;
                    __ol_nanos__ = 0L;
                    try {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(map));
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                            __ol_nanos__ = System.nanoTime();
                        }
                        if ((datum = this.getOracleObject(columnIndex)) == null) break block35;
                        if (!(datum instanceof STRUCT)) break block36;
                        Object __result__ = ((STRUCT)datum).toJdbc(map);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        object = __result__;
                        if (!TRACE) return object;
                    }
                    catch (Throwable throwable) {
                        if (!TRACE) throw throwable;
                        if (!OracleLog.recursiveEnter()) throw throwable;
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                            throw throwable;
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (!OracleLog.recursiveEnter()) return object;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    return object;
                }
                Object __result__ = datum.toJdbc();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object object = __result__;
                if (!TRACE) return object;
                if (!OracleLog.recursiveEnter()) return object;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return object;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object var7_9 = null;
            if (!TRACE) return var7_9;
            if (!OracleLog.recursiveEnter()) return var7_9;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var7_9;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            REF rEF;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                REF __result__ = this.getREF(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rEF = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BLOB bLOB;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                BLOB __result__ = this.getBLOB(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bLOB = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CLOB cLOB;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                CLOB __result__ = this.getCLOB(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                cLOB = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ARRAY aRRAY;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                ARRAY __result__ = this.getARRAY(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                aRRAY = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                Reader reader;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    Reader __result__ = datum.characterStreamValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    reader = __result__;
                    if (!TRACE) return reader;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return reader;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return reader;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reader reader = null;
            if (!TRACE) return reader;
            if (!OracleLog.recursiveEnter()) return reader;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                BigDecimal bigDecimal;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    BigDecimal __result__ = datum.bigDecimalValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    bigDecimal = __result__;
                    if (!TRACE) return bigDecimal;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return bigDecimal;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return bigDecimal;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal = null;
            if (!TRACE) return bigDecimal;
            if (!OracleLog.recursiveEnter()) return bigDecimal;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                Date date;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    DATE dateValue = null;
                    dateValue = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                    if (dateValue == null) break block27;
                    Date __result__ = dateValue.dateValue(cal);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    date = __result__;
                    if (!TRACE) return date;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return date;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return date;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Date date = null;
            if (!TRACE) return date;
            if (!OracleLog.recursiveEnter()) return date;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                Time time;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    DATE dateValue = null;
                    dateValue = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                    if (dateValue == null) break block27;
                    Time __result__ = dateValue.timeValue(cal);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    time = __result__;
                    if (!TRACE) return time;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return time;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return time;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time = null;
            if (!TRACE) return time;
            if (!OracleLog.recursiveEnter()) return time;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__;
            block27: {
                Timestamp timestamp;
                __ol_nanos__ = 0L;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex) + ", " + OracleLog.argument(cal));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    DATE dateValue = null;
                    dateValue = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                    if (dateValue == null) break block27;
                    Timestamp __result__ = dateValue.timestampValue(cal);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    timestamp = __result__;
                    if (!TRACE) return timestamp;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return timestamp;
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return timestamp;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp = null;
            if (!TRACE) return timestamp;
            if (!OracleLog.recursiveEnter()) return timestamp;
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23 + "getCursorName");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        block32: {
            __ol_nanos__ = 0L;
            try {
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl56
                if (!(datum instanceof NCLOB)) break block32;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (NCLOB)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var5_6 = (NCLOB)datum;
            }
            catch (Throwable var10_13) {
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw var10_13;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var5_6;
        }
        if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        __ex__.fillInStackTrace();
        throw __ex__;
lbl56:
        // 1 sources

        if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        var5_8 = null;
        if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return var5_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int columnIndex) throws SQLException {
        long __ol_nanos__;
        block28: {
            String string;
            __ol_nanos__ = 0L;
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) break block28;
                String __result__ = datum.stringValue();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                string = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return string;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        String string = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        long __ol_nanos__;
        block28: {
            Reader reader;
            __ol_nanos__ = 0L;
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) break block28;
                Reader __result__ = datum.characterStreamValue();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                reader = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return reader;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        Reader reader = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        ROWID rOWID;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ROWID __result__ = this.getROWID(columnIndex);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            rOWID = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return rOWID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        block32: {
            __ol_nanos__ = 0L;
            try {
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl56
                if (!(datum instanceof SQLXML)) break block32;
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (SQLXML)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var5_6 = (SQLXML)datum;
            }
            catch (Throwable var10_13) {
                if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw var10_13;
            }
            if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var5_6;
        }
        if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        __ex__.fillInStackTrace();
        throw __ex__;
lbl56:
        // 1 sources

        if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        var5_8 = null;
        if (ArrayDataResultSet.TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return var5_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean bl2 = __result__ = this.currentIndex < 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean bl2 = __result__ = this.currentIndex > this.lastIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean bl2 = __result__ = this.currentIndex == 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean bl2 = __result__ = this.currentIndex == this.lastIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.currentIndex);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.currentIndex;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int rows) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (rows < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.fetchSize = rows == 0 ? OracleConnection.DEFAULT_ROW_PREFETCH : rows;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.fetchSize);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.fetchSize;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDataResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PhysicalConnection physicalConnection = this.connection;
            return physicalConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ArrayDataResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

