/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.aq;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQAgent;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessageI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.InternalFactory;
import oracle.jdbc.driver.OracleLog;

public abstract class AQFactory {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AQMessage createAQMessage(AQMessageProperties prop) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQFactory.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(prop));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQFactory.logger().log(Level.FINER, "         Return: " + InternalFactory.createAQMessage(prop));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            AQMessageI aQMessageI = InternalFactory.createAQMessage(prop);
            return aQMessageI;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQFactory.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AQMessageProperties createAQMessageProperties() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQFactory.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQFactory.logger().log(Level.FINER, "         Return: " + InternalFactory.createAQMessageProperties());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            AQMessagePropertiesI aQMessagePropertiesI = InternalFactory.createAQMessageProperties();
            return aQMessagePropertiesI;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQFactory.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AQAgent createAQAgent() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQFactory.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQFactory.logger().log(Level.FINER, "         Return: " + InternalFactory.createAQAgent());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            AQAgentI aQAgentI = InternalFactory.createAQAgent();
            return aQAgentI;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQFactory.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.aq");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.aq.AQFactory"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

