/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.aq;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;

public class AQDequeueOptions {
    public static final int DEQUEUE_WAIT_FOREVER = -1;
    public static final int DEQUEUE_NO_WAIT = 0;
    private String attrConsumerName;
    private String attrCorrelation;
    private DequeueMode attrDeqMode;
    private byte[] attrDeqMsgId;
    private NavigationOption attrNavigation;
    private VisibilityOption attrVisibility;
    private int attrWait;
    private int maxBufferLength;
    private DeliveryFilter attrDeliveryMode;
    private boolean retrieveMsgId;
    private String transformation;
    private String condition;
    public static final int MAX_RAW_PAYLOAD = 0x3FFFFB3;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AQDequeueOptions() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.attrConsumerName = null;
            this.attrCorrelation = null;
            this.attrDeqMode = DequeueMode.REMOVE;
            this.attrDeqMsgId = null;
            this.attrNavigation = NavigationOption.NEXT_MESSAGE;
            this.attrVisibility = VisibilityOption.ON_COMMIT;
            this.attrWait = -1;
            this.maxBufferLength = 0x3FFFFB3;
            this.attrDeliveryMode = DeliveryFilter.PERSISTENT;
            this.retrieveMsgId = false;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsumerName(String consumerName) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.attrConsumerName = consumerName;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConsumerName() {
        String string;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrConsumerName);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.attrConsumerName;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorrelation(String correlation) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.attrCorrelation = correlation;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCorrelation() {
        String string;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrCorrelation);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.attrCorrelation;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDequeueMode(DequeueMode deqMode) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.attrDeqMode = deqMode;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DequeueMode getDequeueMode() {
        DequeueMode dequeueMode;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.attrDeqMode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            dequeueMode = this.attrDeqMode;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return dequeueMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDequeueMessageId(byte[] deqMsgId) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.attrDeqMsgId = deqMsgId;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDequeueMessageId() {
        byte[] byArray;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrDeqMsgId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byArray = this.attrDeqMsgId;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNavigation(NavigationOption navigation) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.attrNavigation = navigation;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigationOption getNavigation() {
        NavigationOption navigationOption;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.attrNavigation));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            navigationOption = this.attrNavigation;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return navigationOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibility(VisibilityOption visibility) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.attrVisibility = visibility;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisibilityOption getVisibility() {
        VisibilityOption visibilityOption;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.attrVisibility));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            visibilityOption = this.attrVisibility;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return visibilityOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWait(int wait) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.attrWait = wait;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWait() {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrWait);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.attrWait;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumBufferLength(int length) throws SQLException {
        long __ol_nanos__;
        block15: {
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (length <= 0) break block15;
                this.maxBufferLength = length;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximumBufferLength() {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.maxBufferLength);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.maxBufferLength;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeliveryFilter(DeliveryFilter delivery) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.attrDeliveryMode = delivery;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeliveryFilter getDeliveryFilter() {
        DeliveryFilter deliveryFilter;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.attrDeliveryMode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            deliveryFilter = this.attrDeliveryMode;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return deliveryFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRetrieveMessageId(boolean retrieveIt) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.retrieveMsgId = retrieveIt;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRetrieveMessageId() {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.retrieveMsgId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.retrieveMsgId;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransformation(String _transformation) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.transformation = _transformation;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransformation() {
        String string;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.transformation);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.transformation;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(String _condition) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.condition = _condition;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCondition() {
        String string;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.condition);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.condition;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AQDequeueOptions.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.aq");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.aq.AQDequeueOptions"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum DeliveryFilter {
        PERSISTENT(1),
        BUFFERED(2),
        PERSISTENT_OR_BUFFERED(3);

        private final int mode;

        private DeliveryFilter(int _mode) {
            this.mode = _mode;
        }

        public final int getCode() {
            return this.mode;
        }
    }

    public static enum VisibilityOption {
        ON_COMMIT(2),
        IMMEDIATE(1);

        private final int mode;

        private VisibilityOption(int _mode) {
            this.mode = _mode;
        }

        public final int getCode() {
            return this.mode;
        }
    }

    public static enum NavigationOption {
        FIRST_MESSAGE(1),
        NEXT_MESSAGE(3),
        NEXT_TRANSACTION(2);

        private final int mode;

        private NavigationOption(int _mode) {
            this.mode = _mode;
        }

        public final int getCode() {
            return this.mode;
        }
    }

    public static enum DequeueMode {
        BROWSE(1),
        LOCKED(2),
        REMOVE(3),
        REMOVE_NODATA(4);

        private final int mode;

        private DequeueMode(int _mode) {
            this.mode = _mode;
        }

        public final int getCode() {
            return this.mode;
        }
    }
}

