/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva.launcher;

import com.innovation.imperva.AssessmentManager;
import com.innovation.imperva.AsyncUpdateCheck;
import com.innovation.imperva.DbDetails;
import com.innovation.imperva.Logger;
import com.innovation.imperva.ScubaVersion;
import com.innovation.imperva.SqlConnection;
import com.innovation.imperva.Utils;
import java.awt.Desktop;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Border;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.Duration;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class MainController
implements Initializable {
    public ComboBox dbTypeComboBox;
    public TextField userName;
    public TextField hostName;
    public TextField port;
    public PasswordField password;
    public TextField extraData;
    public Button submit;
    public ProgressIndicator progressIndicator;
    public Label progressLabel;
    public ToggleButton windowsAuthenticationButton;
    public GridPane mainGridPane;
    public Label mainLabel;
    public Hyperlink updateAvailableLink;
    public Hyperlink mailLink;
    public Hyperlink phoneLink;
    public VBox mainVBox;
    private boolean wasProgressIndicatorCssSet = false;
    private boolean status;
    private static final String ENABLE_WINDOWS_AUTHENTICATION_TOOLTIP_TEXT = "Enable Windows Authentication";
    private static final String DISABLE_WINDOWS_AUTHENTICATION_TOOLTIP_TEXT = "Disable Windows Authentication";
    private static final String DB_NOT_SUPPORTED_TOOLTIP_TEXT = "Supported in SecureSphere only";
    private static Color progressLabelDefaultColor = Color.valueOf((String)"#00a9e0");
    private static Color progressLabelErrorColor = Color.valueOf((String)"#f44256");
    private AssessmentManager assessmentManager = null;
    private String lastValidDatabaseSelected = null;
    private static final String DEFAULT_CSV_CONNECTION_PATH = Utils.getCurrentFolder() + "/conf/connection.csv";
    private static final int DEFAULT_CSV_RECORDS = 6;
    private static final String CSV_DBTYPE = "DBTYPE";
    private static final String CSV_HOST = "HOST";
    private static final String CSV_PORT = "PORT";
    private static final String CSV_USER = "USER";
    private static final String CSV_EXTRADATA = "EXTRADATA";
    private static final String CSV_WINDOWS_AUTHENTICATION = "WINDOWS_AUTHENTICATION";
    private static final String WINDOWS_AUTHENTICATION_DUMMY_PASSWORD = "dummypass";
    private static final String SCUBA_DOWNLOAD_URL = Utils.appendUtmCode("https://www.imperva.com/lg/lgw_trial.asp") + "&pid=213";
    private static final String SCUBA_IMPERVA_ONLINE_URL = Utils.appendUtmCode("https://www.imperva.com/Products/DatabaseAssessment");
    private static final String SCUBA_EMAIL_HEADER = "Scuba " + ScubaVersion.VERSION;
    private static final String SCUBA_DOCUMENTATION_GUIDE_PATH = Utils.getCurrentFolder() + "/Documentation/Imperva-Scuba-User-Guide.pdf";
    private static final String SCUBA_YOUTUBE_URL = "https://www.youtube.com/watch?v=CzlaP3yoA34";
    private static final String SCUBA_SUPPORT_EMAIL = "Support-Scuba@imperva.com";
    private static final String SCUBA_MESSAGE_BOX_TITLE = "Scuba by Imperva";
    private static final String SCUBA_MESSAGE_BOX_HEADER = "Database Vulnerability Scanner";
    private static final String SCUBA_USAGE_REPORT_URL = "https://www.imperva.com/docs/gated/scuba_version.html";

    private void showErrorMessageBox(String message, Exception ex) {
        Logger.Error(message, ex);
        this.showAlert(Alert.AlertType.ERROR, "Error", message, null, ex == null ? "" : ex.getMessage());
    }

    private boolean isUsingWindowsAuthentication() {
        return this.windowsAuthenticationButton.isSelected() && this.windowsAuthenticationButton.isVisible();
    }

    private SqlConnection.DB_TYPE getDbTypeFromGui() {
        return SqlConnection.DB_TYPE.valueOf(this.dbTypeComboBox.getButtonCell().getText().toUpperCase());
    }

    private SqlConnection getSqlConnectionFromGui() {
        try {
            return new SqlConnection(this.hostName.getText().trim(), this.port.getText().trim(), this.userName.getText(), this.password.getText(), this.extraData.getText().trim(), this.getDbTypeFromGui(), this.isUsingWindowsAuthentication());
        }
        catch (Exception ex) {
            Logger.Error(ex);
            return null;
        }
    }

    private void setIcon(Alert alert) {
        ((Stage)alert.getDialogPane().getScene().getWindow()).getIcons().add((Object)Utils.getImpervaIcon());
    }

    private static String getFixedUrl(String url) {
        return url.replace("\\", "/").replaceAll(" ", "%20");
    }

    private static void launchDefaultApp(String url) {
        if (Desktop.isDesktopSupported()) {
            new Thread(() -> {
                try {
                    String fixedUrl = MainController.getFixedUrl(url);
                    URI uri = new URI(fixedUrl);
                    Desktop.getDesktop().browse(uri);
                }
                catch (IOException | URISyntaxException ex) {
                    Logger.Error("Failed to start default application: " + url, ex);
                }
            }).start();
        } else {
            Logger.Warning("Desktop application is not supported: " + url);
        }
    }

    private static void setHyperlinkFile(Hyperlink link, String url) {
        link.setOnAction(evt -> MainController.launchDefaultApp("file:///" + url));
    }

    private static void setHyperlinkUrl(Hyperlink link, String url) {
        link.setOnAction(evt -> MainController.launchDefaultApp(url));
    }

    private static void removeLinkBorder(Hyperlink link) {
        link.setBorder(Border.EMPTY);
        link.setPadding(new Insets(4.0, 0.0, 4.0, 0.0));
    }

    @FXML
    public void onAbout() {
        try {
            VBox vBox = new VBox();
            Label label = new Label("Scuba " + ScubaVersion.VERSION + ", " + ScubaVersion.DATE);
            Label label2 = new Label("ADC Content: " + ScubaVersion.ADC_CONTENT_VERSION_AND_DATE);
            vBox.getChildren().addAll((Object[])new Node[]{label, label2});
            if (ScubaVersion.isNewVersionAvailable()) {
                Hyperlink link = new Hyperlink("Update available (" + ScubaVersion.getNewestVersion() + ")");
                MainController.setHyperlinkUrl(link, SCUBA_DOWNLOAD_URL);
                MainController.removeLinkBorder(link);
                vBox.getChildren().add((Object)link);
            } else {
                label.setText(label.getText() + " (latest)");
            }
            this.showAlert(Alert.AlertType.INFORMATION, SCUBA_MESSAGE_BOX_TITLE, SCUBA_MESSAGE_BOX_HEADER, vBox, null);
        }
        catch (Exception ex) {
            Logger.Error("onAbout failed", ex);
        }
    }

    @FXML
    public void onSupport() {
        try {
            Label label1 = new Label("Need help? Please review the");
            Label label2 = new Label("Watch this");
            Label label3 = new Label("Or just ");
            Hyperlink documentationLink = new Hyperlink("documentation guide");
            MainController.setHyperlinkFile(documentationLink, SCUBA_DOCUMENTATION_GUIDE_PATH);
            Hyperlink youTubeLink = new Hyperlink("2-minute video");
            MainController.setHyperlinkUrl(youTubeLink, SCUBA_YOUTUBE_URL);
            Hyperlink supportEmailLink = new Hyperlink("contact us");
            MainController.setHyperlinkUrl(supportEmailLink, "mailto:Support-Scuba@imperva.com?subject=" + SCUBA_EMAIL_HEADER + "&body=Please describe your experience, include a screenshot and attach this log file:%0A" + Logger.OUTPUT_FILE_PATH);
            MainController.removeLinkBorder(supportEmailLink);
            VBox vBox = new VBox();
            FlowPane fp1 = new FlowPane();
            FlowPane fp2 = new FlowPane();
            FlowPane fp3 = new FlowPane();
            fp1.getChildren().addAll((Object[])new Node[]{label1, documentationLink});
            fp2.getChildren().addAll((Object[])new Node[]{label2, youTubeLink});
            fp3.getChildren().addAll((Object[])new Node[]{label3, supportEmailLink});
            vBox.getChildren().addAll((Object[])new Node[]{fp1, fp2, fp3});
            this.showAlert(Alert.AlertType.INFORMATION, SCUBA_MESSAGE_BOX_TITLE, SCUBA_MESSAGE_BOX_HEADER, vBox, null);
        }
        catch (Exception ex) {
            Logger.Error("onSupport failed", ex);
        }
    }

    @FXML
    public void onSubmit() {
        try {
            this.setProgressLabelTextColor(false);
            if (!this.validateInput()) {
                return;
            }
            SqlConnection sqlConnection = this.getSqlConnectionFromGui();
            if (sqlConnection == null) {
                this.showMissingJDBCBox(this.getDbTypeFromGui());
                return;
            }
            this.disableAllComponents();
            this.saveToCSV(sqlConnection);
            this.assessmentManager = AssessmentManager.createOrUpdateInstance(sqlConnection);
            this.bindProgressBar();
            this.startAssessmentManager();
        }
        catch (Exception ex) {
            this.showErrorMessageBox("Unable to run assessments", ex);
        }
    }

    private void startAssessmentManager() {
        Thread managerThread = new Thread((Runnable)((Object)this.assessmentManager));
        managerThread.setDaemon(true);
        managerThread.start();
        System.out.println("Manager Thread started");
    }

    private void bindProgressBar() {
        this.progressIndicator.progressProperty().unbind();
        this.progressIndicator.setProgress(0.0);
        this.progressIndicator.progressProperty().bind((ObservableValue)this.assessmentManager.progressProperty());
        this.progressLabel.textProperty().unbind();
        this.progressLabel.setText("");
        this.progressLabel.textProperty().bind((ObservableValue)this.assessmentManager.messageProperty());
    }

    private void changeAllComponents(boolean enable) {
        this.dbTypeComboBox.setDisable(!enable);
        this.hostName.setDisable(!enable);
        this.port.setDisable(!enable);
        this.userName.setDisable(!enable);
        this.password.setDisable(!enable);
        this.extraData.setDisable(!enable);
        this.windowsAuthenticationButton.setDisable(!enable);
        this.submit.setVisible(enable);
        this.progressIndicator.setVisible(!enable);
        this.progressLabel.setVisible(!enable);
    }

    private void enableAllComponents() {
        this.changeAllComponents(true);
        this.progressLabel.textProperty().unbind();
    }

    private void disableAllComponents() {
        this.changeAllComponents(false);
    }

    private void validatePortNum() {
        int portNum;
        try {
            portNum = Integer.parseInt(this.port.getText());
        }
        catch (NumberFormatException ex) {
            this.setInvalidView((Control)this.port);
            return;
        }
        if (1 >= portNum || portNum > 65536) {
            this.setInvalidView((Control)this.port);
            return;
        }
        this.setValidView((Control)this.port);
    }

    private void setValidView(Control control) {
        control.setStyle("");
    }

    private void setInvalidView(Control control) {
        control.setStyle("-fx-background-color: #ff3700;");
        this.status = false;
    }

    private void validateNonEmpty(TextField textField) {
        if (!textField.getText().trim().isEmpty()) {
            this.setValidView((Control)textField);
        } else {
            this.setInvalidView((Control)textField);
        }
    }

    private void validateDbType() {
        if (this.dbTypeComboBox.getValue() != null) {
            this.setValidView((Control)this.dbTypeComboBox);
        } else {
            this.setInvalidView((Control)this.dbTypeComboBox);
        }
    }

    public boolean validateInput() {
        this.status = true;
        this.validateDbType();
        this.validateNonEmpty(this.hostName);
        this.validateNonEmpty(this.userName);
        this.validateNonEmpty((TextField)this.password);
        if (this.dbTypeComboBox.getValue() != null && DbDetails.getDbDetailsMap().get((Object)((Object)SqlConnection.DB_TYPE.valueOf((String)this.dbTypeComboBox.getValue().toString().toUpperCase()))).extraDataState == DbDetails.EXTRADATA_STATE.MUST) {
            this.validateNonEmpty(this.extraData);
        }
        this.validatePortNum();
        return this.status;
    }

    private void clearErrors() {
        this.setValidView((Control)this.hostName);
        this.setValidView((Control)this.port);
        this.setValidView((Control)this.userName);
        this.setValidView((Control)this.password);
        this.setValidView((Control)this.extraData);
    }

    @FXML
    public void onUpdateLink(ActionEvent actionEvent) {
        String updateLink = SCUBA_DOWNLOAD_URL;
        MainController.launchDefaultApp(updateLink);
    }

    @FXML
    public void onMailto(ActionEvent actionEvent) {
        MainController.launchDefaultApp("mailto:" + this.mailLink.getText() + "?subject=" + SCUBA_EMAIL_HEADER);
    }

    @FXML
    public void onImpervaLink(ActionEvent actionEvent) {
        MainController.launchDefaultApp(SCUBA_IMPERVA_ONLINE_URL);
    }

    @FXML
    public void onPhoneLink(ActionEvent actionEvent) {
        MainController.launchDefaultApp("tel:" + this.phoneLink.getText());
    }

    @FXML
    public void onWindowsAuthentication(ActionEvent actionEvent) {
        try {
            boolean isWindowsAuthentication = this.isUsingWindowsAuthentication();
            this.userName.setDisable(isWindowsAuthentication);
            this.password.setDisable(isWindowsAuthentication);
            if (isWindowsAuthentication) {
                this.userName.setText(Utils.getCurrentUser());
                this.password.setText(WINDOWS_AUTHENTICATION_DUMMY_PASSWORD);
                this.windowsAuthenticationButton.getTooltip().setText(DISABLE_WINDOWS_AUTHENTICATION_TOOLTIP_TEXT);
            } else {
                this.userName.setText("");
                this.password.setText("");
                this.windowsAuthenticationButton.getTooltip().setText(ENABLE_WINDOWS_AUTHENTICATION_TOOLTIP_TEXT);
            }
        }
        catch (Exception ex) {
            Logger.Error("onWindowsAuthentication failed", ex);
        }
    }

    @FXML
    public void onEnter(ActionEvent actionEvent) {
        this.onSubmit();
    }

    private ImageView getImageViewFromResources(String resourcePath) {
        return new ImageView(new Image(this.getClass().getClassLoader().getResourceAsStream(resourcePath), 25.0, 25.0, true, true));
    }

    public static boolean isSupportedDatabase(String database) {
        try {
            return DbDetails.getDbDetailsMap().get((Object)((Object)SqlConnection.DB_TYPE.valueOf((String)database))).isSupported;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void setComboBox() {
        this.dbTypeComboBox.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

            public ListCell<String> call(ListView<String> p) {
                return new ListCell<String>(){

                    protected void updateItem(String item, boolean empty) {
                        try {
                            super.updateItem((Object)item, empty);
                            this.setText(item);
                            if (item == null || empty) {
                                this.setGraphic(null);
                                return;
                            }
                            this.setItemPicture(item);
                            this.setItemTooltip(item);
                        }
                        catch (Exception ex) {
                            Logger.Error("ComboBox updateItem error", ex);
                        }
                    }

                    private void setItemPicture(String item) {
                        try {
                            this.setGraphic((Node)MainController.this.getImageViewFromResources("databases/DEFAULT.png"));
                        }
                        catch (Exception ex) {
                            Logger.Error("Failed setting icon", ex);
                        }
                    }

                    private void setItemTooltip(String item) {
                        try {
                            if (!MainController.isSupportedDatabase(item)) {
                                MainController.setTooltipTextAndTime((Control)this, MainController.DB_NOT_SUPPORTED_TOOLTIP_TEXT);
                                this.setStyle("-fx-opacity: 1; -fx-text-fill: darkgrey; -fx-background-color: lightgrey");
                            }
                        }
                        catch (Exception ex) {
                            Logger.Error("Failed setting disable/enable for db: " + item, ex);
                        }
                    }
                };
            }
        });
        this.dbTypeComboBox.setButtonCell((ListCell)new StringImageCell());
        this.dbTypeComboBox.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldDb, Object newDb) {
                if (!MainController.isSupportedDatabase((String)newDb)) {
                    return;
                }
                MainController.this.clearAllTextFields();
                MainController.this.windowsAuthenticationButton.setSelected(false);
                MainController.this.setValidView((Control)MainController.this.dbTypeComboBox);
                MainController.this.setDbDependantComponents(SqlConnection.DB_TYPE.valueOf((String)newDb));
            }
        });
        for (SqlConnection.DB_TYPE dbType : SqlConnection.DB_TYPE.values()) {
            if (dbType == SqlConnection.DB_TYPE.UNKNOWN) continue;
            this.dbTypeComboBox.getItems().add((Object)dbType.toString());
        }
    }

    private void startAsyncUpdateCheck() {
        AsyncUpdateCheck updateCheck = new AsyncUpdateCheck();
        this.updateAvailableLink.visibleProperty().bind((ObservableValue)updateCheck.valueProperty());
        Thread updateCheckThread = new Thread((Runnable)((Object)updateCheck));
        updateCheckThread.setDaemon(true);
        updateCheckThread.start();
    }

    private WebView createBackgroundWebView() {
        WebView webView = new WebView();
        webView.setMaxWidth(0.0);
        webView.setMaxHeight(0.0);
        webView.setVisible(false);
        WebEngine webEngine = webView.getEngine();
        webEngine.setJavaScriptEnabled(true);
        webEngine.getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> {
            try {
                Logger.Debug("Status: " + newState.toString());
                if (newState == Worker.State.SUCCEEDED) {
                    Logger.Notify("Background web engine loaded");
                }
            }
            catch (Exception ex) {
                Logger.Error("WebEngine worker failed: ", ex);
            }
        });
        return webView;
    }

    private void reportUsage() {
        try {
            WebView webView = this.createBackgroundWebView();
            webView.getEngine().load(SCUBA_USAGE_REPORT_URL);
            this.mainVBox.getChildren().add((Object)webView);
        }
        catch (Exception ex) {
            Logger.Error("WebView creation failed", ex);
        }
    }

    private void initializeGUIComponents() {
        this.setComboBox();
        this.addListeners();
        this.setToggleButtonView();
        this.startAsyncUpdateCheck();
        this.reportUsage();
    }

    public static void setTooltipTextAndTime(Control control, String text) {
        try {
            Tooltip tooltip = control.getTooltip();
            if (tooltip == null) {
                tooltip = new Tooltip(text);
            } else {
                tooltip.setText(text);
            }
            MainController.setTooltipStartTiming(tooltip);
            control.setTooltip(tooltip);
        }
        catch (Exception ex) {
            Logger.Error("Failed setting tooltip with text: " + text);
        }
    }

    public static void setTooltipStartTiming(Tooltip tooltip) {
        try {
            Field fieldBehavior = tooltip.getClass().getDeclaredField("BEHAVIOR");
            fieldBehavior.setAccessible(true);
            Object objBehavior = fieldBehavior.get(tooltip);
            Field fieldTimer = objBehavior.getClass().getDeclaredField("activationTimer");
            fieldTimer.setAccessible(true);
            Timeline objTimer = (Timeline)fieldTimer.get(objBehavior);
            objTimer.getKeyFrames().clear();
            objTimer.getKeyFrames().add((Object)new KeyFrame(new Duration(100.0), new KeyValue[0]));
        }
        catch (Exception ex) {
            System.out.println("Failed setting tooltip activationTimer ; " + ex.toString());
        }
    }

    private void setToggleButtonView() {
        try {
            this.windowsAuthenticationButton.setGraphic((Node)this.getImageViewFromResources("windowsAuthentication.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setProgressIndicatorTextFont() {
        try {
            Text text;
            if (!this.wasProgressIndicatorCssSet && (text = (Text)this.progressIndicator.lookup(".percentage")) != null) {
                text.setFill((Paint)progressLabelDefaultColor);
                Font font = text.getFont();
                text.setFont(Font.font((String)font.getFamily(), (FontWeight)FontWeight.BOLD, (double)font.getSize()));
                this.wasProgressIndicatorCssSet = true;
            }
        }
        catch (Exception ex) {
            Logger.Error("Failed to set progressIndicator font", ex);
        }
    }

    private void setProgressLabelTextColor(boolean isError) {
        this.progressLabel.setTextFill((Paint)(isError ? progressLabelErrorColor : progressLabelDefaultColor));
        if (isError) {
            MainController.setTooltipTextAndTime((Control)this.progressLabel, this.progressLabel.getText());
        } else {
            this.progressLabel.setTooltip(null);
        }
    }

    private void addListeners() {
        this.progressIndicator.progressProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    if (newValue.doubleValue() == 0.0 && oldValue.doubleValue() == 1.0) {
                        System.out.println("Closing window");
                        ((Stage)MainController.this.progressIndicator.getScene().getWindow()).close();
                        return;
                    }
                    if (newValue.doubleValue() == 0.25 && oldValue.doubleValue() == 0.5) {
                        System.out.println("Error occurred");
                        MainController.this.enableAllComponents();
                        MainController.this.progressLabel.setVisible(true);
                        MainController.this.setProgressLabelTextColor(true);
                    }
                    MainController.this.setProgressIndicatorTextFont();
                }
                catch (Exception ex) {
                    Logger.Error("ProgressIndicator update error", ex);
                }
            }
        });
        this.setTextFieldListener(this.hostName);
        this.setTextFieldListener(this.port);
        this.setTextFieldListener(this.userName);
        this.setTextFieldListener((TextField)this.password);
        this.setTextFieldListener(this.extraData);
    }

    private void setTextFieldListener(TextField textField) {
        textField.textProperty().addListener((observable, oldValue, newValue) -> {
            this.setValidView((Control)textField);
            this.progressLabel.setText("");
        });
    }

    private void clearAllTextFields() {
        this.hostName.setText("");
        this.port.setText("");
        this.userName.setText("");
        this.password.setText("");
        this.extraData.setText("");
        this.progressLabel.setText("");
    }

    private void setExtraDataGui(SqlConnection.DB_TYPE dbType) {
        String text = DbDetails.getDbDetailsMap().get((Object)((Object)dbType)).extraDataPlaceholderText;
        if (DbDetails.getDbDetailsMap().get((Object)((Object)dbType)).extraDataState == DbDetails.EXTRADATA_STATE.OPTIONAL) {
            text = text + " (optional)";
        }
        this.extraData.setPromptText(text);
        this.extraData.setVisible(DbDetails.getDbDetailsMap().get((Object)((Object)dbType)).extraDataState != DbDetails.EXTRADATA_STATE.IRRELEVANT);
    }

    private void setDefaultPort(SqlConnection.DB_TYPE dbType) {
        this.port.setText(Integer.toString(DbDetails.getDbDetailsMap().get((Object)((Object)dbType)).defaultPort));
    }

    private void setWindowsAuthenticationGui(boolean enabled, boolean isInUse) {
        Insets insets;
        if (enabled && Utils.isWindows()) {
            this.windowsAuthenticationButton.setVisible(true);
            insets = new Insets(0.0, 0.0, 0.0, 40.0);
            this.windowsAuthenticationButton.setSelected(isInUse);
            this.onWindowsAuthentication(null);
        } else {
            this.windowsAuthenticationButton.setVisible(false);
            insets = new Insets(0.0, 0.0, 0.0, 0.0);
            this.userName.setDisable(false);
            this.password.setDisable(false);
        }
        GridPane.setMargin((Node)this.userName, (Insets)insets);
        GridPane.setMargin((Node)this.password, (Insets)insets);
    }

    private void setWindowsAuthenticationGuiDefault(SqlConnection.DB_TYPE dbType, boolean isInUse) {
        this.setWindowsAuthenticationGui(DbDetails.getDbDetailsMap().get((Object)((Object)dbType)).isWindowsAuthenticationSupported, isInUse);
    }

    private void setDbDependantComponents(SqlConnection.DB_TYPE dbType) {
        try {
            this.setDefaultPort(dbType);
            this.setExtraDataGui(dbType);
            this.setWindowsAuthenticationGuiDefault(dbType, true);
            this.clearErrors();
        }
        catch (Exception ex) {
            Logger.Error("ComboBox update error: dbType: " + (Object)((Object)dbType), ex);
        }
    }

    private void loadLastKnownScanDetails() {
        try {
            CSVRecord record = new CSVParser(new FileReader(DEFAULT_CSV_CONNECTION_PATH), CSVFormat.DEFAULT.withHeader(new String[0])).getRecords().get(0);
            if (record.size() != 6) {
                Logger.Warning("Error reading connection CSV file. Expected for 6 records but got " + record.size());
                return;
            }
            SqlConnection.DB_TYPE dbType = SqlConnection.DB_TYPE.valueOf(record.get(CSV_DBTYPE));
            this.dbTypeComboBox.setValue((Object)dbType);
            this.setDbDependantComponents(dbType);
            this.hostName.setText(record.get(CSV_HOST));
            this.port.setText(record.get(CSV_PORT));
            this.extraData.setText(record.get(CSV_EXTRADATA));
            boolean isWindowsAuthentication = record.get(CSV_WINDOWS_AUTHENTICATION).equals("true");
            this.setWindowsAuthenticationGuiDefault(dbType, isWindowsAuthentication);
            this.userName.setText(record.get(CSV_USER));
            this.password.setText(isWindowsAuthentication ? WINDOWS_AUTHENTICATION_DUMMY_PASSWORD : "");
        }
        catch (FileNotFoundException ex) {
            Logger.Notify("No input CSV file found");
            return;
        }
        catch (Exception ex) {
            Logger.Warning("Failed reading CSV input file: " + DEFAULT_CSV_CONNECTION_PATH, ex);
            return;
        }
    }

    private void saveToCSV(SqlConnection sqlConnection) {
        try {
            String output = "DBTYPE,HOST,PORT,USER,EXTRADATA,WINDOWS_AUTHENTICATION\r\n" + (Object)((Object)sqlConnection.getDbType()) + "," + sqlConnection.getHost() + "," + sqlConnection.getPort() + "," + sqlConnection.getUser() + "," + sqlConnection.getExtraData() + "," + sqlConnection.getIsWindowsAuthentication();
            Path outputFile = Paths.get(DEFAULT_CSV_CONNECTION_PATH, new String[0]);
            Files.write(outputFile, output.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            Logger.Error("Failed writing sql connection to file", e);
        }
    }

    public void initialize(URL fxmlFileLocation, ResourceBundle resources) {
        try {
            this.loadLastKnownScanDetails();
            this.initializeGUIComponents();
        }
        catch (Exception ex) {
            this.showErrorMessageBox("Failed initializing GUI", ex);
        }
    }

    private void showMissingJDBCBox(SqlConnection.DB_TYPE dbName) {
        FlowPane fp1 = new FlowPane();
        FlowPane fp2 = new FlowPane();
        VBox vBox = new VBox();
        Label lbl1 = new Label("Download the JDBC driver from");
        Hyperlink link1 = new Hyperlink((Object)((Object)dbName) + " website");
        Label lbl2 = new Label("Extract the file/folder to the");
        Hyperlink link2 = new Hyperlink((Object)((Object)dbName) + " folder");
        fp1.getChildren().addAll((Object[])new Node[]{lbl1, link1});
        fp2.getChildren().addAll((Object[])new Node[]{lbl2, link2});
        vBox.getChildren().addAll((Object[])new Node[]{fp1, fp2});
        String customMessage = DbDetails.getDbDetailsMap().get((Object)((Object)dbName)).customMessageOnMissingJar;
        if (customMessage != null) {
            FlowPane fp3 = new FlowPane();
            Label lbl3 = new Label(customMessage);
            fp3.getChildren().add((Object)lbl3);
            vBox.getChildren().add((Object)fp3);
        }
        MainController.setHyperlinkUrl(link1, DbDetails.getDbDetailsMap().get((Object)((Object)dbName)).jdbcUrl);
        MainController.setHyperlinkFile(link2, SqlConnection.getJdbcDefaultDirPath(dbName));
        this.showAlert(Alert.AlertType.INFORMATION, SCUBA_MESSAGE_BOX_TITLE, "Missing JDBC driver for " + (Object)((Object)dbName), vBox, null);
    }

    private void showAlert(Alert.AlertType alertType, String title, String header, VBox vBox, String contextText) {
        Alert alert = new Alert(alertType);
        alert.setTitle(title);
        alert.setHeaderText(header);
        if (contextText != null) {
            alert.setContentText(contextText);
        }
        if (vBox != null) {
            alert.getDialogPane().contentProperty().set((Object)vBox);
        }
        this.setIcon(alert);
        alert.initOwner(this.progressLabel.getScene().getWindow());
        alert.showAndWait();
    }

    class StringImageCell
    extends ListCell<String> {
        Label label;

        StringImageCell() {
        }

        protected void updateItem(String item, boolean empty) {
            try {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setItem(null);
                    this.setGraphic(null);
                    return;
                }
                this.setItemAndPicture(item);
            }
            catch (Exception ex) {
                Logger.Error("Error while setting selected icon. Item = " + item, ex);
            }
        }

        private void setItemAndPicture(String item) {
            if (MainController.isSupportedDatabase(item)) {
                MainController.this.lastValidDatabaseSelected = item;
            } else {
                if (MainController.this.lastValidDatabaseSelected == null) {
                    return;
                }
                item = MainController.this.lastValidDatabaseSelected;
            }
            this.setText(item);
            ImageView image = new ImageView(new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("databases/DEFAULT.png"), 20.0, 20.0, true, true));
            this.label = new Label("", (Node)image);
            this.setGraphic((Node)this.label);
        }
    }
}

