/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva.launcher;

import com.innovation.imperva.Logger;
import com.innovation.imperva.ScubaVersion;
import com.innovation.imperva.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class EulaController
implements Initializable {
    public Button acceptEula;
    public Button declineEula;
    public TextArea textarea;
    public Label label;
    private static boolean acceptedEULA = false;
    private static final String EULA_PATH = "/eula.txt";
    private static final String EULA_ACCEPT_PATH = Utils.getCurrentFolder() + "/conf/eula_accept";

    public static boolean isEULAAccepted() {
        if (EulaController.wasEulaAlreadyAccepted()) {
            return true;
        }
        EulaController eulaController = new EulaController();
        eulaController.runEULA();
        return EulaController.getEulaValue();
    }

    private static boolean getEulaValue() {
        return acceptedEULA;
    }

    public void runEULA() {
        try {
            Stage stage = new Stage();
            ClassLoader classloader = this.getClass().getClassLoader();
            URL url = classloader.getResource("eula.fxml");
            FXMLLoader loader = new FXMLLoader(url);
            Parent rootEULA = (Parent)loader.load();
            Scene scene = new Scene(rootEULA);
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setScene(scene);
            stage.getIcons().add((Object)Utils.getImpervaIcon());
            stage.setTitle("Scuba EULA");
            stage.setResizable(false);
            stage.showAndWait();
        }
        catch (Exception ex) {
            Logger.Error("Failed initializing EULA");
        }
    }

    @FXML
    public void onDeclineEULA(ActionEvent actionEvent) {
        this.closeStage(actionEvent);
    }

    @FXML
    public void onAcceptEULA(ActionEvent actionEvent) {
        EulaController.eulaAccepted();
        this.closeStage(actionEvent);
    }

    private void closeStage(ActionEvent actionEvent) {
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    private static boolean wasEulaAlreadyAccepted() {
        try {
            String fileString = new String(Files.readAllBytes(Paths.get(EULA_ACCEPT_PATH, new String[0])), StandardCharsets.UTF_8);
            return fileString.equals(ScubaVersion.VERSION);
        }
        catch (NoSuchFileException fileString) {
        }
        catch (Exception ex) {
            Logger.Error("Failure while checking eula", ex);
        }
        return false;
    }

    public static void eulaAccepted() {
        acceptedEULA = true;
        try {
            Path file = Paths.get(EULA_ACCEPT_PATH, new String[0]);
            Files.write(file, ScubaVersion.VERSION.getBytes(), new OpenOption[0]);
        }
        catch (IOException ex) {
            return;
        }
    }

    public void initialize(URL fxmlFileLocation, ResourceBundle resources) {
        String eula;
        try {
            InputStream in = this.getClass().getResourceAsStream(EULA_PATH);
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(in));){
                eula = buffer.lines().collect(Collectors.joining("\n"));
            }
        }
        catch (IOException ex) {
            Logger.Error("Error reading the license file: ", ex);
            eula = "missing license file";
        }
        this.textarea.setText(eula);
    }
}

