/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva;

import com.innovation.imperva.Logger;
import com.innovation.imperva.ScubaVersion;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Scanner;
import javafx.scene.image.Image;

public class Utils {
    private static final String OS = System.getProperty("os.name").toLowerCase();

    public static String getCurrentFolder() {
        return System.getProperty("user.dir");
    }

    public static String getTimeNowInString() {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(Calendar.getInstance().getTime());
    }

    public static String toThousandsView(int number) {
        return NumberFormat.getNumberInstance(Locale.US).format(number);
    }

    public static Image getImpervaIcon() {
        return new Image(Utils.getClassLoader().getResourceAsStream("Imperva.png"));
    }

    public static String getCurrentUser() {
        try {
            return System.getProperty("user.name");
        }
        catch (Exception ex) {
            System.out.println("Unable to get current user name ; " + ex.toString());
            return "";
        }
    }

    public static String appendUtmCode(String url) {
        return url + Utils.getUtmCode();
    }

    public static String getUtmCode() {
        return "?utm_medium=internal&utm_source=" + Utils.getUtmSource() + "&utm_campaign=scuba_" + ScubaVersion.VERSION;
    }

    public static String getPlatform() {
        if (Utils.isWindows()) {
            return "windows";
        }
        if (Utils.isMac()) {
            return "mac";
        }
        if (Utils.isLinux()) {
            return "linux";
        }
        return "unknown";
    }

    private static String getUtmSource() {
        return "scuba_" + Utils.getPlatform();
    }

    public static boolean isWindows() {
        return OS.contains("windows");
    }

    private static boolean isMac() {
        return OS.contains("mac");
    }

    private static boolean isLinux() {
        return OS.contains("linux");
    }

    public static String readResourceFile(String resource, String defaultValue) {
        try {
            return new Scanner(Utils.getClassLoader().getResourceAsStream(resource)).nextLine();
        }
        catch (Exception e) {
            Logger.Debug("Error loading resource " + resource);
            return defaultValue;
        }
    }

    public static String escapeJsonString(String str) {
        if (str == null) {
            return "";
        }
        str = str.replaceAll("\n", "<br>");
        str = str.replaceAll("\\\\", "\\\\\\\\");
        str = str.replaceAll("\"", "\\\\\"");
        return str.replaceAll("'", "\\\\'");
    }

    private static ClassLoader getClassLoader() {
        return Utils.class.getClassLoader();
    }
}

