/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva;

import com.innovation.imperva.DbDetails;
import com.innovation.imperva.DriverShim;
import com.innovation.imperva.Logger;
import com.innovation.imperva.SqlHelper;
import com.innovation.imperva.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class SqlConnection {
    private static final String JDBC_JSON_PATH = Utils.getCurrentFolder() + "/conf/jdbc.json";
    public static final String ODBC_DIR = Utils.getCurrentFolder() + "/ODBC/Production/";
    public static final String JDBC_URL_FORMAT = "jar:file:%s!/";
    private String host;
    private String port;
    private String user;
    private String password;
    private DB_TYPE dbType;
    private String extraData = "";
    private boolean isWindowsAuthentication;
    private Connection con = null;
    private Statement statement = null;
    private String failReason;
    private Set<URL> jdbcJarSet = new HashSet<URL>();
    private Set<String> jdbcDriverNameSet = new HashSet<String>();
    private Set<String> urlTemplateSet = new HashSet<String>();

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public DB_TYPE getDbType() {
        return this.dbType;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getServerAddress() {
        return this.getHost() + ":" + this.getPort();
    }

    public Statement getStatement() {
        return this.statement;
    }

    public Boolean isDBConnected() {
        try {
            if (this.statement.isClosed()) {
                return false;
            }
            return !this.con.isClosed();
        }
        catch (SQLException e) {
            Logger.Error("Error checking connection state: ", e);
            return false;
        }
    }

    public String getExtraData() {
        return this.extraData;
    }

    public boolean getIsWindowsAuthentication() {
        return this.isWindowsAuthentication;
    }

    public String getFailReason() {
        return this.failReason;
    }

    private static void setGlobalSettings() {
        DriverManager.setLoginTimeout(30);
    }

    public static String getJdbcDefaultDirPath(DB_TYPE dbType) {
        if (dbType == DB_TYPE.MSSQL || dbType == DB_TYPE.SYBASE) {
            return ODBC_DIR + "Sybase_MsSql";
        }
        return ODBC_DIR + dbType.toString();
    }

    private boolean checkValidJDBC(URL url, String driverClassName) {
        try {
            Logger.Notify("validating jar: " + url.toString() + " Driver: " + driverClassName);
            URLClassLoader ucl = new URLClassLoader(new URL[]{url});
            Driver d = (Driver)Class.forName(driverClassName, true, ucl).newInstance();
            Logger.Notify("Using " + d.toString() + " ; Version: " + d.getMajorVersion() + "." + d.getMinorVersion());
            DriverManager.registerDriver(new DriverShim(d));
            return true;
        }
        catch (ClassNotFoundException ex) {
            Logger.Warning("class not found: ", ex);
        }
        catch (Exception ex) {
            Logger.Error("unexpected exception: ", ex);
        }
        return false;
    }

    public String formatConnectionUrl(String url) throws Exception {
        String formattedUrl = url.replaceAll("\\{host\\}", this.host);
        formattedUrl = formattedUrl.replaceAll("\\{port\\}", this.port);
        if ((formattedUrl = formattedUrl.replaceAll("\\{database\\}", this.extraData)).indexOf("{") != -1 || formattedUrl.indexOf("}") != -1) {
            throw new Exception("Bad connection string: " + url);
        }
        return formattedUrl;
    }

    private Boolean parseConfig(String jsonPath) {
        try {
            String jdbcContent = new String(Files.readAllBytes(Paths.get(jsonPath, new String[0])));
            JSONObject jsonObject = new JSONObject(jdbcContent);
            if (jsonObject.has(this.dbType.toString())) {
                JSONObject jdbcObj = (JSONObject)jsonObject.get(this.dbType.toString());
                JSONArray driverNameArray = (JSONArray)jdbcObj.get("driver name");
                for (Object obj : driverNameArray) {
                    this.jdbcDriverNameSet.add((String)obj);
                }
                JSONArray connectionStringArray = (JSONArray)jdbcObj.get("connection string");
                for (Object obj : connectionStringArray) {
                    this.urlTemplateSet.add((String)obj);
                }
            }
        }
        catch (IOException ex) {
            Logger.Warning("No jdbc config file found", ex);
            return false;
        }
        return true;
    }

    private void getJDBCFilesInPath(String jdbcPath) {
        ArrayList jarList = new ArrayList();
        Path start = FileSystems.getDefault().getPath(SqlConnection.getJdbcDefaultDirPath(this.dbType), new String[0]);
        try {
            Files.walk(start, new FileVisitOption[0]).filter(path -> path.toFile().isFile()).filter(path -> path.toString().endsWith(".jar")).forEach(path -> jarList.add(path));
        }
        catch (IOException ex) {
            Logger.Error("Error searching path for jar files", ex);
        }
        if (jarList.size() > 0) {
            block4: for (Path path2 : jarList) {
                for (String driverClassName : this.jdbcDriverNameSet) {
                    try {
                        if (!this.checkValidJDBC(new URL(String.format(JDBC_URL_FORMAT, path2)), driverClassName)) continue;
                        this.jdbcJarSet.add(new URL(String.format(JDBC_URL_FORMAT, path2)));
                        continue block4;
                    }
                    catch (MalformedURLException ex) {
                        Logger.Error(ex);
                    }
                }
            }
        }
    }

    private boolean checkJDBC(String jsonPath) {
        this.parseConfig(jsonPath);
        this.getJDBCFilesInPath(jsonPath);
        if (this.jdbcJarSet.size() == 0) {
            Logger.Warning("No jdbc jar files found");
            return false;
        }
        return true;
    }

    public SqlConnection(String host, String port, String user, String password, String extraData, DB_TYPE dbType, boolean isWindowsAuthentication) throws Exception {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.dbType = dbType;
        this.extraData = extraData;
        this.isWindowsAuthentication = isWindowsAuthentication;
        SqlConnection.setGlobalSettings();
        if (!this.checkJDBC(JDBC_JSON_PATH)) {
            throw new Exception("JDBC jar could not be found");
        }
    }

    public String toString() {
        return "host: " + this.host + " ; port: " + this.port + " ; user: " + this.user + " ; dbType: " + (Object)((Object)this.dbType) + " ; extraData: " + this.extraData + " ; connectionUrl: " + this.urlTemplateSet;
    }

    private Connection getConnection(String connectionString) throws Exception {
        return this.isWindowsAuthentication ? DriverManager.getConnection(connectionString) : DriverManager.getConnection(connectionString, this.getUser(), this.getPassword());
    }

    public boolean ConnectDB() {
        Boolean status = false;
        try {
            for (URL url : this.jdbcJarSet) {
                for (String driverClass : this.jdbcDriverNameSet) {
                    if (!this.checkValidJDBC(url, driverClass)) continue;
                    status = true;
                    break;
                }
                if (!status.booleanValue()) continue;
                break;
            }
            if (!status.booleanValue()) {
                Logger.Error("Couldn't find jdbc driver");
                this.failReason = "Missing JDBC driver";
                return false;
            }
            status = false;
            for (String connTemplate : this.urlTemplateSet) {
                String connectionStr = this.formatConnectionUrl(connTemplate);
                try {
                    this.con = this.getConnection(connectionStr);
                    this.statement = this.con.createStatement();
                    this.statement.setQueryTimeout(30);
                    status = true;
                    break;
                }
                catch (SQLException ex) {
                    Logger.Warning("Unable to connect to DB - " + connectionStr, ex);
                    this.failReason = ex.getMessage();
                }
            }
        }
        catch (Exception ex) {
            Logger.Error("Unable to Connect to DB: ", ex);
            this.failReason = "Test connection failed";
        }
        return status;
    }

    public String getRemoteOsVersion() {
        String result = "";
        try {
            result = SqlHelper.execute(DbDetails.getDbDetailsMap().get((Object)((Object)this.dbType)).remoteHostOsQuery);
            if (result.equals("0")) {
                result = "";
            }
        }
        catch (Exception e) {
            Logger.Error("Error getting System information: ", e);
        }
        return result;
    }

    public String getDbVersion() {
        String result = "";
        try {
            if (this.con != null && !this.con.isClosed()) {
                result = this.con.getMetaData().getDatabaseProductVersion();
            }
        }
        catch (Exception e) {
            Logger.Error("Error getting Database version: ", e);
        }
        return result;
    }

    public boolean reConnectDB() {
        try {
            this.statement.close();
            this.con.close();
            return this.ConnectDB();
        }
        catch (Exception e) {
            Logger.Error("Unable to reConnect to DB ", e);
            return false;
        }
    }

    public static DB_TYPE ConvertDBType(String dbTypeStr) {
        switch (dbTypeStr) {
            case "MsSql": {
                return DB_TYPE.MSSQL;
            }
            case "Oracle": {
                return DB_TYPE.ORACLE;
            }
            case "MySql": {
                return DB_TYPE.MYSQL;
            }
            case "Db2": {
                return DB_TYPE.DB2;
            }
            case "Sybase": {
                return DB_TYPE.SYBASE;
            }
            case "SybaseIQ": {
                return DB_TYPE.SYBASEIQ;
            }
            case "PostgreSql": {
                return DB_TYPE.POSTGRESQL;
            }
            case "Informix": {
                return DB_TYPE.INFORMIX;
            }
        }
        return DB_TYPE.UNKNOWN;
    }

    public static enum DB_TYPE {
        MSSQL,
        ORACLE,
        MYSQL,
        DB2,
        SYBASE,
        SYBASEIQ,
        POSTGRESQL,
        INFORMIX,
        UNKNOWN;

    }
}

