/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva;

import com.innovation.imperva.Configuration;
import com.innovation.imperva.Logger;
import com.innovation.imperva.Utils;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.json.JSONArray;
import org.json.JSONObject;

public class ScubaVersion {
    private static final String SCUBA_VERSION_FILE_NAME = "scuba_version.txt";
    private static final String SCUBA_DATE_FILE_NAME = "scuba_date.txt";
    public static final String VERSION = Utils.readResourceFile("scuba_version.txt", "3.0");
    public static final String DATE = Utils.readResourceFile("scuba_date.txt", "2017");
    private static boolean IS_NEW_VERSION_AVAILABLE = false;
    private static String newVersion;
    private static final String ADC_CONTENT_VERSION_PATH;
    private static final String ADC_CONTENT_KEYWORD = "ADC_CONTENT_UPDATE_DATE";
    public static final String ADC_CONTENT_VERSION_AND_DATE;

    public static boolean isNewVersionAvailable() {
        return IS_NEW_VERSION_AVAILABLE;
    }

    public static void setNewVersion(String newVersionFound) {
        Logger.Notify("Update available: " + newVersionFound);
        IS_NEW_VERSION_AVAILABLE = true;
        newVersion = newVersionFound;
    }

    public static boolean isNewVersion(String newVersion) {
        try {
            if (newVersion == null) {
                Logger.Warning("New version is null");
                return false;
            }
            Logger.Notify("Current version: " + VERSION + " ; Latest version: " + newVersion);
            StringTokenizer stNew = new StringTokenizer(newVersion, ".");
            StringTokenizer stCurrent = new StringTokenizer(VERSION, ".");
            while (stNew.hasMoreElements() && stCurrent.hasMoreElements()) {
                int currentValue;
                int newValue = Integer.parseInt(stNew.nextElement().toString());
                if (newValue > (currentValue = Integer.parseInt(stCurrent.nextElement().toString()))) {
                    return true;
                }
                if (newValue >= currentValue) continue;
                Logger.Warning("Online version seems to be older than current. Current: " + VERSION + " ; New: " + newVersion);
                return false;
            }
            return false;
        }
        catch (Exception ex) {
            Logger.Error("Failed to parse versions. Current: " + VERSION + " ; New: " + newVersion, ex);
            return false;
        }
    }

    public static String getNewestVersion() {
        return newVersion;
    }

    private static String getAdcContentVersionAndDate() {
        try {
            JSONArray jsonArray = new JSONArray(new String(Files.readAllBytes(Paths.get(ADC_CONTENT_VERSION_PATH, new String[0]))));
            if (jsonArray.length() != 1) {
                throw new Exception("Unknown Version-array structure. Expecting 1 element, while found " + jsonArray.length() + " instead");
            }
            JSONObject jsonObject = jsonArray.getJSONObject(0);
            if (!jsonObject.has(ADC_CONTENT_KEYWORD)) {
                throw new Exception("ADC Content keyword in JSON is missing: ADC_CONTENT_UPDATE_DATE");
            }
            String adcContentDetails = jsonObject.get(ADC_CONTENT_KEYWORD).toString().split(" ")[0];
            Date date = new SimpleDateFormat("yyyy-MM-dd").parse(adcContentDetails);
            adcContentDetails = new SimpleDateFormat("MMM d, yyyy").format(date);
            return adcContentDetails;
        }
        catch (Exception ex) {
            Logger.Warning("Failure while parsing ADC Content version", ex);
            return "Unknown";
        }
    }

    static {
        ADC_CONTENT_VERSION_PATH = Configuration.ASSESSMENTS_FOLDER_PATH + "/Version.json";
        ADC_CONTENT_VERSION_AND_DATE = ScubaVersion.getAdcContentVersionAndDate();
    }
}

