/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva;

import com.innovation.imperva.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Script {
    private String rawScript;
    private HashMap<String, String> resolvedScripts = new HashMap();
    private final String scriptInfo;
    private static final String FOREACH_DB_PATTERN = "!?!";

    public Script(String scriptInfo, String script) {
        this.scriptInfo = scriptInfo;
        this.setRawScript(script);
    }

    public void replaceVariables(ArrayList<Map.Entry<String, String>> variablesValue, List<String> Dbs) throws Exception {
        if (this.rawScript.isEmpty()) {
            return;
        }
        String partialResolvedScript = this.replaceGeneralVariables(variablesValue);
        if (Dbs.size() > 0 && partialResolvedScript.contains(FOREACH_DB_PATTERN)) {
            this.replaceDbVariables(partialResolvedScript, Dbs);
        } else {
            this.resolvedScripts.put("", partialResolvedScript);
            if (Dbs.size() == 0 && partialResolvedScript.contains(FOREACH_DB_PATTERN)) {
                throw new Exception("Pattern !?! could not be replaced");
            }
        }
    }

    private String replaceGeneralVariables(ArrayList<Map.Entry<String, String>> variablesValue) {
        String newScript = new String(this.rawScript);
        for (Map.Entry<String, String> variableValue : variablesValue) {
            try {
                String valueQuoteReplcament = Matcher.quoteReplacement(variableValue.getValue());
                newScript = this.canonoizeScript(newScript.replaceAll("!" + variableValue.getKey() + "!", valueQuoteReplcament));
            }
            catch (Exception e) {
                String Message = "Error while replacing general variable: " + variableValue.getKey();
                Logger.Error(Message, e);
            }
        }
        Pattern pattern = Pattern.compile("'![a-zA-Z_][a-zA-Z_0-9]*!'");
        Matcher matcher = pattern.matcher(newScript);
        if (matcher.find()) {
            Logger.Debug("Found: " + matcher.group(0));
        }
        return newScript;
    }

    private void replaceDbVariables(String partiallyReolveSQL, List<String> Dbs) {
        for (String db : Dbs) {
            try {
                String newScript = partiallyReolveSQL.replace(FOREACH_DB_PATTERN, db);
                this.resolvedScripts.put(db, newScript);
            }
            catch (Exception e) {
                String Message = "Error while replacing db variable: " + db;
                Logger.Error(Message, e);
            }
        }
    }

    public HashMap<String, String> getResolvedScripts() {
        return this.resolvedScripts;
    }

    public void setRawScript(String script) {
        this.rawScript = this.canonoizeScript(script);
    }

    private String canonoizeScript(String script) {
        if (script.length() > 0 && script.charAt(script.length() - 1) == ';') {
            return script.substring(0, script.length() - 1);
        }
        return script;
    }
}

