/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva;

import com.innovation.imperva.Assessment;
import com.innovation.imperva.AssessmentManager;
import com.innovation.imperva.AssessmentPolicy;
import com.innovation.imperva.IPolicyListener;
import com.innovation.imperva.Logger;
import com.innovation.imperva.SqlConnection;
import com.innovation.imperva.Utils;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class PolicyManager
implements IPolicyListener {
    private static final int NUM_OF_ELEMENTS = 5;
    private int totalPolicies = 0;
    private int totalAssessments = 0;
    int assessmentsRan = 0;
    private HashMap<String, AssessmentPolicy> policyMap = new HashMap();

    public void build(String policyJsonFilePath, SqlConnection.DB_TYPE userDbType, HashMap<String, Assessment> assessmentMap) {
        try {
            String policies = new String(Files.readAllBytes(Paths.get(policyJsonFilePath, new String[0])));
            JSONArray jarr = new JSONArray(policies);
            for (Object obj : jarr) {
                JSONObject record = (JSONObject)obj;
                String policyId = null;
                String assessId = null;
                try {
                    AssessmentPolicy policy;
                    policyId = record.getString("POLICY_ID");
                    String policyName = record.getString("DISPLAY_NAME");
                    assessId = record.getString("ASSESS_TEST_ID");
                    String dbType = record.getString("DB_TYPE");
                    String regulation = record.getString("REGULATION");
                    ++this.totalPolicies;
                    if (record.length() != 5) {
                        throw new Exception("PolicyManager. Found " + Integer.toString(record.length()) + " elements instead of " + 5 + ". Skipping record: " + record.toString());
                    }
                    if (SqlConnection.ConvertDBType(dbType) != userDbType) continue;
                    if (this.policyMap.keySet().contains(policyId)) {
                        policy = this.policyMap.get(policyId);
                    } else {
                        policy = new AssessmentPolicy(policyId, policyName, dbType, regulation);
                        policy.SetListener(this);
                        this.policyMap.put(policyId, policy);
                    }
                    Assessment assessObj = assessmentMap.get(assessId);
                    if (assessObj != null) {
                        policy.addAssessment(assessmentMap.get(assessId));
                        assessObj.addRegulations(policy.getRegulation());
                        continue;
                    }
                    Logger.Warning("Assessment id " + assessId + " does not appear in any policy");
                }
                catch (Exception e) {
                    Logger.Warning("Error building policy. id: " + policyId + ". Assessment id: " + assessId, e);
                }
            }
        }
        catch (FileNotFoundException e) {
            Logger.Warning(e);
        }
        catch (Exception e) {
            Logger.Warning(e);
        }
    }

    public void runPreTests() {
        for (AssessmentPolicy ap : this.policyMap.values()) {
            try {
                ap.runPreTest();
            }
            catch (Exception ex) {
                Logger.Error("Error running pretest for policy. Id: " + ap.getID(), ex);
            }
        }
        this.calculateTotalAssessments();
    }

    public void execute() {
        AssessmentManager.getInstance().updateProgressMessageWrapper("Executing " + Utils.toThousandsView(this.totalAssessments) + " tests ...");
        for (AssessmentPolicy ap : this.policyMap.values()) {
            try {
                ap.execute();
            }
            catch (Exception ex) {
                Logger.Error("Error executing policy. Id: " + ap.getID(), ex);
            }
        }
    }

    @Override
    public void OnNewAssessmentExecuted() {
        ++this.assessmentsRan;
        AssessmentManager.getInstance().updateProgressBarWrapper(this.assessmentsRan, this.totalAssessments);
    }

    private void calculateTotalAssessments() {
        HashSet<String> hashSet = new HashSet<String>();
        for (AssessmentPolicy ap : this.policyMap.values()) {
            try {
                if (!ap.isRelevant()) continue;
                HashMap<String, Assessment> assessmentMap = ap.getAssessmentMap();
                hashSet.addAll(assessmentMap.keySet());
            }
            catch (Exception ex) {
                Logger.Error("Error running pretest for policy. Id: " + ap.getID(), ex);
            }
        }
        this.totalAssessments = hashSet.size();
    }

    public void executeOne(String policyId) throws Exception {
        try {
            this.policyMap.get(policyId).execute();
        }
        catch (Exception ex) {
            Logger.Error("Error executing policy. Id: " + policyId, ex);
        }
    }

    public void runOnePreTest(String policyId) {
        try {
            this.policyMap.get(policyId).runPreTest();
        }
        catch (Exception ex) {
            Logger.Error("Error running pretest for policy. Id: " + policyId, ex);
        }
    }
}

