/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva;

import com.innovation.imperva.Logger;
import com.innovation.imperva.SqlConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class PermissionsCheck {
    private Statement statement;
    private SqlConnection.DB_TYPE dbType;

    public PermissionsCheck(Statement statement, SqlConnection.DB_TYPE dbType) {
        this.statement = statement;
        this.dbType = dbType;
    }

    public Boolean check() {
        switch (this.dbType) {
            case ORACLE: {
                return this.runOraclePermissionsCheck();
            }
            case MSSQL: {
                return this.checkMsSql();
            }
            case DB2: {
                return this.checkDB2Permissions();
            }
            case SYBASE: {
                return this.checkSybase();
            }
        }
        return true;
    }

    private Boolean isOracleVersionOver12() {
        String SQL = "select 1 from dual where \n(select substr(version, 1, instr(version,'.',1,1)-1)|| substr(version, instr(version,'.',1,1)+1, instr(version,'.',1,2)- instr(version,'.',1,1)-1)|| substr(version, instr(version,'.',1,2)+1, instr(version,'.',1,3)- instr(version,'.',1,2)-1)|| substr(version, instr(version,'.',1,3)+1, instr(version||'.','.',1,4)- instr(version,'.',1,3)-1) from PRODUCT_COMPONENT_VERSION where upper(product) like 'ORACLE%')< 12000";
        try {
            ResultSet rs = this.statement.executeQuery(SQL);
            if (rs.next()) {
                return false;
            }
            return true;
        }
        catch (SQLException ex) {
            Logger.Error("Error while checking Oracle version: ", ex);
            return false;
        }
    }

    private Boolean runPremissionsCheck(List<String> SQL) {
        String s = "";
        try {
            Iterator<String> iterator = SQL.iterator();
            while (iterator.hasNext()) {
                String sql;
                s = sql = iterator.next();
                this.statement.execute(sql);
            }
            return true;
        }
        catch (SQLException ex) {
            Logger.Error("Error while checking permissions: " + s, ex);
            return false;
        }
    }

    public Boolean runOraclePermissionsCheck() {
        if (!this.checkOraclePermissions().booleanValue()) {
            return false;
        }
        if (this.isOracleVersionOver12().booleanValue()) {
            return this.checkOraclePermissionsV12();
        }
        return true;
    }

    private Boolean checkOraclePermissions() {
        List<String> SQL = Arrays.asList("SELECT * FROM sys.registry$history WHERE ROWNUM = 1", "SELECT * FROM sys.dba_db_links WHERE ROWNUM = 1", "SELECT * FROM sys.dba_objects WHERE ROWNUM = 1", "SELECT * FROM sys.dba_priv_audit_opts WHERE ROWNUM = 1", "SELECT * FROM sys.dba_profiles WHERE ROWNUM = 1", "SELECT * FROM sys.dba_role_privs WHERE ROWNUM = 1", "SELECT * FROM sys.dba_roles WHERE ROWNUM = 1", "SELECT * FROM sys.dba_scheduler_jobs WHERE ROWNUM = 1", "SELECT * FROM sys.dba_stmt_audit_opts WHERE ROWNUM = 1", "SELECT * FROM sys.dba_sys_privs WHERE ROWNUM = 1", "SELECT * FROM sys.dba_tab_privs WHERE ROWNUM = 1", "SELECT * FROM sys.dba_users WHERE ROWNUM = 1", "SELECT * FROM sys.link$ WHERE ROWNUM = 1", "SELECT * FROM sys.profile$ WHERE ROWNUM = 1", "SELECT * FROM sys.profname$ WHERE ROWNUM = 1", "SELECT * FROM sys.resource_map WHERE ROWNUM = 1", "SELECT * FROM sys.role_tab_privs WHERE ROWNUM = 1", "SELECT * FROM sys.sysauth$ WHERE ROWNUM = 1", "SELECT * FROM sys.user$ WHERE ROWNUM = 1", "SELECT * FROM sys.v_$controlfile WHERE ROWNUM = 1", "SELECT * FROM sys.v_$database WHERE ROWNUM = 1", "SELECT * FROM sys.v_$datafile WHERE ROWNUM = 1", "SELECT * FROM sys.v_$logfile WHERE ROWNUM = 1", "SELECT * FROM sys.v_$parameter WHERE ROWNUM = 1", "SELECT * FROM sys.v_$pwfile_users WHERE ROWNUM = 1", "SELECT * FROM sys.dba_data_files WHERE ROWNUM = 1", "SELECT * FROM sys.dba_external_tables WHERE ROWNUM = 1", "SELECT * FROM sys.dba_jobs WHERE ROWNUM = 1", "SELECT * FROM sys.dba_obj_audit_opts WHERE ROWNUM = 1", "SELECT * FROM sys.dba_source WHERE ROWNUM = 1", "SELECT * FROM sys.dba_tables WHERE ROWNUM = 1", "SELECT * FROM sys.dba_ts_quotas WHERE ROWNUM = 1", "SELECT * FROM sys.v_$log WHERE ROWNUM = 1", "SELECT * FROM sys.dba_registry WHERE ROWNUM = 1", "SELECT * FROM sys.v_$fixed_table WHERE ROWNUM = 1", "SELECT * FROM sys.proxy_users WHERE ROWNUM = 1", "SELECT * FROM sys.dba_policies WHERE ROWNUM = 1", "SELECT * FROM sys.dba_encrypted_columns WHERE ROWNUM = 1", "SELECT * FROM sys.dba_indexes WHERE ROWNUM = 1", "SELECT * FROM sys.dba_ind_partitions WHERE ROWNUM = 1", "SELECT * FROM sys.dba_tablespaces WHERE ROWNUM = 1", "SELECT * FROM sys.dba_tab_partitions WHERE ROWNUM = 1", "SELECT * FROM sys.dba_users_with_defpwd WHERE ROWNUM = 1 ", "SELECT * FROM sys.dba_proxies WHERE ROWNUM = 1", "SELECT dbms_crypto.randomnumber FROM DUAL", "SELECT UTL_RAW.CAST_FROM_NUMBER (100) FROM dual", "SELECT * FROM sys.dba_constraints WHERE ROWNUM = 1", "SELECT * FROM sys.DBA_FREE_SPACE WHERE ROWNUM = 1", "SELECT * FROM sys.DBA_SEGMENTS WHERE ROWNUM = 1", "SELECT * FROM sys.dba_tab_columns WHERE ROWNUM = 1", "SELECT * FROM sys.audit$ WHERE ROWNUM = 1", "SELECT * FROM SYS.default_pwd$ WHERE ROWNUM = 1", "SELECT * FROM sys.v_$encrypted_tablespaces WHERE ROWNUM = 1", "SELECT * FROM sys.V_$OPTION WHERE ROWNUM = 1", "SELECT * FROM sys.v_$tablespace WHERE ROWNUM = 1", "SELECT * FROM sys.dba_repcatlog WHERE ROWNUM = 1");
        return this.runPremissionsCheck(SQL);
    }

    private Boolean checkOraclePermissionsV12() {
        List<String> SQL = Arrays.asList("SELECT * FROM sys.v_$version WHERE ROWNUM = 1", "SELECT * FROM sys.audit_unified_policies WHERE ROWNUM = 1 ", "SELECT * FROM sys.audit_unified_enabled_policies WHERE ROWNUM = 1", "SELECT * FROM sys.dba_col_privs WHERE ROWNUM = 1", "SELECT * FROM sys.dba_libraries WHERE ROWNUM = 1", "SELECT * FROM sys.obj$ WHERE ROWNUM = 1", "SELECT * FROM sys.objauth$ WHERE ROWNUM = 1", "SELECT * FROM sys.table_privilege_map WHERE ROWNUM = 1", "SELECT * FROM sys.registry$sqlpatch WHERE ROWNUM = 1", "SELECT dbms_qopatch.get_opatch_install_info from dual");
        return this.runPremissionsCheck(SQL);
    }

    private Boolean checkMsSql() {
        if (!this.checkMsSqlAnyPermissions().booleanValue()) {
            return false;
        }
        if (!this.checkMsSqlMsDBPermissions().booleanValue()) {
            return false;
        }
        return this.checkMsSqlMasterPermissions();
    }

    private Boolean checkMsSqlAnyPermissions() {
        List<String> SQL = Arrays.asList("select TOP 1 * FROM dbo.sysobjects", "SELECT TOP 1 * FROM dbo.sysprotects", "SELECT TOP 1 * FROM dbo.sysusers", "SELECT TOP 1 * FROM sys.asymmetric_keys", "SELECT TOP 1 * FROM sys.database_files", "SELECT TOP 1 * FROM sys.database_permissions", "SELECT TOP 1 * FROM sys.database_principals", "SELECT TOP 1 * FROM sys.database_role_members", "SELECT TOP 1 * FROM sys.key_encryptions", "SELECT TOP 1 * FROM sys.objects", "SELECT TOP 1 * FROM sys.procedures", "SELECT TOP 1 * FROM sys.schemas", "SELECT TOP 1 * FROM sys.sql_modules", "SELECT TOP 1 * FROM sys.symmetric_keys", "SELECT TOP 1 * FROM sys.system_objects");
        return this.runPremissionsCheck(SQL);
    }

    private Boolean checkMsSqlMsDBPermissions() {
        List<String> SQL = Arrays.asList("SELECT TOP 1 * FROM msdb.dbo.sysjobs", "SELECT TOP 1 * FROM msdb.dbo.sysproxies", "SELECT TOP 1 * FROM msdb.dbo.sysproxysubsystem", "SELECT TOP 1 * FROM msdb.dbo.sysjobhistory", "SELECT TOP 1 * FROM msdb.dbo.syssubsystems", "exec msdb.dbo.sp_enum_login_for_proxy", "exec msdb.dbo.sp_enum_proxy_for_subsystem");
        return this.runPremissionsCheck(SQL);
    }

    private Boolean checkMsSqlMasterPermissions() {
        List<String> SQL = Arrays.asList("SELECT TOP 1 * FROM INFORMATION_SCHEMA.COLUMNS", "SELECT TOP 1 * FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES", "SELECT TOP 1 * FROM sys.configurations", "SELECT TOP 1 * FROM sys.credentials", "SELECT TOP 1 * FROM sys.databases", "SELECT TOP 1 * FROM sys.fn_trace_geteventinfo(1)", "SELECT TOP 1 * FROM sys.fn_trace_getinfo(1)", "SELECT TOP 1 * FROM sys.linked_logins", "SELECT TOP 1 * FROM sys.master_files", "SELECT TOP 1 * FROM sys.master_key_passwords", "SELECT TOP 1 * FROM sys.server_permissions", "SELECT TOP 1 * FROM sys.server_principals", "SELECT TOP 1 * FROM sys.server_role_members", "SELECT TOP 1 * FROM sys.servers", "SELECT TOP 1 * FROM sys.service_broker_endpoints", "SELECT TOP 1 * FROM sys.soap_endpoints", "SELECT TOP 1 * FROM sys.sql_logins", "SELECT TOP 1 * FROM dbo.spt_values", "SELECT TOP 1 * FROM dbo.sysconfigures", "SELECT TOP 1 * FROM dbo.syscurconfigs", "SELECT TOP 1 * FROM dbo.sysdatabases", "SELECT TOP 1 * FROM dbo.syslogins", "SELECT TOP 1 * FROM INFORMATION_SCHEMA.SCHEMATA", "exec sys.fn_isrolemember 0, null, 1", "exec sys.sp_dbfixedrolepermission", "exec sp_executesql \"select TOP 1 * from sys.tables\"", "exec sys.sp_get_distributor", "exec sys.sp_helpdbfixedrole", "exec sys.sp_helpreplicationdboption", "exec sys.sp_helprolemember", "exec sys.sp_helprotect", "exec sys.sp_helpsrvrolemember", "exec sys.sp_helpuser", "exec sys.sp_server_info", "exec sys.xp_loginconfig");
        return this.runPremissionsCheck(SQL);
    }

    private Boolean checkDB2Permissions() {
        List<String> SQL = Arrays.asList("select service_level, FIXPACK_NUM from table (sysproc.env_get_inst_info()) FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSIBM.SYSTABAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSIBM.SYSCOLAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSIBM.SYSDBAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSIBMADM.DBMCFG FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSIBMADM.DBCFG FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSIBM.SYSDBAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.PACKAGEAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.TBSPACEAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.DBAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.SEQUENCEAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.INDEXAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.TABLES FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSIBM.SYSSCHEMAAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSIBM.SYSTABAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.LIBRARYAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.TABAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSIBM.SYSROUTINEAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.SCHEMATA FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSIBM.ROUTINES FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.INDEXES FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.SCHEMAAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.PACKAGES FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.VIEWS FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.TRIGGERS FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.PASSTHRUAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.ROUTINEAUTH FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.TABLESPACES FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.SEQUENCES FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.ROUTINES FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.INDEXES FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.PACKAGES FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.SCHEMATA FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.TRIGGERS FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.TABLES FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.VIEWS FETCH FIRST 1 ROWS ONLY", "SELECT * FROM SYSCAT.ROUTINES FETCH FIRST 1 ROWS ONLY");
        return this.runPremissionsCheck(SQL);
    }

    private Boolean checkSybaseAnyPermissions() {
        List<String> SQL = Arrays.asList("SELECT TOP 1 * FROM dbo.sysusers  ", "SELECT TOP 1 * FROM dbo.sysobjects", "SELECT TOP 1 * FROM dbo.sysprotects", "SELECT TOP 1 * FROM dbo.syscomments", "SELECT TOP 1 * FROM dbo.sysalternates");
        return this.runPremissionsCheck(SQL);
    }

    private Boolean checkSybase() {
        if (!this.checkSybaseMasterPermissions().booleanValue()) {
            return false;
        }
        return true;
    }

    private Boolean checkSybaseMasterPermissions() {
        List<String> SQL = Arrays.asList("SELECT TOP 1 * from master.dbo.spt_limit_types ", "SELECT TOP 1 * from master.dbo.spt_values ", "SELECT TOP 1 * from master.dbo.sysattributes ", "SELECT TOP 1 * from master.dbo.sysconfigures ", "SELECT TOP 1 * from master.dbo.syscurconfigs ", "SELECT TOP 1 * from master.dbo.sysdatabases ", "SELECT TOP 1 * from master.dbo.sysloginroles ", "SELECT TOP 1 * from master.dbo.syslogins ", "SELECT TOP 1 * from master.dbo.sysremotelogins ", "SELECT TOP 1 * from master.dbo.sysresourcelimits ", "SELECT TOP 1 * from master.dbo.sysroles ", "SELECT TOP 1 * from master.dbo.sysroles ", "SELECT TOP 1 * from master.dbo.sysservers ", "SELECT TOP 1 * from master.dbo.syssrvroles ");
        return this.runPremissionsCheck(SQL);
    }

    private Boolean checkSybaseSybsystemprocsPermissions() {
        List<String> SQL = Arrays.asList("exec sybsystemprocs.dbo.sp_loginconfig");
        return this.runPremissionsCheck(SQL);
    }

    private Boolean checkSybaseSybsecurityPermissions() {
        List<String> SQL = Arrays.asList("SELECT TOP 1 * FROM on sybsecurity.dbo.systhresholds", "SELECT TOP 1 * FROM on sybsecurity.dbo.syssegments");
        return this.runPremissionsCheck(SQL);
    }
}

