/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva;

import com.innovation.imperva.Configuration;
import com.innovation.imperva.Logger;
import com.innovation.imperva.ScubaVersion;
import com.innovation.imperva.Utils;
import com.innovation.imperva.launcher.EulaController;
import java.net.URL;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class Main
extends Application {
    public static final boolean IS_DEBUG = true;
    public static boolean USE_DEC = false;

    public void start(Stage primaryStage) throws Exception {
        Parent root = (Parent)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getClassLoader().getResource("main.fxml"));
        Scene scene = new Scene(root);
        primaryStage.setScene(scene);
        primaryStage.setTitle("Scuba");
        primaryStage.getIcons().add((Object)Utils.getImpervaIcon());
        primaryStage.setResizable(false);
        primaryStage.show();
        if (!EulaController.isEULAAccepted()) {
            primaryStage.close();
        }
    }

    private static void initLogger() {
        Logger.setLoglevel(Logger.LOG_LEVEL.OFF);
        if (Configuration.IS_LOGGER_ENABLED) {
            Logger.setLoglevel(Logger.LOG_LEVEL.NOTIFY);
            if (Configuration.isDebug()) {
                Logger.setLoglevel(Logger.LOG_LEVEL.DEBUG);
            }
        }
        Logger.OpenFile();
    }

    private static void loadConfigurationAndStart(String[] args) {
        USE_DEC = args.length == 1 && args[0].equals("-dec");
        Main.launch((String[])args);
    }

    private static void cleanupLogger() {
        Logger.CloseFile();
    }

    public static void main(String[] args) throws Exception {
        Main.initLogger();
        Logger.Notify("Scuba " + ScubaVersion.VERSION + " ; ADC Content: " + ScubaVersion.ADC_CONTENT_VERSION_AND_DATE);
        Main.loadConfigurationAndStart(args);
        Logger.Notify("See you next time ;)");
        Main.cleanupLogger();
    }
}

