/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva;

import com.innovation.imperva.Utils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class Logger {
    private static final boolean LOG_TO_CONSOLE = false;
    private static final boolean LOG_TO_FILE = true;
    public static final String OUTPUT_FILE_PATH = Utils.getCurrentFolder() + "/logs/AssessmentsOutput.html";
    private static final String HTML_COLOR_PREFIX = "<div id=\"";
    private static final String HTML_NEW_LINE = "</div>";
    private static final String HTML_NOTIFY = "<div id=\"NOTIFICATION\"><b>[NOTIFICATION] </b>";
    private static final String HTML_DEBUG = "<div id=\"DEBUG\"><b>[DEBUG] </b>";
    private static final String HTML_WARNING = "<div id=\"WARNING\"><b>[WARNING] </b>";
    private static final String HTML_ERROR = "<div id=\"ERROR\"><b>[ERROR] </b>";
    private static final String LOG_NEW_LINE = "\r\n";
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_NOTIFY = "\u001b[32m";
    private static final String ANSI_DEBUG = "\u001b[37m";
    private static final String ANSI_WARNING = "\u001b[33m";
    private static final String ANSI_ERROR = "\u001b[31m";
    private static LOG_LEVEL log_level = LOG_LEVEL.NOTIFY;
    private static Path outputFile = null;

    public static void setLoglevel(LOG_LEVEL level) {
        log_level = level;
    }

    private static String getColor(LOG_LEVEL level, boolean isHtml) {
        switch (level) {
            case NOTIFY: {
                return isHtml ? HTML_NOTIFY : ANSI_NOTIFY;
            }
            case DEBUG: {
                return isHtml ? HTML_DEBUG : ANSI_DEBUG;
            }
            case WARNING: {
                return isHtml ? HTML_WARNING : ANSI_WARNING;
            }
        }
        return isHtml ? HTML_ERROR : ANSI_ERROR;
    }

    private static void Log(String msg, LOG_LEVEL level) {
        if (log_level.compareTo(level) > 0) {
            return;
        }
        if (outputFile != null) {
            try {
                Files.write(outputFile, (Logger.getColor(level, true) + Utils.getTimeNowInString() + " " + msg + HTML_NEW_LINE + LOG_NEW_LINE).getBytes(), StandardOpenOption.APPEND);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void OpenFile() {
        outputFile = Paths.get(OUTPUT_FILE_PATH, new String[0]);
        try {
            File file = new File(OUTPUT_FILE_PATH);
            file.getParentFile().mkdirs();
            Files.write(outputFile, "<link rel=\"stylesheet\" type=\"text/css\" href=\"../css/log_style.css\"><html>".getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void CloseFile() {
        try {
            Files.write(outputFile, "</html>".getBytes(), StandardOpenOption.APPEND);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void Notify(String msg) {
        Logger.Log(msg, LOG_LEVEL.NOTIFY);
    }

    public static void Debug(String msg) {
        Logger.Log(msg, LOG_LEVEL.DEBUG);
    }

    public static void Warning(String msg) {
        Logger.Log(msg, LOG_LEVEL.WARNING);
    }

    public static void Warning(Exception e) {
        Logger.Warning(Logger.ExceptionToString(e));
    }

    public static void Warning(String message, Exception e) {
        Logger.Warning(message + " ; Exception: " + Logger.ExceptionToString(e));
    }

    public static void Error(String msg) {
        Logger.Log(msg, LOG_LEVEL.ERROR);
    }

    public static void Error(Exception e) {
        Logger.Warning(Logger.ExceptionToString(e));
    }

    public static void Error(String message, Exception e) {
        Logger.Error(message + (e == null ? "" : " ; Exception: " + Logger.ExceptionToString(e)));
    }

    private static String ExceptionToString(Exception e) {
        StringWriter errors = new StringWriter();
        e.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    public static enum LOG_LEVEL {
        DEBUG,
        NOTIFY,
        WARNING,
        ERROR,
        OFF;

    }
}

