/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva;

import com.innovation.imperva.Logger;
import com.innovation.imperva.ScubaVersion;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javafx.concurrent.Task;

public class AsyncUpdateCheck
extends Task {
    private static final String SCUBA_LATEST_VERSION_URL = "https://www.imperva.com/docs/gated/scuba_version.txt";

    protected Object call() throws Exception {
        this.updateCheckSyncNoGoogleAnalytics();
        return null;
    }

    protected void succeeded() {
        super.getOnSucceeded();
        this.updateValue(ScubaVersion.isNewVersionAvailable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCheckSyncNoGoogleAnalytics() {
        BufferedReader in = null;
        try {
            URL url = new URL(SCUBA_LATEST_VERSION_URL);
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            String newVersionFound = in.readLine();
            if (ScubaVersion.isNewVersion(newVersionFound)) {
                ScubaVersion.setNewVersion(newVersionFound);
                this.updateValue(true);
            }
        }
        catch (Exception ex) {
            Logger.Error("Version update check failed (sync)", ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {
                Logger.Error("Unable to close stream", ex);
            }
        }
    }
}

