/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva;

import com.innovation.imperva.Assessment;
import com.innovation.imperva.AssessmentVariable;
import com.innovation.imperva.Logger;
import com.innovation.imperva.SqlConnection;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class AssessmentsVariables {
    private static final int NUM_OF_ELEMENTS = 6;
    ArrayList<AssessmentVariable> AllVariablesList = new ArrayList();

    public AssessmentsVariables(String jsonFilePath, HashMap<String, Assessment> AssessmentMap, SqlConnection.DB_TYPE dbType) {
        this.parseJsonAndBuildVariables(jsonFilePath, AssessmentMap, dbType);
    }

    public AssessmentVariable getVariable(String variableName) {
        for (AssessmentVariable variable : this.AllVariablesList) {
            if (!variable.getVariable().equals(variableName)) continue;
            return variable;
        }
        return null;
    }

    private void parseJsonAndBuildVariables(String jsonFilePath, HashMap<String, Assessment> AssessmentMap, SqlConnection.DB_TYPE dbType) {
        try {
            String variables = new String(Files.readAllBytes(Paths.get(jsonFilePath, new String[0])));
            JSONArray jarr = new JSONArray(variables);
            for (Object obj : jarr) {
                JSONObject record = (JSONObject)obj;
                if (record.length() != 6) {
                    Logger.Error("Found " + Integer.toString(record.length()) + " elements instead of " + 6 + ". Skipping record: " + record.toString());
                    continue;
                }
                String paramName = record.getString("NAME");
                String paramScript = record.getString("SCRIPT");
                String paramDefaultValue = record.getString("DEFAULT_VALUE");
                String testId = record.getString("ASSESS_TEST_ID");
                String VariableDbType = record.getString("DB_TYPE");
                if (paramName.isEmpty() || paramScript.isEmpty() && paramDefaultValue.isEmpty()) {
                    Logger.Error("Unable to read script for parameter. Param: " + paramName + " ; Script: " + paramScript + " ; Default value: " + paramDefaultValue + " ; TestID: " + testId);
                    continue;
                }
                if (SqlConnection.ConvertDBType(VariableDbType) != dbType || !AssessmentMap.containsKey(testId)) continue;
                try {
                    this.handleVariableJsonRecord(paramName, paramScript, paramDefaultValue, AssessmentMap.get(testId));
                }
                catch (Exception e) {
                    Logger.Error("Error in handling parameter: " + paramName + ". Test ID: " + testId, e);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleVariableJsonRecord(String paramName, String paramScript, String paramDefaultValue, Assessment assessment) throws Exception {
        AssessmentVariable assessmentVariable = this.getVariable(paramName);
        if (assessmentVariable == null) {
            assessmentVariable = new AssessmentVariable(paramName, paramScript, paramDefaultValue);
            this.AllVariablesList.add(assessmentVariable);
        }
        assessment.addVariable(assessmentVariable);
    }
}

