/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva;

import com.innovation.imperva.Logger;
import com.innovation.imperva.SqlHelper;

public class AssessmentVariable {
    private String variable;
    private String script;
    private String defaultValue;
    private String value = null;
    private Status status = Status.NOT_RESOLVED;

    public AssessmentVariable(String variable, String script, String defaultValue) {
        this.variable = variable;
        this.script = script;
        this.defaultValue = defaultValue;
    }

    public String getVariable() {
        return this.variable;
    }

    public String getScript() {
        return this.script;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "Variable: " + this.variable + " ; Script: " + this.script + " ; Default value: " + this.defaultValue + " ; Value: " + this.value;
    }

    public String queryVariableValueFromDB() throws Exception {
        return SqlHelper.execute(this.script);
    }

    public boolean shouldRerunVariable() {
        return this.value != null && this.value.toLowerCase().contains("select ");
    }

    public void resolve() throws Exception {
        try {
            if (this.status == Status.RESOLVED || this.status == Status.ERROR) {
                return;
            }
            if (this.script != null && !this.script.isEmpty()) {
                this.value = this.queryVariableValueFromDB();
                Logger.Notify("Set variable '" + this.variable + "' value to " + this.value);
                if (this.shouldRerunVariable()) {
                    Logger.Notify("Re-running " + this.variable);
                    this.script = this.value;
                    this.value = "'" + this.queryVariableValueFromDB() + "'";
                    Logger.Notify("Set variable '" + this.variable + "' value to " + this.value + " (re-run)");
                }
            } else {
                this.value = this.defaultValue;
                Logger.Notify("Set variable '" + this.variable + "' value to " + this.value + " (using default value)");
            }
            this.status = Status.RESOLVED;
        }
        catch (Exception ex) {
            this.value = this.defaultValue;
            this.status = Status.ERROR;
            throw new Exception("Error resolving variable, setting variable '" + this.variable + "' value to " + this.value + " (using default value)", ex);
        }
    }

    public static enum Status {
        NOT_RESOLVED,
        RESOLVED,
        ERROR;

    }
}

