/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva;

import com.innovation.imperva.Assessment;
import com.innovation.imperva.IPolicyListener;
import com.innovation.imperva.Logger;
import java.util.HashMap;

public class AssessmentPolicy {
    private String Id;
    private String name;
    private String dbTypeStr;
    private String regulation = "";
    private boolean isRelevant;
    private HashMap<String, Assessment> assessmentMap = new HashMap();
    private Assessment preTest;
    private IPolicyListener iListener;
    private Status status;

    public AssessmentPolicy(String Id, String name, String dbType, String regulation) {
        this.Id = Id;
        this.name = name;
        this.dbTypeStr = dbType;
        this.regulation = regulation;
        this.status = Status.NOT_SET;
        this.isRelevant = true;
        Logger.Notify("Policy created. Id: " + Id + ". Name: " + name);
    }

    public Status getStatus() {
        return this.status;
    }

    public String getID() {
        return this.Id;
    }

    public void addAssessment(Assessment assessment) throws Exception {
        if (!assessment.isPreTest()) {
            if (!this.assessmentMap.containsKey(assessment.getId())) {
                this.assessmentMap.put(assessment.getId(), assessment);
            }
        } else if (this.preTest == null) {
            this.preTest = assessment;
            Logger.Debug("Adding PreTest:" + assessment.getId() + " to policy Id :" + this.Id);
        } else {
            Logger.Error("PreTest already exist in policy Id :" + this.Id + ". Current Pre Test Id: " + this.preTest.getId() + ". New Pre Test ID: " + assessment.getId());
        }
    }

    public void runPreTest() throws Exception {
        if (this.preTest != null) {
            Logger.Notify("Running PreTest for policy. Id: " + this.Id + ". Name: " + this.name);
            this.preTest.Execute();
            if (this.preTest.getStatus() != Assessment.Status.PASSED) {
                this.isRelevant = false;
            }
            Logger.Notify("PreTest for policy Id: " + this.Id + ". Name: " + this.name + ". Status: " + this.preTest.getStatus().toString());
        } else {
            Logger.Notify("No PreTest for policy. Id: " + this.Id + ". Name: " + this.name);
        }
        this.status = Status.PRE_TESTED;
    }

    public void execute() throws Exception {
        Logger.Notify("Executing policy. Id: " + this.Id + ". Name: " + this.name);
        if (this.status != Status.PRE_TESTED) {
            throw new Exception("Pre test not performed !");
        }
        if (this.isRelevant) {
            this.ExecuteTestList();
        }
    }

    private void ExecuteTestList() {
        Logger.Debug("Executing test list for policy. Policy Id: " + this.Id);
        for (Assessment assessment : this.assessmentMap.values()) {
            try {
                if (this.iListener != null && assessment.getStatus() == Assessment.Status.NOT_SET) {
                    this.iListener.OnNewAssessmentExecuted();
                }
                assessment.Execute();
            }
            catch (Exception e) {
                Logger.Error("Error executing assessment: " + assessment.getId() + ", in policy " + this.Id, e);
            }
        }
    }

    public void SetListener(IPolicyListener iListener) {
        this.iListener = iListener;
    }

    public HashMap<String, Assessment> getAssessmentMap() {
        return this.assessmentMap;
    }

    public boolean isRelevant() {
        return this.isRelevant;
    }

    public Assessment getPreTest() {
        return this.preTest;
    }

    public String getRegulation() {
        return this.regulation;
    }

    public void setRegulation(String regulation) {
        this.regulation = regulation;
    }

    public static enum Status {
        NOT_SET,
        PRE_TESTED,
        EXECUTED;

    }
}

