/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva;

import com.innovation.imperva.Assessment;
import com.innovation.imperva.AssessmentsVariables;
import com.innovation.imperva.Configuration;
import com.innovation.imperva.DESCipher;
import com.innovation.imperva.Logger;
import com.innovation.imperva.Main;
import com.innovation.imperva.MssqlAssessment;
import com.innovation.imperva.PolicyManager;
import com.innovation.imperva.Script;
import com.innovation.imperva.ScubaVersion;
import com.innovation.imperva.SqlConnection;
import com.innovation.imperva.Utils;
import java.awt.Desktop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.DataFormatException;
import javafx.concurrent.Task;
import org.json.JSONArray;
import org.json.JSONObject;

public class AssessmentManager
extends Task {
    private HashMap<String, Assessment> assessmentMap = new HashMap();
    private AssessmentsVariables assessmentsVariables = null;
    private static final int ASSESSMENTS_LIMIT_TO_RUN = 3000;
    public static final int MAX_DATA_ROWS_TO_PROCESS = 50;
    public static final int MAX_DATA_ROWS_TO_COUNT = 500;
    private static final String VARIABLES_JSON_PATH = Configuration.ASSESSMENTS_FOLDER_PATH + "/Variables.json";
    private static final String ASSESSMENTS_JSON_PATH = Configuration.ASSESSMENTS_FOLDER_PATH + "/Assessments.json";
    private static final String POLICIES_JSON_PATH = Configuration.ASSESSMENTS_FOLDER_PATH + "/Policies.json";
    private static final String ASSESSMENTS_OUTPUT_PATH = Utils.getCurrentFolder() + "/Scuba App/production/AssessmentResults.js";
    public static final String ASSESSMENTS_HTML_PATH = Utils.getCurrentFolder() + "/Scuba App/production/dashboard.html";
    private static final String DEBUG_RESULTS_PATH = Utils.getCurrentFolder() + "/logs/Debug_Results.csv";
    private static final int NUM_OF_ELEMENTS = 12;
    public static final String SCRIPT_TYPE_BOOLEAN_KEYWORD = "Boolean";
    public static final String SCRIPT_TYPE_DATA_KEYWORD = "Data";
    private int passedAssessments = 0;
    private int failedAssessments = 0;
    private int errorAssessments = 0;
    private int infoAssessments = 0;
    private int unhandledAssessments = 0;
    private int totalAssessments = 0;
    private int totalRelevantAssessments = 0;
    private int totalAssessmentRows = 0;
    private int totalReconnectionAttempts = 0;
    private String remoteOsVersion = "";
    private String dbVersion = "";
    private SqlConnection sqlConnection;
    private Date startTime = null;
    private Date endTime = null;
    private PolicyManager policyManager = null;
    private static AssessmentManager instance = null;

    public Statement getSqlStatement() {
        return this.sqlConnection.getStatement();
    }

    public Boolean isDBConnected() {
        return this.sqlConnection.isDBConnected();
    }

    public boolean reconnectDB() {
        Logger.Warning("Total reconnection attempts: " + ++this.totalReconnectionAttempts);
        return this.sqlConnection.reConnectDB();
    }

    public static AssessmentManager getInstance() {
        return instance;
    }

    public static AssessmentManager createInstance(SqlConnection sqlConnection) {
        if (instance != null) {
            Logger.Warning("Attempt to re-create Singleton object");
            return instance;
        }
        Logger.Notify(sqlConnection.toString());
        instance = new AssessmentManager(sqlConnection);
        return instance;
    }

    public static AssessmentManager createOrUpdateInstance(SqlConnection sqlConnection) {
        if (instance == null) {
            return AssessmentManager.createInstance(sqlConnection);
        }
        Logger.Notify("Replacing SQL Connection. Old = " + AssessmentManager.instance.sqlConnection + " ; New = " + sqlConnection);
        instance = null;
        return AssessmentManager.createInstance(sqlConnection);
    }

    private AssessmentManager(SqlConnection sqlConnection) {
        this.sqlConnection = sqlConnection;
        this.policyManager = new PolicyManager();
    }

    private void setStartTime() {
        this.startTime = new Date();
    }

    private void setEndTime() {
        this.endTime = new Date();
    }

    public Void call() {
        this.Run();
        return null;
    }

    private void reportErrorAndStop(String message) {
        try {
            this.updateMessage(message);
            this.updateProgress(1L, 2L);
            Thread.sleep(100L);
            this.updateProgress(1L, 4L);
            Thread.sleep(100L);
        }
        catch (Exception ex) {
            Logger.Warning("Failed to report failure", ex);
        }
    }

    private void Run() {
        try {
            this.setStartTime();
            this.updateMessage("Testing connection ...");
            if (!this.sqlConnection.ConnectDB()) {
                String failReason = this.sqlConnection.getFailReason();
                this.reportErrorAndStop(failReason);
                return;
            }
            this.collectMetadata();
            this.updateMessage("Initializing ...");
            this.buildAssessments(ASSESSMENTS_JSON_PATH, this.sqlConnection.getDbType());
            this.policyManager.build(POLICIES_JSON_PATH, this.sqlConnection.getDbType(), this.assessmentMap);
            this.assessmentsVariables = new AssessmentsVariables(VARIABLES_JSON_PATH, this.assessmentMap, this.sqlConnection.getDbType());
            this.policyManager.runPreTests();
            this.policyManager.execute();
            this.updateProgressBarWrapper(1L, 1L);
            this.updateMessage("Collecting results ...");
            this.setEndTime();
            this.setStatistics();
            this.writeResultsToDisk();
            this.debugWriteResults();
        }
        catch (Exception e) {
            Logger.Error(e);
            this.reportErrorAndStop("Unknown error occurred");
            return;
        }
        int skippedAssessments = this.totalAssessments - this.passedAssessments - this.failedAssessments - this.errorAssessments - this.infoAssessments - this.unhandledAssessments;
        Logger.Notify("Assessment rows in file: " + this.totalAssessmentRows);
        Logger.Notify("\nAssessments stats: \nTotal: " + this.totalAssessments + "\nSkipped: " + skippedAssessments + "\nRelevant (for DB): " + this.totalRelevantAssessments);
        Logger.Notify("\nPassed: " + this.passedAssessments + "\nFailed: " + this.failedAssessments + "\nInfo: " + this.infoAssessments + "\nError: " + this.errorAssessments + "\nUnhandled: " + this.unhandledAssessments);
        if (this.unhandledAssessments > 0) {
            Logger.Warning("Unhandled assessments exist: " + this.unhandledAssessments);
        }
        this.updateProgress(0L, 1L);
    }

    private void collectMetadata() {
        Logger.Notify("Collecting metadata ...");
        this.dbVersion = this.sqlConnection.getDbVersion();
        this.remoteOsVersion = this.sqlConnection.getRemoteOsVersion();
        Logger.Notify("Database version: " + this.dbVersion);
        Logger.Notify("Remote OS version: " + this.remoteOsVersion);
    }

    public void buildAssessments(String assessmentsScriptsFilePath, SqlConnection.DB_TYPE dbType) {
        try {
            String decContent;
            if (Main.USE_DEC) {
                decContent = new String(Files.readAllBytes(Paths.get(assessmentsScriptsFilePath, new String[0])));
            } else {
                String encContent = new String(Files.readAllBytes(Paths.get(assessmentsScriptsFilePath + ".enc", new String[0])));
                decContent = DESCipher.decrypt((String)encContent);
            }
            JSONArray jarr = new JSONArray(decContent);
            for (Object obj : jarr) {
                try {
                    ++this.totalAssessmentRows;
                    JSONObject record = (JSONObject)obj;
                    if (record.get("SCRIPT_INFO").equals(SCRIPT_TYPE_BOOLEAN_KEYWORD)) {
                        ++this.totalAssessments;
                    }
                    if (record.length() != 12) {
                        throw new DataFormatException("Found " + Integer.toString(record.length()) + " elements instead of " + 12 + ". Skipping record: " + record.toString());
                    }
                    String dbTypeStr = record.getString("DB_TYPE");
                    String AssessId = record.getString("ID");
                    if (SqlConnection.ConvertDBType(dbTypeStr) == dbType) {
                        Assessment assessment = this.assessmentMap.get(AssessId);
                        if (assessment == null) {
                            ++this.totalRelevantAssessments;
                            assessment = this.CreateAssessment(record.getString("ID"), record.getString("NAME"), record.getString("DESCRIPTION"), record.getString("RATIONALE"), record.getString("SEVERITY"), record.getString("DB_TYPE"), record.getString("REMEDIATION"), record.getString("CATEGORY_NAME"), record.getString("BASE_SEVERITY"));
                            this.assessmentMap.put(assessment.getId(), assessment);
                        }
                        Script script = new Script(record.getString("SCRIPT_INFO"), record.getString("SCRIPT"));
                        if (record.get("SCRIPT_INFO").equals(SCRIPT_TYPE_DATA_KEYWORD)) {
                            assessment.setDataScriptObj(script);
                            continue;
                        }
                        if (record.get("SCRIPT_INFO").equals(SCRIPT_TYPE_BOOLEAN_KEYWORD)) {
                            assessment.setBooleanScriptObj(script);
                            continue;
                        }
                        throw new DataFormatException("Found " + Integer.toString(record.length()) + " elements instead of " + 12 + ". Skipping record: " + record.toString());
                    }
                    if (SqlConnection.ConvertDBType(dbTypeStr) != SqlConnection.DB_TYPE.UNKNOWN) continue;
                    Logger.Notify("Ignoring assessment id:" + AssessId + " since its DB type is unknown");
                }
                catch (DataFormatException e) {
                    Logger.Warning(e);
                }
            }
        }
        catch (FileNotFoundException e) {
            Logger.Warning(e);
        }
        catch (IOException e) {
            Logger.Warning(e);
        }
        catch (Exception e) {
            Logger.Warning(e);
        }
    }

    private void setStatistics() {
        block7: for (Assessment assessment : this.assessmentMap.values()) {
            if (assessment.isPreTest()) continue;
            switch (assessment.getStatus()) {
                case PASSED: {
                    ++this.passedAssessments;
                    continue block7;
                }
                case FAILED: {
                    ++this.failedAssessments;
                    continue block7;
                }
                case ERROR: {
                    ++this.errorAssessments;
                    continue block7;
                }
                case INFO: {
                    ++this.infoAssessments;
                    continue block7;
                }
                case NOT_SET: {
                    ++this.unhandledAssessments;
                    continue block7;
                }
            }
            Logger.Warning("Unknown result type: " + (Object)((Object)assessment.getStatus()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugWriteResults() {
        if (!Configuration.isDebug()) {
            return;
        }
        BufferedWriter writer = null;
        try {
            File logFile = new File(DEBUG_RESULTS_PATH);
            TreeMap<Long, Assessment> map = new TreeMap<Long, Assessment>();
            writer = new BufferedWriter(new FileWriter(logFile));
            for (Assessment assessment : this.assessmentMap.values()) {
                long longId = Long.parseLong(assessment.getId());
                map.put(longId, assessment);
            }
            for (Map.Entry entry : map.entrySet()) {
                Assessment assess = (Assessment)entry.getValue();
                if (assess.getStatus() == Assessment.Status.NOT_SET || assess.isPreTest()) continue;
                writer.write(entry.getKey() + "," + (Object)((Object)((Assessment)entry.getValue()).getStatus()) + "\r\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private void writeResultsToDisk() throws Exception {
        try {
            boolean hasPermissionsErrors = false;
            SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm:ss a");
            SimpleDateFormat minutesFormat = new SimpleDateFormat("mm:ss");
            for (Assessment assessment : this.assessmentMap.values()) {
                if (assessment.getStatus() != Assessment.Status.ERROR) continue;
                hasPermissionsErrors = true;
                break;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("ASSESSMENT_RESULTS = {\r\n\t'version': '" + ScubaVersion.VERSION + "',\r\n\t'scanTimeMinutes': '" + minutesFormat.format(new Date(this.endTime.getTime() - this.startTime.getTime())) + "',\r\n\t'scanTimeEnd': '" + timeFormat.format(this.endTime) + "',\r\n\t'serverAddress': '" + this.sqlConnection.getServerAddress() + "',\r\n\t'user': '" + this.sqlConnection.getUser() + "',\r\n\t'database': '" + (Object)((Object)this.sqlConnection.getDbType()) + "',\r\n\t'databaseVersion': '" + Utils.escapeJsonString(this.dbVersion) + "',\r\n\t'osVersion': '" + Utils.escapeJsonString(this.remoteOsVersion) + "',\r\n\t'platform': '" + Utils.getPlatform() + "',\r\n\t'utm': '" + Utils.getUtmCode() + "',\r\n\t'hasPermissionsErrors': '" + hasPermissionsErrors + "',\n\t'adcContent': '" + ScubaVersion.ADC_CONTENT_VERSION_AND_DATE + "',\r\n\t'dataRowsCountLimit': " + 500 + ",\r\n\t'dataRowsProcessLimit': " + 50 + ",\r\n\t'assessments' : [\r\n");
            int assessmentCounter = 1;
            for (Assessment assessment : this.assessmentMap.values()) {
                Assessment.Status status = assessment.getStatus();
                if (status == Assessment.Status.NOT_SET || assessment.isPreTest()) continue;
                if (assessmentCounter > 1) {
                    builder.append(",\r\n");
                }
                builder.append(assessment.toJSON(2));
                if (++assessmentCounter <= 3000) continue;
                break;
            }
            builder.append("\r\n\t]\r\n};");
            Path outputFile = Paths.get(ASSESSMENTS_OUTPUT_PATH, new String[0]);
            Files.write(outputFile, builder.toString().getBytes(), new OpenOption[0]);
            Desktop.getDesktop().open(new File(ASSESSMENTS_HTML_PATH));
        }
        catch (Exception ex) {
            Logger.Error("Failed writing results to file", ex);
        }
    }

    public void updateProgressBarWrapper(long workDone, long max) {
        this.updateProgress(workDone, max);
    }

    public void updateProgressMessageWrapper(String message) {
        this.updateMessage(message);
    }

    private Assessment CreateAssessment(String id, String name, String description, String rationale, String severity, String dbTypeStr, String remediation, String categoryName, String score) {
        switch (dbTypeStr) {
            case "MsSql": {
                return new MssqlAssessment(id, name, description, rationale, severity, dbTypeStr, remediation, categoryName, score);
            }
        }
        return new Assessment(id, name, description, rationale, severity, dbTypeStr, remediation, categoryName, score);
    }
}

