/*
 * Decompiled with CFR 0.152.
 */
package com.innovation.imperva;

import com.innovation.imperva.AssessmentManager;
import com.innovation.imperva.AssessmentVariable;
import com.innovation.imperva.Logger;
import com.innovation.imperva.Script;
import com.innovation.imperva.SqlConnection;
import com.innovation.imperva.SqlHelper;
import com.innovation.imperva.Utils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Assessment {
    public static final String INFO_STATUS_KEYWORD = "Info";
    public static final String PRE_TEST_CATEGORY = "Pre-test";
    private SqlConnection.DB_TYPE dbType;
    protected String id;
    private String name;
    private String description;
    private String rationale;
    private String severity;
    private String dbTypeStr;
    private String remediation;
    private Script booleanScriptObj;
    private Script dataScriptObj;
    private Status status;
    private String category;
    private String dataScriptOutput = "[]";
    private String score;
    private int dataRowCount = 0;
    private ArrayList<AssessmentVariable> variablesList = new ArrayList();
    private HashSet<String> relatedRegulations = new HashSet();
    protected static ArrayList<String> dbList = new ArrayList();

    public Assessment(String id, String name, String description, String rationale, String severity, String dbTypeStr, String remediation, String categoryName, String score) {
        this.setId(id);
        this.name = name;
        this.description = description;
        this.rationale = rationale;
        this.severity = severity;
        this.dbTypeStr = dbTypeStr;
        this.setDbType();
        if (dbList.size() == 0) {
            this.generateDbList();
        }
        this.remediation = remediation;
        this.setStatus(Status.NOT_SET);
        this.variablesList = new ArrayList();
        this.category = categoryName;
        this.score = score;
        this.booleanScriptObj = new Script("Boolean", "");
        this.dataScriptObj = new Script("Data", "");
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getScore() {
        return this.score;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public int getDataRowCount() {
        return this.dataRowCount;
    }

    public SqlConnection.DB_TYPE getDbType() {
        return this.dbType;
    }

    public void setDbType() {
        this.dbType = SqlConnection.ConvertDBType(this.dbTypeStr);
    }

    public void setBooleanScriptObj(Script script) {
        this.booleanScriptObj = script;
    }

    public Script getBooleanScriptObj() {
        return this.booleanScriptObj;
    }

    public void setDataScriptObj(Script script) {
        this.dataScriptObj = script;
    }

    public Script getDataScriptObj() {
        return this.dataScriptObj;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String toString() {
        return "ID: " + this.getId() + " ; DB Type: " + (Object)((Object)this.getDbType()) + " ; DB Type (String): " + this.dbTypeStr + "\nBoolean Script: " + this.getBooleanScriptObj() + "\nData Script: " + this.getDataScriptObj();
    }

    public void Execute() throws Exception {
        try {
            Logger.Notify("Executing assessment. Id: " + this.id);
            if (this.status != Status.NOT_SET) {
                return;
            }
            this.ResolveVariables();
            this.replaceVariables();
            this.executeScripts();
        }
        catch (Exception e) {
            this.status = Status.ERROR;
            this.checkAndReconnectDB();
            throw new Exception("Failed executing assessment " + this.getId(), e);
        }
    }

    private void checkAndReconnectDB() {
        int retries = 0;
        while (!AssessmentManager.getInstance().isDBConnected().booleanValue() && retries++ < 5) {
            Logger.Warning("Trying to reconnect to DB, retry num: " + retries);
            AssessmentManager.getInstance().reconnectDB();
        }
    }

    public boolean isPreTest() {
        return this.category.equals(PRE_TEST_CATEGORY);
    }

    private void executeScripts() throws Exception {
        HashMap<String, String> booleanSqlMap = this.booleanScriptObj.getResolvedScripts();
        HashMap<String, String> dataSqlMap = this.dataScriptObj.getResolvedScripts();
        Iterator<Map.Entry<String, String>> boolIt = booleanSqlMap.entrySet().iterator();
        Iterator<Map.Entry<String, String>> dataIt = dataSqlMap.entrySet().iterator();
        while (boolIt.hasNext() || dataIt.hasNext()) {
            Status newStatus;
            String booleanSql = null;
            String dataSql = null;
            if (boolIt.hasNext()) {
                booleanSql = boolIt.next().getValue();
            }
            if (dataIt.hasNext()) {
                dataSql = dataIt.next().getValue();
            }
            try {
                newStatus = this.executeSqlPair(booleanSql, dataSql);
                if (newStatus != Status.FAILED && this.status == Status.FAILED) {
                    newStatus = Status.FAILED;
                }
                if (newStatus == Status.FAILED) {
                    Logger.Debug("Boolean SQL of failed: " + booleanSql);
                    Logger.Debug("Data SQL of failed: " + dataSql);
                }
                if (this.status == Status.ERROR) {
                    Logger.Warning("Setting assessments: " + this.getId() + " from Error to " + (Object)((Object)newStatus));
                }
            }
            catch (Exception ex) {
                if (booleanSqlMap.entrySet().size() > 1 || dataSqlMap.entrySet().size() > 1) {
                    Logger.Warning("The assessments: " + this.getId() + " ended with error on one of the DBs");
                    if (this.status == Status.NOT_SET) {
                        newStatus = Status.ERROR;
                        Logger.Warning("Setting assessments: " + this.getId() + " to Error");
                    } else {
                        newStatus = this.status;
                        Logger.Warning("Setting not changing assessment " + this.getId() + " from " + (Object)((Object)this.status) + " to Error");
                    }
                    this.checkAndReconnectDB();
                }
                throw ex;
            }
            this.status = newStatus;
        }
    }

    private Status executeSqlPair(String booleanSQL, String dataSQL) throws Exception {
        Status retStatus;
        if (!this.severity.equals(INFO_STATUS_KEYWORD) || this.isPreTest()) {
            retStatus = this.executeBooleanSql(booleanSQL);
            Logger.Debug("Test id: " + this.id + " boolean part finished. Status: " + (Object)((Object)retStatus));
        } else {
            retStatus = Status.INFO;
        }
        if (this.dataScriptObj.getResolvedScripts().size() > 0 && (retStatus == Status.FAILED || this.severity.equals(INFO_STATUS_KEYWORD))) {
            this.executeDataSql(dataSQL);
            Logger.Debug("Test id: " + this.id + ". Data part finished.");
        }
        return retStatus;
    }

    private Status executeBooleanSql(String SQL) throws Exception {
        try {
            String value = SqlHelper.execute(SQL);
            if (value == null || value.equals("0")) {
                return Status.PASSED;
            }
            return Status.FAILED;
        }
        catch (SQLTimeoutException e) {
            Logger.Warning("Boolean query timed out (30 seconds) ; assessment id: " + this.id + " ; SQL: " + SQL);
            return Status.NOT_SET;
        }
        catch (Exception e) {
            String Message = "Error while executing boolean assessments.ID: " + this.id + ".";
            throw new Exception(Message, e);
        }
    }

    private void executeDataSql(String SQL) throws Exception {
        ResultSet rs = null;
        try {
            Statement statement = AssessmentManager.getInstance().getSqlStatement();
            boolean isResultSet = statement.execute(SQL);
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            if (isResultSet) {
                rs = statement.getResultSet();
                ResultSetMetaData rsmd = rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                builder.append("['");
                int i = 0;
                while (i < columnCount) {
                    builder.append(Utils.escapeJsonString(rsmd.getColumnName(i + 1)));
                    if (++i >= columnCount) continue;
                    builder.append("','");
                }
                builder.append("'],");
                String prefix = "";
                boolean hasExceeded = false;
                while (rs.next()) {
                    if (this.dataRowCount++ == 50) {
                        hasExceeded = true;
                        break;
                    }
                    builder.append(prefix);
                    builder.append("['");
                    int i2 = 0;
                    while (i2 < columnCount) {
                        builder.append(Utils.escapeJsonString(rs.getString(i2 + 1)));
                        if (++i2 >= columnCount) continue;
                        builder.append("','");
                    }
                    builder.append("']");
                    prefix = ",";
                }
                if (hasExceeded) {
                    while (rs.next() && this.dataRowCount++ < 500) {
                    }
                }
                Logger.Notify("Finished processing " + (this.dataRowCount < 50 ? this.dataRowCount : 50) + " rows out of " + (this.dataRowCount > 500 ? "over 500" : Integer.valueOf(this.dataRowCount)) + " rows counted");
                if (prefix.equals("")) {
                    builder = new StringBuilder();
                    builder.append("[");
                }
            }
            builder.append("]");
            this.dataScriptOutput = builder.toString();
            Logger.Notify("Start Results for testID " + this.id);
            Logger.Debug(this.dataScriptOutput);
            Logger.Notify("End Results for testID " + this.id);
        }
        catch (SQLTimeoutException e) {
            this.dataScriptOutput = "[]";
            Logger.Warning("Data query timed out (30 seconds) ; assessment id: " + this.id + " ; SQL: " + SQL);
        }
        catch (Exception e) {
            this.dataScriptOutput = "[]";
            String message = "Error while executing data assessments.ID: " + this.id + ". SQL: " + SQL + ".";
            throw new Exception(message, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    Logger.Error(e);
                }
            }
        }
    }

    public String statusToString() {
        switch (this.status) {
            case PASSED: {
                return "Passed";
            }
            case FAILED: {
                return "Failed";
            }
            case ERROR: {
                return "Error";
            }
            case INFO: {
                return INFO_STATUS_KEYWORD;
            }
            case NOT_SET: {
                return "Initial";
            }
        }
        return "Invalid";
    }

    public String toJSON(int numOfTabs) {
        String tabs = "";
        while (numOfTabs-- > 0) {
            tabs = tabs + "\t";
        }
        String rem = this.status != Status.PASSED ? Utils.escapeJsonString(this.remediation) : "";
        return tabs + "{\r\n" + tabs + "\t'test': '" + Utils.escapeJsonString(this.name) + "',\r\n" + tabs + "\t'severity': '" + this.severity + "',\r\n" + tabs + "\t'regulations': " + this.getRegulationString() + ",\r\n" + tabs + "\t'result': '" + this.statusToString() + "',\r\n" + tabs + "\t'category': '" + this.getCategory() + "',\r\n" + tabs + "\t'description': '" + Utils.escapeJsonString(this.description) + "',\r\n" + tabs + "\t'remediation': '" + rem + "',\r\n" + tabs + "\t'cveLink': '',\r\n" + tabs + "\t'details': '" + Utils.escapeJsonString(this.rationale) + "',\r\n" + tabs + "\t'data': " + this.dataScriptOutput + ",\r\n" + tabs + "\t'score': '" + this.getScore() + "',\r\n" + tabs + "\t'dataRowCount': " + this.dataRowCount + "\r\n" + tabs + "}";
    }

    private void ResolveVariables() {
        for (AssessmentVariable variable : this.variablesList) {
            try {
                variable.resolve();
            }
            catch (Exception ex) {
                Logger.Error(ex);
                this.checkAndReconnectDB();
            }
        }
    }

    public void addVariable(AssessmentVariable assessmentVariable) {
        for (AssessmentVariable variable : this.variablesList) {
            if (variable != assessmentVariable) continue;
            Logger.Debug("Assessment variable already in map. Test Id: " + this.id + " ; Name: " + variable.getVariable());
            return;
        }
        this.variablesList.add(assessmentVariable);
    }

    private void replaceVariables() throws Exception {
        ArrayList<Map.Entry<String, String>> variablesValue = new ArrayList<Map.Entry<String, String>>();
        for (AssessmentVariable assessmentVariable : this.variablesList) {
            variablesValue.add(new AbstractMap.SimpleEntry<String, String>(assessmentVariable.getVariable(), assessmentVariable.getValue()));
        }
        this.booleanScriptObj.replaceVariables(variablesValue, dbList);
        this.dataScriptObj.replaceVariables(variablesValue, dbList);
    }

    public void addRegulations(String regulation) {
        this.relatedRegulations.add(regulation);
    }

    private String getRegulationString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append("[");
        for (String regulation : this.relatedRegulations) {
            if (regulation.trim().equals("")) continue;
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append("'" + regulation.trim() + "'");
        }
        sb.append("]");
        return sb.toString();
    }

    protected void generateDbList() {
    }

    public static enum Status {
        NOT_SET,
        PASSED,
        FAILED,
        ERROR,
        INFO;

    }
}

