// Includes the user settings
#include "DS2_CONFIG.h"
 // Defines the API to use it with
#define FXAA_HLSL_3 1
// NOTE: This version uses a modified FXAA_GREEN_AS_LUMA 1
#define FXAA_GREEN_AS_LUMA 1
// Includes the Main shader, FXAA 3.11
#include "lib\Fxaa3_11.h"

uniform extern texture gScreenTexture;
uniform extern texture gLumaTexture;

//Definitions: BUFFER_WIDTH, BUFFER_HEIGHT, BUFFER_RCP_WIDTH, BUFFER_RCP_HEIGHT
sampler screenSampler = sampler_state
{
    Texture = <gScreenTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
    AddressU = BORDER;
    AddressV = BORDER;
    SRGBTexture = FALSE;
};
sampler lumaSampler = sampler_state
{
    Texture = <gLumaTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
    AddressU = BORDER;
    AddressV = BORDER;
    SRGBTexture = FALSE;
};

// Includes additional shaders, like Sharpen, Bloom, Tonemap etc.
#include "lib\Post.h"

// FXAA Shader Function
float4 LumaShader( float2 Tex : TEXCOORD0 ) : COLOR0
{
#ifdef USE_ANTI_ALIASING
	float AliasingRemoval = 0;
	float ContrastEdgeThreshold = 0;
	float DarkEdgeThreshold = 0;
	if (fxaaQualitySubpix < 1 || fxaaQualitySubpix > 9) { AliasingRemoval = 0.60; }
	else { AliasingRemoval = fxaaQualitySubpix * 0.1111; }
	if (fxaaQualityEdgeThreshold < 1 || fxaaQualityEdgeThreshold > 9) { ContrastEdgeThreshold = 0.166; }
	else { ContrastEdgeThreshold = 0.060 + (fxaaQualityEdgeThreshold * 0.0303); }
	if (fxaaQualityEdgeThresholdMin < 1 || fxaaQualityEdgeThresholdMin > 9) { DarkEdgeThreshold = 0.0833; }
	else { DarkEdgeThreshold = 0.0254 + (fxaaQualityEdgeThresholdMin * 0.0064); }
    float4 c0 = FxaaPixelShader(
		// pos, Output color texture
		Tex,
		// tex, Input color texture
		screenSampler,
		// fxaaQualityRcpFrame, gets coordinates for screen width and height, xy
		float2(BUFFER_RCP_WIDTH, BUFFER_RCP_HEIGHT),
		//fxaaConsoleRcpFrameOpt2, gets coordinates for screen width and height, xyzw
		float4(-2.0*BUFFER_RCP_WIDTH,-2.0*BUFFER_RCP_HEIGHT,2.0*BUFFER_RCP_WIDTH,2.0*BUFFER_RCP_HEIGHT),
		// Choose the amount of sub-pixel aliasing removal
		AliasingRemoval,
		// The minimum amount of local contrast required to apply algorithm
		ContrastEdgeThreshold,
		// Trims the algorithm from processing darks
		DarkEdgeThreshold
	);
#else
		float4 c0 = tex2D(lumaSampler,Tex);
#endif
    return c0;
}

float4 MyShader( float2 Tex : TEXCOORD0 ) : COLOR0
{
	float4 c0 = main(Tex);
	c0.w = 1;
    return saturate(c0);
}

technique PostProcess1
{
    pass p1
    {
        PixelShader = compile ps_3_0 LumaShader();
    }
}
technique PostProcess2
{
    pass p1
    {
        PixelShader = compile ps_3_0 MyShader();
    }
}