  /*---------------.
  | :: Textures :: |
  '---------------*/

texture2D InputTexture < string type = "input"; >; //Framebuffer input from the game

//------------------------( FXAA )----------------------
#if (USE_FXAA_ANTIALIASING == 1)
  texture2D SweetFXTexture  < string type = "output"; string format = "D3DFMT_A8R8G8B8"; >; //FXAA needs the luma in the alpha channel
#endif

//------------------------( SMAA )----------------------
#if (USE_SMAA_ANTIALIASING == 1)
  texture2D SweetFXTexture  < string type = "output"; string format = "D3DFMT_A8R8G8B8"; >; //TODO : check if D3DFMT_R8G8B8 is faster
  
  texture2D edgesTex2D  < string type = "output"; string format = "D3DFMT_A8R8G8B8"; >; //Need an alpha channel for the stencil
  texture2D blendTex2D  < string type = "output"; string format = "D3DFMT_A8R8G8B8"; >; //Need an alpha channel for the stencil
  
  texture2D areaTex2D < string type = "texture"; string path = "SweetFX/Textures/AreaTexDX9.dds"; string format = "D3DFMT_A8L8";>;
  texture2D searchTex2D < string type = "texture"; string path = "SweetFX/Textures/SearchTex.dds"; string format = "D3DFMT_L8";>;
#endif 

  /*---------------.
  | :: Samplers :: |
  '---------------*/

sampler2D InputSampler
{
	Texture = <InputTexture>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Point;
	AddressU = Clamp; AddressV = Clamp;
};

//------------------------( FXAA )----------------------
#if (USE_FXAA_ANTIALIASING == 1)
sampler2D FXAASampler
{
	Texture = <SweetFXTexture>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Point;
	AddressU = Clamp; AddressV = Clamp;
};
#endif

//------------------------( SMAA )----------------------
#if (USE_SMAA_ANTIALIASING == 1)

sampler2D colorTex {
    Texture = <InputTexture>;
    AddressU  = Clamp; AddressV = Clamp;
    MipFilter = Point; MinFilter = Linear; MagFilter = Linear;
    SRGBTexture = true;
};

sampler2D colorGammaTex {
    Texture = <InputTexture>;
    AddressU  = Clamp; AddressV = Clamp;
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
    SRGBTexture = false;
};

sampler2D edgesTex {
    Texture = <edgesTex2D>;
    AddressU = Clamp; AddressV = Clamp;
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
    SRGBTexture = false;
};

sampler2D blendTex {
    Texture = <blendTex2D>;
    AddressU = Clamp; AddressV = Clamp;
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
    SRGBTexture = false;
};

sampler2D areaTex {
    Texture = <areaTex2D>;
    AddressU = Clamp; AddressV = Clamp; AddressW = Clamp;
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
    SRGBTexture = false;
};

sampler2D searchTex {
    Texture = <searchTex2D>;
    AddressU = Clamp; AddressV = Clamp; AddressW = Clamp;
    MipFilter = Point; MinFilter = Point; MagFilter = Point;
    SRGBTexture = false;
};

#endif 

  /*--------------.
  | :: Structs :: |
  '--------------*/

struct VS_INPUT
{
	float4 pos : POSITION;
	float2 tex : TEXCOORD0;
};
struct VS_OUTPUT
{
	float4 pos : SV_POSITION;
	float2 tex : TEXCOORD0;
};


  /*-------------------------.
  | :: Defining constants :: |
  '-------------------------*/

#define s0 InputSampler
  
#define myTex2D(s,p) tex2D(s,p)


  /*------------------------.
  | :: Including effects :: |
  '------------------------*/
#include "SweetFX/Shaders/Main.h"  //Include the main SweetFX control shader


  /*-----------------------------------.
  | :: SweetFX - main vertex shader :: |
  '-----------------------------------*/

void main_VS(inout float4 position   : POSITION
                    ,inout float2 texcoord   : TEXCOORD0
				  //,out float4 lumacoord[2] : TEXCOORD1
                    )
{

  //lumacoord[0] = pixel.xyxy * (float4(0.5, -0.5, -0.5, -0.5) * offset_bias) + texcoord.xyxy;
  //lumacoord[1] = pixel.xyxy * (float4(0.5, 0.5, -0.5, 0.5) * offset_bias) + texcoord.xyxy;
  
}

  /*----------------------------------.
  | :: SweetFX - main pixel shader :: |
  '----------------------------------*/

float4 main( float2 texcoord : TEXCOORD0
           //, float4 lumacoord[2] : TEXCOORD1
           ) : COLOR0 {

    float4 color = tex2D(InputSampler, texcoord);

    color = SweetFX_main(texcoord,color); // Add the other effects

    return color;  //Returning the pixel
}

  /*------------------------.
  | :: FXAA pixel shader :: |
  '------------------------*/
  
#if (USE_FXAA_ANTIALIASING == 1)

#define FXAA_PC 1
#define FXAA_HLSL_3 1

#include "SweetFX/Shaders/FXAA.h"

float4 FXAA( float2 texcoord : TEXCOORD0 ) : COLOR0
{
	return FxaaPixelShader(
		texcoord,
		float4(0,0,0,0),
		FXAASampler,
		FXAASampler,
		FXAASampler,
		pixel,
		float4(0,0,0,0),
		float4(0,0,0,0),
		float4(0,0,0,0),
		fxaa_Subpix,
		fxaa_EdgeThreshold,
		fxaa_EdgeThresholdMin,
		8.0,
		0.125,
		0.05,
		float4(0,0,0,0)
		);
}
#endif


  /*-------------------.
  | :: SMAA shaders :: |
  '-------------------*/
#if (USE_SMAA_ANTIALIASING == 1)

// Use a real macro here for maximum performance!
#define SMAA_RT_METRICS float4(pixel, screen_size)

// Set the HLSL version:
#define SMAA_HLSL_3

// And include our header!
#include "SweetFX/Shaders/SMAA.h"

/**
 * Function wrappers
 */
 
//----------------------( SMAA vertex shaders )---------------------
void DX9_SMAAEdgeDetectionVS(inout float4 position : POSITION,
                             inout float2 texcoord : TEXCOORD0,
                             out float4 offset[3] : TEXCOORD1) {
    SMAAEdgeDetectionVS(texcoord, offset);
}

void DX9_SMAABlendingWeightCalculationVS(inout float4 position : POSITION,
                                         inout float2 texcoord : TEXCOORD0,
                                         out float2 pixcoord : TEXCOORD1,
                                         out float4 offset[3] : TEXCOORD2) {
    SMAABlendingWeightCalculationVS(texcoord, pixcoord, offset);
}

void DX9_SMAANeighborhoodBlendingVS(inout float4 position : POSITION,
                                    inout float2 texcoord : TEXCOORD0,
                                    out float4 offset : TEXCOORD1) {
    SMAANeighborhoodBlendingVS(texcoord, offset);
}

//----------------------( SMAA pixel shaders )---------------------
float4 DX9_SMAALumaEdgeDetectionPS(float4 position : SV_POSITION,
                                   float2 texcoord : TEXCOORD0,
                                   float4 offset[3] : TEXCOORD1) : COLOR {
    return float4(SMAALumaEdgeDetectionPS(texcoord, offset, colorGammaTex), 0.0, 0.0);
}

float4 DX9_SMAAColorEdgeDetectionPS(float4 position : SV_POSITION,
                                    float2 texcoord : TEXCOORD0,
                                    float4 offset[3] : TEXCOORD1) : COLOR {
    return float4(SMAAColorEdgeDetectionPS(texcoord, offset, colorGammaTex), 0.0, 0.0);
}

float4 DX9_SMAABlendingWeightCalculationPS(float4 position : SV_POSITION,
                                           float2 texcoord : TEXCOORD0,
                                           float2 pixcoord : TEXCOORD1,
                                           float4 offset[3] : TEXCOORD2) : COLOR {
    return SMAABlendingWeightCalculationPS(texcoord, pixcoord, offset, edgesTex, areaTex, searchTex, 0.0);
}

float4 DX9_SMAANeighborhoodBlendingPS(float4 position : SV_POSITION,
                                      float2 texcoord : TEXCOORD0,
                                      float4 offset : TEXCOORD1) : COLOR {
                                      
//-- debugging section --
#if SMAA_DEBUG_OUTPUT == 1
    return myTex2D(edgesTex,texcoord); //Show edgesTex

#elif SMAA_DEBUG_OUTPUT == 2
    return myTex2D(blendTex,texcoord); //Show blendTex
    
#elif SMAA_DEBUG_OUTPUT == 3
    return myTex2D(areaTex,texcoord); //Show areaTex
    
#elif SMAA_DEBUG_OUTPUT == 4    
    return myTex2D(searchTex,texcoord); //Show searchTex
    
#else
    return SMAANeighborhoodBlendingPS(texcoord, offset, colorTex, blendTex); //Show the normal output

#endif    

}

#endif



  /*-----------------.
  | :: Techniques :: |
  '-----------------*/

    //What Shader Model should we use?
    #if (SweetFX_shader_model == 0)
      #define vertex_shader_model vs_2_0
      #define pixel_shader_model  ps_2_0

    #elif (SweetFX_shader_model == 1)
      #define vertex_shader_model vs_2_0
      #define pixel_shader_model  ps_2_a

    #elif (SweetFX_shader_model == 2)
      #define vertex_shader_model vs_2_0
      #define pixel_shader_model  ps_2_b

    #else
      #define vertex_shader_model vs_3_0
      #define pixel_shader_model  ps_3_0

    #endif


technique SweetFX {
//----------------------( SweetFX )---------------------

    pass SweetFX
    #if (USE_FXAA_ANTIALIASING == 1) || (USE_SMAA_ANTIALIASING == 1)
        < string output0 = "SweetFXTexture"; >
    #endif
    {
        VertexShader = compile vertex_shader_model main_VS();
        PixelShader  = compile pixel_shader_model main(); //Use this with GPU Shaderanalyzer
    }

//------------------------( FXAA )----------------------
#if (USE_FXAA_ANTIALIASING == 1)

    pass FXAA
	{
		VertexShader = compile vs_3_0 main_VS();
		PixelShader = compile ps_3_0 FXAA();
	}

#endif
	
//------------------------( SMAA )----------------------
#if (USE_SMAA_ANTIALIASING == 1)

    pass SMAA_EdgeDetection
    < string output0 = "edgesTex2D"; >
	{
        VertexShader = compile vs_3_0 DX9_SMAAEdgeDetectionVS();

        #if COLOR_EDGE_DETECTION == 1
          PixelShader = compile ps_3_0 DX9_SMAAColorEdgeDetectionPS();
        #else
          PixelShader = compile ps_3_0 DX9_SMAALumaEdgeDetectionPS();
        #endif

        ZEnable = false;        
        SRGBWriteEnable = false;
        AlphaBlendEnable = false;
        AlphaTestEnable = false;

        // We will be creating the stencil buffer for later usage.
        StencilEnable = true;
        StencilPass = REPLACE;
        StencilRef = 1;
	}


    pass SMAA_BlendWeightCalculation
    < string output0 = "blendTex2D"; >
    {
        VertexShader = compile vs_3_0 DX9_SMAABlendingWeightCalculationVS();
        PixelShader = compile ps_3_0 DX9_SMAABlendingWeightCalculationPS();
        
        ZEnable = false;
        SRGBWriteEnable = false;
        AlphaBlendEnable = false;
        AlphaTestEnable = false;

        // Here we want to process only marked pixels.
        StencilEnable = true;
        StencilPass = KEEP;
        StencilFunc = EQUAL;
        StencilRef = 1;
    }


    pass SMAA_NeighborhoodBlending {
        VertexShader = compile vs_3_0 DX9_SMAANeighborhoodBlendingVS();
        PixelShader = compile ps_3_0 DX9_SMAANeighborhoodBlendingPS();
        
        ZEnable = false;
        SRGBWriteEnable = true;
        AlphaBlendEnable = false;
        AlphaTestEnable = false;

        // Here we want to process all the pixels.
        StencilEnable = false;
    }


#endif

//--------------------------------------------	

}
