#include "..\..\GEM_settings.txt"

float ShiftSamplingRange=GHBOShift;

float4 ScreenSize=float4(1920,(1/1920),(1920/1080),(1080/1920));

texture2D texColor;

sampler2D SamplerColor = sampler_state
{
	Texture   = <texColor>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;//NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

struct VS_OUTPUT_POST
{
	float4 vpos  : POSITION;
	float2 txcoord : TEXCOORD0;
};

struct VS_INPUT_POST
{
	float3 pos  : POSITION;
	float2 txcoord : TEXCOORD0;
};

VS_OUTPUT_POST VS_PostProcess(VS_INPUT_POST IN)
{
	VS_OUTPUT_POST OUT;

	float4 pos=float4(IN.pos.x,IN.pos.y,IN.pos.z,1.0);

	OUT.vpos=pos;
	OUT.txcoord.xy=IN.txcoord.xy;

	return OUT;
}

float4 PS_ProcessShift(VS_OUTPUT_POST IN, float2 vPos : VPOS) : COLOR
{
	float4 res;
	float4 coord=0.0;

	coord.xy=IN.txcoord.xy;
	float4 origcolor;

	coord.w=0.0;

	origcolor=tex2Dlod(SamplerColor, coord);

	int i=0;

	float4 tcol=origcolor;
	float2 invscreensize=1.0/ScreenSize.x;
	invscreensize.y=invscreensize.y/ScreenSize.z;

	coord.xy=IN.txcoord.xy;
	origcolor=tex2Dlod(SamplerColor, coord);
	res.y=origcolor.y;

	coord.xy=IN.txcoord.xy;
	coord.y-=invscreensize*ShiftSamplingRange;
	origcolor=tex2Dlod(SamplerColor, coord);
	res.x=origcolor.x;

	coord.xy=IN.txcoord.xy;
	coord.y+=invscreensize*ShiftSamplingRange;
	origcolor=tex2Dlod(SamplerColor, coord);
	res.z=origcolor.z;

	res.w=1.0;
	return res;
}

technique PostProcess
{
	pass P0
	{
	#if (USE_GEMHBO == 1)
		VertexShader = compile vs_3_0 VS_PostProcess();
		PixelShader  = compile ps_3_0 PS_ProcessShift();

		DitherEnable=FALSE;
		ZEnable=FALSE;
		CullMode=NONE;
		ALPHATESTENABLE=FALSE;
		SEPARATEALPHABLENDENABLE=FALSE;
		AlphaBlendEnable=FALSE;
		StencilEnable=FALSE;
		FogEnable=FALSE;
		SRGBWRITEENABLE=FALSE;
	#endif
	}
}

