Scriptname GenericRaceController extends Quest

; Race Compatibility
FormList Property PlayableRaceList Auto
FormList Property PlayableVampireList Auto

FormList Property RacesHuman Auto
FormList Property RacesBeast Auto
FormList Property RacesElf Auto

; Multi-Race Parts
FormList Property HeadPartsAllRacesMinusBeast  Auto  
FormList Property HeadPartsAllRacesMinusBeastVampires  Auto  

; Human-Race Parts
FormList Property HeadPartsHuman  Auto  
FormList Property HeadPartsHumanVampires  Auto  
FormList Property HeadPartsHumansandVampires  Auto  
FormList Property HeadPartsHumansOrcsandVampires  Auto  
FormList Property HeadPartsHumanoidVampire  Auto  
FormList Property HeadPartsBretsNordsImpsandVampires  Auto  

; Elves Parts
FormList Property HeadPartsElves  Auto  
FormList Property HeadPartsElvesandVampires  Auto  

; Single-Race Parts
FormList Property HeadPartsArgonian  Auto  
FormList Property HeadPartsBreton  Auto  
FormList Property HeadPartsDarkElf  Auto  
FormList Property HeadPartsHighElf  Auto  
FormList Property HeadPartsImperial  Auto  
FormList Property HeadPartsKhajiit  Auto  
FormList Property HeadPartsNord  Auto  
FormList Property HeadPartsOrc  Auto  
FormList Property HeadPartsRedguard  Auto  
FormList Property HeadPartsWoodElf  Auto  

; Single-Race Parts and Vampire
FormList Property HeadPartsArgonianandVampire  Auto  
FormList Property HeadPartsBretonandVampire  Auto  
FormList Property HeadPartsDarkElfandVampire  Auto  
FormList Property HeadPartsHighElfandVampire  Auto  
FormList Property HeadPartsImperialandVampire  Auto  
FormList Property HeadPartsKhajiitandVampire  Auto  
FormList Property HeadPartsNordandVampire  Auto  
FormList Property HeadPartsOrcandVampire  Auto  
FormList Property HeadPartsRedguardandVampire  Auto  
FormList Property HeadPartsWoodElfandVampire  Auto  

; New Races
FormList Property NewArgonian Auto
FormList Property NewBreton Auto
FormList Property NewDarkElf Auto
FormList Property NewHighElf Auto
FormList Property NewImperial Auto
FormList Property NewKhajiit Auto
FormList Property NewNord Auto
FormList Property NewOrc Auto
FormList Property NewRedguard Auto
FormList Property NewWoodElf Auto

; New Races Vampire
FormList Property NewArgonianVampire Auto
FormList Property NewBretonVampire Auto
FormList Property NewDarkElfVampire Auto
FormList Property NewHighElfVampire Auto
FormList Property NewImperialVampire Auto
FormList Property NewKhajiitVampire Auto
FormList Property NewNordVampire Auto
FormList Property NewOrcVampire Auto
FormList Property NewRedguardVampire Auto
FormList Property NewWoodElfVampire Auto

Function proxyRaces()
  RaceDispatcherScript dispatch = Game.GetFormFromFile(0x00009F27, "RaceCompatibility.esm") As RaceDispatcherScript
  While (!dispatch.doProxyRace(Self))
	Utility.WaitMenuMode(0.5)
  EndWhile
EndFunction

Function populateLists(FormList[] HeadPartsList, FormList[] HeadPartsVampireList)
	HeadPartsList[0] = HeadPartsArgonian
	HeadPartsList[1] = HeadPartsBreton
	HeadPartsList[2] = HeadPartsDarkElf
	HeadPartsList[3] = HeadPartsHighElf
	HeadPartsList[4] = HeadPartsImperial
	HeadPartsList[5] = HeadPartsKhajiit
	HeadPartsList[6] = HeadPartsNord
	HeadPartsList[7] = HeadPartsOrc
	HeadPartsList[8] = HeadPartsRedguard
	HeadPartsList[9] = HeadPartsWoodElf

	HeadPartsVampireList[0] = HeadPartsArgonianandVampire
	HeadPartsVampireList[1] = HeadPartsBretonandVampire
	HeadPartsVampireList[2] = HeadPartsDarkElfandVampire
	HeadPartsVampireList[3] = HeadPartsHighElfandVampire
	HeadPartsVampireList[4] = HeadPartsImperialandVampire
	HeadPartsVampireList[5] = HeadPartsKhajiitandVampire
	HeadPartsVampireList[6] = HeadPartsNordandVampire
	HeadPartsVampireList[7] = HeadPartsOrcandVampire
	HeadPartsVampireList[8] = HeadPartsRedguardandVampire
	HeadPartsVampireList[9] = HeadPartsWoodElfandVampire	
EndFunction

bool Function internalProxyRaces()
	FormList[] RaceList = new FormList[10]
	RaceList[0] = NewArgonian
	RaceList[1] = NewBreton
	RaceList[2] = NewDarkElf
	RaceList[3] = NewHighElf
	RaceList[4] = NewImperial
	RaceList[5] = NewKhajiit
	RaceList[6] = NewNord
	RaceList[7] = NewOrc
	RaceList[8] = NewRedguard
	RaceList[9] = NewWoodElf
	
	FormList[] RaceListVampire = new FormList[10]
	RaceListVampire[0] = NewArgonianVampire
	RaceListVampire[1] = NewBretonVampire
	RaceListVampire[2] = NewDarkElfVampire
	RaceListVampire[3] = NewHighElfVampire
	RaceListVampire[4] = NewImperialVampire
	RaceListVampire[5] = NewKhajiitVampire
	RaceListVampire[6] = NewNordVampire
	RaceListVampire[7] = NewOrcVampire
	RaceListVampire[8] = NewRedguardVampire
	RaceListVampire[9] = NewWoodElfVampire
	
	FormList[] HeadPartsList = new FormList[10]
	FormList[] HeadPartsVampireList = new FormList[10]
	populateLists(HeadPartsList, HeadPartsVampireList)

	
	int element = 0
	While(element < RaceList.Length)
		If(RaceList[element] != None && RaceList[element].GetSize() > 0) ; Ensure we actually have a replacement
			int index = 0
			While(index < RaceList[element].GetSize()) ; Cycle each race in our replacement list
				; Regular Listing
				Race standardRace = RaceList[element].GetAt(index) AS Race
				if(standardRace != None) ; Make sure we actually have a race to replace with
					if(PlayableRaceList != None) ; Check for None so we can skip transform script without crashing
						addIfNeeded(PlayableRaceList, standardRace)						
					endIf
					updateStandardRaces(element, HeadPartsList[element], HeadPartsVampireList[element], standardRace)
					
					; Vampire Listing
					If(RaceListVampire[element] != None && RaceListVampire[element].GetSize() > 0)
						Race vampireRace = RaceListVampire[element].GetAt(index) AS Race
						if(vampireRace != None)
							if(PlayableVampireList != None) ; Check for None so we can skip transform script without crashing
								addIfNeeded(PlayableVampireList, vampireRace)
							endIf
							updateVampireRaces(element, HeadPartsVampireList[element], vampireRace)

							; mainly here for ease of maintenance
							extraLists(element, standardRace, vampireRace)
						endIf
					endIf
				endIf
				index += 1
			endWhile
		endIf
		element += 1
	EndWhile
	Return True
EndFunction

Function addIfNeeded(FormList suppliedForm, Race suppliedRace)
	if(!suppliedForm.HasForm(suppliedRace))
		suppliedForm.AddForm(suppliedRace)
	endIf
EndFunction

Function updateStandardRaces(int element, FormList hpList, FormList hpVampList, Race suppliedRace)
	; Self listing
	addIfNeeded(hpList, suppliedRace)
	addIfNeeded(hpVampList, suppliedRace)
	
	if(!isHuman(element))
		addIfNeeded(RacesBeast, suppliedRace)
	endIf
	
	; Conditioned Listings
	If(isHuman(element) || isOrc(element) || isElf(element))
		addIfNeeded(HeadPartsAllRacesMinusBeast, suppliedRace)
	endIf
	If(isHuman(element))
		addIfNeeded(RacesHuman, suppliedRace)
		addIfNeeded(HeadPartsHuman, suppliedRace)
		addIfNeeded(HeadPartsHumansandVampires, suppliedRace)
		addIfNeeded(HeadPartsHumansOrcsandVampires, suppliedRace)
	endIf
	If(isOrc(element))
		addIfNeeded(HeadPartsHumansOrcsandVampires, suppliedRace)
	endIf
	If(isElf(element))
		addIfNeeded(RacesElf, suppliedRace)
		addIfNeeded(HeadPartsElves, suppliedRace)
		addIfNeeded(HeadPartsElvesandVampires, suppliedRace)
	endIf
	If(isBreton(element) || isNord(element) || isImperial(element))
		addIfNeeded(HeadPartsBretsNordsImpsandVampires, suppliedRace)
	endIf
EndFunction

Function updateVampireRaces(int element, FormList hpVampList, Race suppliedVampRace)
	addIfNeeded(hpVampList, suppliedVampRace)
	
	; Conditioned Listings
	If(isHuman(element) || isOrc(element) || isElf(element))
		addIfNeeded(HeadPartsAllRacesMinusBeast, suppliedVampRace)
	endIf
	if(isHuman(element))
		addIfNeeded(HeadPartsHumanVampires, suppliedVampRace)
		addIfNeeded(HeadPartsHumansandVampires, suppliedVampRace)
		addIfNeeded(HeadPartsHumansOrcsandVampires, suppliedVampRace)
		addIfNeeded(HeadPartsHumanoidVampire, suppliedVampRace)
	endIf
	if(isOrc(element))
		addIfNeeded(HeadPartsHumansOrcsandVampires, suppliedVampRace)
	endIf
	If(isElf(element))
		addIfNeeded(HeadPartsElvesandVampires, suppliedVampRace)
	endIf
	If(isBreton(element) || isNord(element) || isImperial(element))
		addIfNeeded(HeadPartsBretsNordsImpsandVampires, suppliedVampRace)
	endIf
	if(isOrc(element) || isElf(element))
		addIfNeeded(HeadPartsHumanoidVampire, suppliedVampRace)
	endIf
EndFunction

Function extraLists(int element, Race suppliedRace, Race suppliedVampRace)
	; normally unused
EndFunction

Bool Function isHuman(int index)
	if(index == 0)
		return false
	elseif(index == 2)
		return false
	elseif(index == 3)
		return false
	elseif(index == 5)
		return false
	elseif(index == 7)
		return false
	elseif(index == 9)
		return false
	else
		return true
	endif
	return true
EndFunction

Bool Function isBreton(int index)
	if(index == 1)
		return true
	else
		return false
	endif
	return false
EndFunction

Bool Function isNord(int index)
	if(index == 6)
		return true
	else
		return false
	endif
	return false
EndFunction

Bool Function isImperial(int index)
	if(index == 4)
		return true
	else
		return false
	endif
	return false
EndFunction

Bool Function isOrc(int index)
	if(index == 7)
		return true
	else
		return false
	endif
	return false
EndFunction

Bool Function isElf(int index)
	if(index == 2)
		return true
	elseif(index == 3)
		return true
	elseif(index == 9)
		return true
	else
		return false
	endif
	return false
EndFunction
