/*
 *  libtiff.h
 *  libtiff
 *
 *  Created by Jean-Dominique Liénart on 30/06/08.
 *  Copyright 2008 IRIS. All rights reserved.
 *
 */

#ifdef __cplusplus
extern "C" {
#endif

#define COMPRESSION_NONE			1	/* dump mode */
#define COMPRESSION_CCITTRLE		2	/* CCITT modified Huffman RLE */
#define COMPRESSION_CCITTFAX3		3	/* CCITT Group 3 fax encoding */
#define COMPRESSION_CCITTFAX4		4	/* CCITT Group 4 fax encoding */
#define COMPRESSION_LZW				5       /* Lempel-Ziv  & Welch */
#define COMPRESSION_NEXT			32766	/* NeXT 2-bit RLE */
#define COMPRESSION_CCITTRLEW		32771	/* #1 w/ word alignment */
#define COMPRESSION_PACKBITS		32773	/* Macintosh RLE */
#define COMPRESSION_THUNDERSCAN	32809	/* ThunderScan RLE */
#define COMPRESSION_SGILOG			34676	/* SGI Log Luminance RLE */
#define COMPRESSION_SGILOG24		34677	/* SGI Log 24-bit packed */

#define ORIENTATION_TOPLEFT		1	/* row 0 top, col 0 lhs */
#define ORIENTATION_TOPRIGHT		2	/* row 0 top, col 0 rhs */
#define ORIENTATION_BOTRIGHT		3	/* row 0 bottom, col 0 rhs */
#define ORIENTATION_BOTLEFT		4	/* row 0 bottom, col 0 lhs */
#define ORIENTATION_LEFTTOP		5	/* row 0 lhs, col 0 top */
#define  ORIENTATION_RIGHTTOP		6	/* row 0 rhs, col 0 top */
#define ORIENTATION_RIGHTBOT		7	/* row 0 rhs, col 0 bottom */
#define ORIENTATION_LEFTBOT		8	/* row 0 lhs, col 0 bottom */

// only the following color depth combinations are supported
// srcBitsPerPixel = 8, dstBitsPerPixel = 1 (B&W) or 8 (gray)
// srcBitsPerPixel = 32, dstBitsPerPixel = 24 (color)

typedef struct
	{
	int (*open)(void *, char, char *, char *);
	int (*close)(void *);
	int (*read)(void *, void *, int);
	int (*write)(void *, void *, int);
	unsigned int (*seek)(void *, unsigned int, int);
	unsigned int (*size)(void *);
	void (*fillScanLine) (int, int, unsigned char *, int, unsigned char *, int);
	} TIFFCallbacks;
	
extern void TIFFSetupFile (TIFFCallbacks *pCallbacks);
extern void TIFFSetupMemory (TIFFCallbacks *pCallbacks);
extern int TIFFToFile (unsigned char *pPixels, int width, int height, int srcBitsPerPixel, int dstBitsPerPixel, int srcBytesPerRow, int compression, int resolution, int orientation, int invert, void *pFile);
extern int TIFFToMemory (unsigned char *pPixels, int width, int height, int srcBitsPerPixel, int dstBitsPerPixel, int srcBytesPerRow, int compression, int resolution, int orientation, int invert, void *h);

#ifdef __cplusplus
}
#endif
