/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.world;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.FPSLogger;
import com.badlogic.gdx.math.Vector3;
import com.ortisoft.ortilator.Game;
import com.ortisoft.ortilator.OrtiMain;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.assets.ISDLocale;
import com.ortisoft.ortilator.controllers.AbstractHandling;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.CameraControllerDesktop;
import com.ortisoft.ortilator.controllers.GuiController;
import com.ortisoft.ortilator.controllers.IntroController;
import com.ortisoft.ortilator.controllers.MapController;
import com.ortisoft.ortilator.controllers.ParticleDrawController;
import com.ortisoft.ortilator.controllers.PlaceableDrawController;
import com.ortisoft.ortilator.controllers.TextureDrawController;
import com.ortisoft.ortilator.controllers.TileDrawController;
import com.ortisoft.ortilator.controllers.menu.MainMenuController;
import com.ortisoft.ortilator.controllers.menu.NewGameMenuController;
import com.ortisoft.ortilator.entities.ICharacter;
import com.ortisoft.ortilator.entities.IGadget;
import com.ortisoft.ortilator.entities.IObjectModifiers;
import com.ortisoft.ortilator.entities.blocks.ActualBlock;
import com.ortisoft.ortilator.stateControls.GameState;
import com.ortisoft.ortilator.world.loaders.BlockLoader;

public class World
extends ScreenAdapter {
    private static boolean closeCommand;
    public static boolean debug;
    private static boolean showFps;
    private transient OrtiMain mainMenu;
    private transient Game game;
    private transient Vector3 touchPoint;
    private static AbstractHandling cameraController;
    private TileDrawController tileManager;
    private ParticleDrawController particleDrawController;
    private PlaceableDrawController placeableDrawController;
    private IntroController introController;
    private TextureDrawController textureDrawController;
    private float steamAcum;
    private GuiController guiController;
    private GameState gameState;
    private static float latestDelta;
    private float accumulator;
    private boolean tutoShowingBeforeStart;
    private static Vector3 mousePos;
    private static boolean mobile;
    private FPSLogger fpsLogger;

    public TextureDrawController getTextureDrawController() {
        return this.textureDrawController;
    }

    public static boolean isCloseCommand() {
        return closeCommand;
    }

    public static void closeCommand() {
        closeCommand = true;
    }

    public static float getDeltaTime() {
        return latestDelta;
    }

    public GameState getGameState() {
        return this.gameState;
    }

    public static AbstractHandling getCameraController() {
        return cameraController;
    }

    public static Vector3 getMousePos() {
        return mousePos;
    }

    public static boolean isMobile() {
        return mobile;
    }

    public static void toggleDebug() {
        debug = !debug;
    }

    public World(OrtiMain mainMenu, Game game) {
        try {
            this.resetAllValues();
            this.mainMenu = mainMenu;
            this.game = game;
            Gdx.input.setCatchBackKey(true);
            Assets.clear();
            Assets.load();
            ISDLocale.setLocale(game.getLang());
            mobile = game.isMobile();
            cameraController = new CameraControllerDesktop(game, OrtiMain.GameModes.INFINITE);
            if (game.isShowIntro()) {
                this.introController = new IntroController(cameraController);
            }
            this.loadBasic();
            this.resetGameState();
            this.getGameState().setShowGeneralMenu();
            if (showFps) {
                this.fpsLogger = new FPSLogger();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            OrtiMain.log(ex);
            throw ex;
        }
    }

    private void resetGameState() {
        this.gameState = new GameState(this);
        this.getGameState().createMainMenu(World.getCameraController(), this);
    }

    private void resetAllValues() {
        closeCommand = false;
    }

    private void startNewGameFromStart() {
        this.mainMenu.startNewGame();
    }

    public void startNewGame(OrtiMain.GameModes gameMode, NewGameMenuController.Type gameType, IGadget selectedGadget, IObjectModifiers selectedObjectModifier, ICharacter selectedCharacter, IGadget selectedGadget2, ICharacter selectedCharacter2, Object controller1, Object controller2) {
        this.resetFrameDraw();
        this.resetGameState();
        if ((OrtiMain.isShowTutorial() || gameMode == OrtiMain.GameModes.TUTORIAL) && gameMode != OrtiMain.GameModes.TWO_PLAYERS) {
            this.tutoShowingBeforeStart = true;
            OrtiMain.setShowTutorial(false);
        }
        if (!this.tutoShowingBeforeStart) {
            OrtiMain.updateLatestTip();
            cameraController = new CameraControllerDesktop(this.game, gameMode);
        } else {
            cameraController = new CameraControllerDesktop(this.game, OrtiMain.GameModes.TUTORIAL);
        }
        this.clearMap();
        this.addInitialBlocks(gameMode == OrtiMain.GameModes.TWO_PLAYERS);
        if (this.tutoShowingBeforeStart) {
            this.getGameState().setTutorialShow();
        }
        this.addBasicControllers();
        Assets.gameMusic();
        if (gameMode != OrtiMain.GameModes.TWO_PLAYERS) {
            OrtiMain.setLatestCharacter(selectedCharacter);
            if (gameType == NewGameMenuController.Type.EXTENDED && !this.tutoShowingBeforeStart) {
                OrtiMain.setLatestSelectedGadget(selectedGadget);
                OrtiMain.setLatestSelectedOM(selectedObjectModifier);
            }
            OrtiMain.saveGame();
            this.getGameState().startGame(this.game.isMobile(), gameMode, gameType, selectedGadget, selectedObjectModifier, selectedCharacter);
        } else {
            this.getGameState().startGameTwoPlayerGame(selectedGadget, selectedCharacter, selectedGadget2, selectedCharacter2, controller1, controller2);
        }
        this.addControllersWithData();
        cameraController.resetCameraPosition();
    }

    private void addInitialBlocks(boolean isTwoPlayers) {
        int id;
        int i;
        for (i = 0; i <= AbstractMapController.getMAP_WIDTH() + 1; ++i) {
            id = MapController.getAndSetIdCounter();
            MapController.getBlocks().put(id, new ActualBlock(id, (float)i, 0.0f, 0.0f, 1.0f, 1.0f, BlockLoader.allBlocks.get(6)));
            MapController.getActualBlocks()[i][0] = MapController.getBlocks().get(id);
        }
        for (i = 1; i < AbstractMapController.getMAP_HEIGHT() - 1; ++i) {
            id = MapController.getAndSetIdCounter();
            MapController.getBlocks().put(id, new ActualBlock(id, 0.0f, (float)i, 0.0f, 1.0f, 1.0f, BlockLoader.allBlocks.get(6)));
            MapController.getActualBlocks()[0][i] = MapController.getBlocks().get(id);
            id = MapController.getAndSetIdCounter();
            MapController.getBlocks().put(id, new ActualBlock(id, (float)(AbstractMapController.getMAP_WIDTH() + 1), (float)i, 0.0f, 1.0f, 1.0f, BlockLoader.allBlocks.get(6)));
            MapController.getActualBlocks()[AbstractMapController.getMAP_WIDTH() + 1][i] = MapController.getBlocks().get(id);
            if (!isTwoPlayers) continue;
            id = MapController.getAndSetIdCounter();
            MapController.getBlocks().put(id, new ActualBlock(id, (float)((int)Math.floor(8.0) + 1), (float)i, 0.0f, 1.0f, 1.0f, BlockLoader.allBlocks.get(6)));
            MapController.getActualBlocks()[(int)Math.floor((double)8.0) + 1][i] = MapController.getBlocks().get(id);
        }
    }

    private void clearMap() {
        MapController.reinitialize();
    }

    private void addBasicControllers() {
    }

    private void addControllersWithData() {
        this.tileManager = new TileDrawController(cameraController);
        this.particleDrawController = new ParticleDrawController(cameraController);
        this.placeableDrawController = new PlaceableDrawController(cameraController);
        this.textureDrawController = new TextureDrawController(cameraController);
        this.guiController = new GuiController(cameraController, this);
    }

    @Override
    public void resize(int width, int height) {
        cameraController.resize(width, height);
        if (this.getGameState().getMainMenuController() != null) {
            this.getGameState().getMainMenuController().resize(cameraController);
        }
        if (this.getGameState().getIngameMenuController() != null) {
            this.getGameState().getIngameMenuController().resize(cameraController);
        }
        if (this.getGameState().getIngameEndGameMenuController() != null) {
            this.getGameState().getIngameEndGameMenuController().resize(cameraController);
        }
    }

    private void loadBasic() {
        this.touchPoint = new Vector3();
    }

    @Override
    public void render(float delta) {
        float frameTime = Math.min(delta, 0.015384615f);
        this.accumulator += frameTime;
        while (this.accumulator >= 0.015384615f) {
            this.update(0.015384615f);
            this.accumulator -= 0.015384615f;
        }
        this.steamAcum += delta;
        if (this.steamAcum > 0.05f) {
            OrtiMain.updateSteam();
            this.steamAcum = 0.0f;
        }
    }

    private void update(float delta) {
        if (this.game.isShowIntro() && this.introController != null) {
            if (Gdx.input.justTouched()) {
                this.finishIntro();
            } else {
                this.introController.update(delta);
                this.drawIntro();
            }
            return;
        }
        try {
            latestDelta = delta;
            if (this.getGameState().isRestarting() || this.getGameState().isRestartingGame() && this.getGameState().getGameMode() == OrtiMain.GameModes.TUTORIAL) {
                this.startNewGameFromStart();
                return;
            }
            if (this.getGameState().isRestartingGame()) {
                this.tutoShowingBeforeStart = false;
                this.startNewGame(this.getGameState().getGameMode(), this.getGameState().getGameType(), this.getGameState().getSelectedGadget(), this.getGameState().getSelectedObjectModifier(), this.getGameState().getSelectedCharacter(), this.getGameState().getSelectedGadget2(), this.getGameState().getSelectedCharacter2(), this.getGameState().getControllerPlayerController(1), this.getGameState().getControllerPlayerController(2));
            } else {
                this.updateMouseCoordinates();
                if (!this.getGameState().isExiting()) {
                    if (World.resetCloseCommand()) {
                        if (this.getGameState().isShowGeneralMenu()) {
                            if (!(this.getGameState().getMainMenuController().getSelectedMenu() instanceof NewGameMenuController) || ((NewGameMenuController)this.getGameState().getMainMenuController().getSelectedMenu()).getCurrentInsideMenu() == NewGameMenuController.InsideMenu.SELECTION_TYPE) {
                                if (this.getGameState().getMainMenuController().getCurrentMenu() == null) {
                                    this.exitGame();
                                    return;
                                }
                                if (this.getGameState().getMainMenuController().getCurrentMenu() != MainMenuController.MenuOptions.TUTORIAL) {
                                    this.getGameState().getMainMenuController().resetCurrentMenu();
                                }
                            } else if (this.getGameState().getMainMenuController().getCurrentMenu() != MainMenuController.MenuOptions.TUTORIAL) {
                                this.getGameState().getMainMenuController().getSelectedMenu().setClosed();
                            }
                        } else {
                            this.getGameState().createInGameMenu(cameraController);
                        }
                    } else if (this.getGameState().isShowGeneralMenu() && this.getGameState().getMainMenuController().getSelectedMenu() instanceof NewGameMenuController && ((NewGameMenuController)this.getGameState().getMainMenuController().getSelectedMenu()).isFinish()) {
                        this.startNewGameFromMain();
                    } else if (this.getGameState().isShowGeneralMenu()) {
                        this.getGameState().getMainMenuController().updateMouseHover(mousePos);
                    }
                    this.unProjectCoordinatesGui();
                    if (!this.getGameState().isShowGeneralMenu()) {
                        this.getGameState().updateRender(World.getDeltaTime(), this.touchPoint);
                    } else if (World.resetCloseCommand()) {
                        this.getGameState().closeGeneralMenu();
                    } else if (Gdx.input.justTouched()) {
                        if (!this.getGameState().getMainMenuController().update(this.touchPoint)) {
                            if (this.getGameState().getMainMenuController().isClosed()) {
                                if (this.getGameState().getMainMenuController().getCurrentMenu() == MainMenuController.MenuOptions.NEW_GAME && ((NewGameMenuController)this.getGameState().getMainMenuController().getSelectedMenu()).isFinish()) {
                                    this.startNewGameFromMain();
                                } else if (this.getGameState().getMainMenuController().getCurrentMenu() == null) {
                                    this.exitGame();
                                } else {
                                    this.getGameState().getMainMenuController().resetCurrentMenu();
                                }
                            }
                        } else if (this.tutoShowingBeforeStart && this.getGameState().getMainMenuController().getCurrentMenu() == null && this.getGameState().getMainMenuController().getLatestMenu() == MainMenuController.MenuOptions.TUTORIAL) {
                            this.tutoShowingBeforeStart = false;
                            OrtiMain.saveGame();
                            this.getGameState().unSetShowGeneralMenu();
                        }
                    }
                } else {
                    this.game.dispose();
                }
                if (!this.getGameState().isExiting() && !this.getGameState().isRestarting()) {
                    this.draw();
                    World.resetCloseCommand();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assets.dispose();
            this.shutDownThreads();
            OrtiMain.log(ex);
            throw ex;
        }
    }

    private void startNewGameFromMain() {
        NewGameMenuController.Type gameType = ((NewGameMenuController)this.getGameState().getMainMenuController().getSelectedMenu()).getSelectedType();
        IGadget selectedGadget = ((NewGameMenuController)this.getGameState().getMainMenuController().getSelectedMenu()).getSelectedGadget();
        IObjectModifiers selectedObjectModifier = ((NewGameMenuController)this.getGameState().getMainMenuController().getSelectedMenu()).getSelectedObjectModifier();
        ICharacter selectedCharacter = ((NewGameMenuController)this.getGameState().getMainMenuController().getSelectedMenu()).getSelectedCharacter();
        ICharacter selectedCharacter2 = null;
        IGadget selectedGadget2 = null;
        OrtiMain.GameModes gameMode = null;
        switch (((NewGameMenuController)this.getGameState().getMainMenuController().getSelectedMenu()).getSelectedAction()) {
            case NORMAL_INFINITE: {
                gameMode = OrtiMain.GameModes.INFINITE;
                break;
            }
            case NORMAL_ESCAPE: {
                gameMode = OrtiMain.GameModes.ESCAPE;
                break;
            }
            case CLAUSTRO_INFINITE: {
                gameMode = OrtiMain.GameModes.INFINITE_CLAUSTRO;
                break;
            }
            case CLAUSTRO_ESCAPE: {
                gameMode = OrtiMain.GameModes.ESCAPE_CLAUSTRO;
                break;
            }
            case VERY_CLAUSTRO_INFINITE: {
                gameMode = OrtiMain.GameModes.INFINITE_VERY_CLAUSTRO;
                break;
            }
            case VERY_CLAUSTRO_ESCAPE: {
                gameMode = OrtiMain.GameModes.ESCAPE_VERY_CLAUSTRO;
                break;
            }
            case TWO_PLAYERS: {
                gameMode = OrtiMain.GameModes.TWO_PLAYERS;
                selectedCharacter2 = ((NewGameMenuController)this.getGameState().getMainMenuController().getSelectedMenu()).getSelectedCharacter2();
                selectedGadget2 = ((NewGameMenuController)this.getGameState().getMainMenuController().getSelectedMenu()).getSelectedGadget2();
            }
        }
        this.startNewGame(gameMode, gameType, selectedGadget, selectedObjectModifier, selectedCharacter, selectedGadget2, selectedCharacter2, this.getGameState().getControllerPlayerController(1), this.getGameState().getControllerPlayerController(2));
    }

    private void unProjectCoordinatesGui() {
        World.getCameraController().getGuiCam().unproject(this.touchPoint.set(Gdx.input.getX(), Gdx.input.getY(), 0.0f), World.getCameraController().getViewPortGui().getScreenX(), World.getCameraController().getViewPortGui().getScreenY(), World.getCameraController().getViewPortGui().getScreenWidth(), World.getCameraController().getViewPortGui().getScreenHeight());
    }

    private void updateMouseCoordinates() {
        World.mousePos.x = Gdx.input.getX();
        World.mousePos.y = Gdx.input.getY();
        World.mousePos.z = 0.0f;
        cameraController.getGuiCam().unproject(mousePos);
    }

    private void drawIntro() {
        this.resetFrameDraw();
        cameraController.getGuiCam().update();
        this.introController.draw();
    }

    public void draw() {
        this.resetFrameDraw();
        cameraController.getGuiCam().update();
        if (!this.getGameState().isShowGeneralMenu()) {
            cameraController.getUsedMapCam().update();
            this.guiController.drawFullBackground();
            this.tileManager.draw(this.getGameState().getTutorialShow());
            this.textureDrawController.drawAll(World.getDeltaTime(), this.getGameState().getBlockController());
            this.guiController.updateGUI(this.touchPoint);
            this.guiController.drawGui();
            this.particleDrawController.drawParticles();
            this.placeableDrawController.drawPlayer(this.getGameState().getPlayerController());
            if (this.getGameState().getGameMode() == OrtiMain.GameModes.TWO_PLAYERS) {
                this.placeableDrawController.drawPlayer(this.getGameState().getPlayerController2());
            }
            if (this.getGameState().getCurrentMenu() == GameState.Menu.INGAME_MENU || this.getGameState().getCurrentMenu() == GameState.Menu.INGAME_MENU_GAME_OVER) {
                this.getGameState().drawMenu();
            }
        } else {
            this.getGameState().getMainMenuController().draw();
        }
        if (showFps) {
            this.fpsLogger.log();
        }
    }

    private void resetFrameDraw() {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16640);
    }

    @Override
    public void pause() {
        super.pause();
    }

    @Override
    public void hide() {
        super.hide();
    }

    @Override
    public void resume() {
        Assets.dispose();
        Assets.load();
        if (this.introController != null) {
            this.introController.reloadTextures();
        }
        if (this.gameState.isShowGeneralMenu()) {
            Assets.menuMusic();
        } else {
            Assets.gameMusic();
        }
        super.resume();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void shutDownThreads() {
    }

    public void calculateOnLoad() {
    }

    public static boolean resetCloseCommand() {
        if (closeCommand) {
            closeCommand = false;
            return true;
        }
        return false;
    }

    public void exitGame() {
        this.getGameState().setExiting();
    }

    public void restartGame() {
        this.getGameState().setRestarting();
    }

    public void restartGameAgain() {
        this.getGameState().setRestartingGame();
    }

    public void finishIntro() {
        this.game.setShowIntro(false);
        this.introController = null;
    }

    static {
        debug = false;
        showFps = false;
        latestDelta = 0.0f;
        mousePos = new Vector3();
    }
}

