/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.stateControls;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector3;
import com.ortisoft.ortilator.OrtiMain;
import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.controllers.AbstractHandling;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.BlockController;
import com.ortisoft.ortilator.controllers.MapController;
import com.ortisoft.ortilator.controllers.PlayerController;
import com.ortisoft.ortilator.controllers.menu.IngameEndGameMenuController;
import com.ortisoft.ortilator.controllers.menu.IngameMenuController;
import com.ortisoft.ortilator.controllers.menu.MainMenuController;
import com.ortisoft.ortilator.controllers.menu.NewGameMenuController;
import com.ortisoft.ortilator.entities.AbstractActualPlaceable;
import com.ortisoft.ortilator.entities.ICharacter;
import com.ortisoft.ortilator.entities.IGadget;
import com.ortisoft.ortilator.entities.IObjectModifiers;
import com.ortisoft.ortilator.entities.blocks.ActualBlock;
import com.ortisoft.ortilator.world.World;
import com.ortisoft.ortilator.world.loaders.BlockLoader;
import java.util.Map;

public class GameState {
    private TutoSteps currentTutoSteps;
    private boolean exiting;
    private boolean restarting;
    private boolean restartingGame;
    private boolean gameOver;
    private boolean ignoreNextTouchMovement = false;
    private float totalTimeGameOver = 0.0f;
    private double totalTime = 0.0;
    private int currentLevel = 0;
    private long currentLevelBlocks = 0L;
    private OrtiMain.GameModes gameMode;
    private NewGameMenuController.Type gameType = NewGameMenuController.Type.EXTENDED;
    private boolean showHighScore;
    private IngameMenuController ingameMenuController;
    private IngameEndGameMenuController ingameEndGameMenuController;
    private boolean escape = false;
    private long totalEscapeTime;
    private boolean showIntro = true;
    private IGadget selectedGadget;
    private IObjectModifiers selectedObjectModifier;
    private ICharacter selectedCharacter;
    private boolean player1Crushed;
    private boolean player2Crushed;
    private IGadget selectedGadget2;
    private ICharacter selectedCharacter2;
    private boolean tutorialShow;
    private Menu currentMenu = Menu.GAME;
    private Menu latestMenu = null;
    private PlayerController playerController;
    private PlayerController playerController2;
    public BlockController blockController;
    private boolean showGeneralMenu = false;
    private MainMenuController mainMenuController;
    public World worldReference;

    public OrtiMain.GameModes getGameMode() {
        return this.gameMode;
    }

    public TutoSteps getCurrentTutoSteps() {
        return this.currentTutoSteps;
    }

    public NewGameMenuController.Type getGameType() {
        return this.gameType;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public boolean isPlayer1Crushed() {
        return this.player1Crushed;
    }

    public boolean isPlayer2Crushed() {
        return this.player2Crushed;
    }

    public boolean isShowHighScore() {
        return this.showHighScore;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public BlockController getBlockController() {
        return this.blockController;
    }

    public IGadget getSelectedGadget() {
        return this.selectedGadget;
    }

    public ICharacter getSelectedCharacter() {
        return this.selectedCharacter;
    }

    public IGadget getSelectedGadget2() {
        return this.selectedGadget2;
    }

    public ICharacter getSelectedCharacter2() {
        return this.selectedCharacter2;
    }

    public Object getControllerPlayerController(int numPlayer) {
        if (numPlayer == 1 && this.playerController != null) {
            return this.playerController.getControllerNameTwoPlayers();
        }
        if (numPlayer == 2 && this.playerController2 != null) {
            return this.playerController2.getControllerNameTwoPlayers();
        }
        return null;
    }

    public IObjectModifiers getSelectedObjectModifier() {
        return this.selectedObjectModifier;
    }

    public long getTotalEscapeTime() {
        return this.totalEscapeTime;
    }

    public boolean isShowIntro() {
        return this.showIntro;
    }

    public IngameMenuController getIngameMenuController() {
        return this.ingameMenuController;
    }

    public IngameEndGameMenuController getIngameEndGameMenuController() {
        return this.ingameEndGameMenuController;
    }

    public boolean isIgnoreNextTouchMovement() {
        return this.ignoreNextTouchMovement;
    }

    public void resetIgnoreNextTouchMovement() {
        this.ignoreNextTouchMovement = false;
    }

    public void setTutorialShow() {
        this.tutorialShow = true;
        this.currentTutoSteps = TutoSteps.START;
    }

    public boolean getTutorialShow() {
        return this.tutorialShow;
    }

    public boolean isShowGeneralMenu() {
        return this.showGeneralMenu;
    }

    public void setShowGeneralMenu() {
        this.showGeneralMenu = true;
        Assets.menuMusic();
    }

    public void unSetShowGeneralMenu() {
        this.showGeneralMenu = false;
    }

    public PlayerController getPlayerController() {
        return this.playerController;
    }

    public PlayerController getPlayerController2() {
        return this.playerController2;
    }

    public MainMenuController getMainMenuController() {
        return this.mainMenuController;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public long getNumFallenBlocks() {
        return MapController.getNumberOfCreatedBlocks();
    }

    public Menu getCurrentMenu() {
        return this.currentMenu;
    }

    public GameState(World world) {
        this.worldReference = world;
    }

    public void createMainMenu(AbstractHandling camera, World world) {
        if (this.mainMenuController == null) {
            this.mainMenuController = new MainMenuController(camera, world);
        }
    }

    public void createInGameMenu(AbstractHandling camera) {
        this.ingameMenuController = new IngameMenuController(camera, this.currentTutoSteps != null);
        this.changeMenu(Menu.INGAME_MENU);
    }

    public void startGame(boolean isMobile, OrtiMain.GameModes gameMode, NewGameMenuController.Type gameType, IGadget selectedGadget, IObjectModifiers selectedObjectModifier, ICharacter selectedCharacter) {
        this.restartingGame = false;
        MapController.setGameType(gameType);
        this.gameType = gameType;
        this.gameMode = gameMode;
        this.selectedGadget = selectedGadget;
        this.selectedObjectModifier = selectedObjectModifier;
        this.selectedCharacter = selectedCharacter;
        this.blockController = new BlockController(gameMode);
        this.playerController = new PlayerController(Math.round((float)AbstractMapController.getMAP_WIDTH() / 2.0f), 1, selectedGadget, selectedCharacter, 3, 1, null);
        this.playerController2 = null;
        MapController.movementTime = 0.12f;
        MapController.movementPushTime = 0.195f;
        if (gameType == NewGameMenuController.Type.EXTENDED) {
            this.applyModifiers(selectedObjectModifier);
        }
        MapController.setPlayerController(this.playerController, this.playerController2);
        this.loadLeaderBoard(gameType == NewGameMenuController.Type.EXTENDED, gameMode);
        this.hideMouse();
    }

    private void loadLeaderBoard(boolean isExtended, OrtiMain.GameModes gameMode) {
        if (gameMode == OrtiMain.GameModes.TWO_PLAYERS || gameMode == OrtiMain.GameModes.TUTORIAL) {
            return;
        }
        switch (gameMode) {
            case ESCAPE: 
            case ESCAPE_CLAUSTRO: 
            case ESCAPE_VERY_CLAUSTRO: {
                if (isExtended) {
                    OrtiMain.loadLeaderBoard("Extended Escape");
                    break;
                }
                OrtiMain.loadLeaderBoard("Classic Escape");
                break;
            }
            case INFINITE: 
            case INFINITE_CLAUSTRO: 
            case INFINITE_VERY_CLAUSTRO: {
                if (isExtended) {
                    OrtiMain.loadLeaderBoard("Extended Infinite");
                    break;
                }
                OrtiMain.loadLeaderBoard("Classic Infinite");
            }
        }
    }

    public void resetPlayerControllersForTwoPlayers() {
        this.playerController = new PlayerController(1);
        this.playerController2 = new PlayerController(2);
    }

    public void startGameTwoPlayerGame(IGadget selectedGadget, ICharacter selectedCharacter, IGadget selectedGadget2, ICharacter selectedCharacter2, Object controller1, Object controller2) {
        this.restartingGame = false;
        MapController.setGameType(this.gameType);
        this.gameType = NewGameMenuController.Type.EXTENDED;
        this.gameMode = OrtiMain.GameModes.TWO_PLAYERS;
        this.selectedGadget = selectedGadget;
        this.selectedObjectModifier = null;
        this.selectedCharacter = selectedCharacter;
        this.selectedCharacter2 = selectedCharacter2;
        this.selectedGadget2 = selectedGadget2;
        this.blockController = new BlockController(this.gameMode);
        this.playerController = new PlayerController(Math.round((float)AbstractMapController.getMAP_WIDTH() / 4.0f), 1, selectedGadget, selectedCharacter, 3, 1, controller1);
        this.playerController2 = new PlayerController(Math.round((float)AbstractMapController.getMAP_WIDTH() / 1.5f), 1, selectedGadget2, selectedCharacter2, 3, 2, controller2);
        MapController.movementTime = 0.12f;
        MapController.movementPushTime = 0.195f;
        MapController.setPlayerController(this.playerController, this.playerController2);
        this.hideMouse();
    }

    public void hideMouse() {
        Gdx.input.setCursorPosition(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    private void applyModifiers(IObjectModifiers iObjectModifiers) {
        if (iObjectModifiers == null) {
            return;
        }
        for (Map.Entry<IObjectModifiers.Modifier, Integer> modifier : iObjectModifiers.returnModifiers().entrySet()) {
            switch (modifier.getKey()) {
                case PUSH_SPEED: {
                    MapController.movementPushTime += MapController.movementPushTime * (float)modifier.getValue().intValue() / 100.0f;
                    break;
                }
                case MOVEMENT_SPEED: {
                    MapController.movementTime += MapController.movementTime * (float)modifier.getValue().intValue() / 100.0f;
                    break;
                }
                case SLOWER_BLOCKS: {
                    this.blockController.setModifierSpeed((float)modifier.getValue().intValue() / 1000.0f);
                }
            }
        }
    }

    public double getTotalTime() {
        return this.totalTime;
    }

    public void setRestarting() {
        this.restarting = true;
    }

    public void setRestartingGame() {
        this.restartingGame = true;
        this.tutorialShow = false;
    }

    public void updateGenericRender(float delta) {
        this.totalTime += (double)delta;
    }

    public boolean isExiting() {
        return this.exiting;
    }

    public void setExiting() {
        this.exiting = true;
    }

    public boolean isRestarting() {
        return this.restarting;
    }

    public boolean isRestartingGame() {
        return this.restartingGame;
    }

    public void drawMenu() {
        switch (this.currentMenu) {
            case INGAME_MENU: {
                this.ingameMenuController.drawMenuGui();
                break;
            }
            case INGAME_MENU_GAME_OVER: {
                this.ingameEndGameMenuController.drawMenuGui();
            }
        }
    }

    public void closeGeneralMenu() {
        this.unSetShowGeneralMenu();
    }

    public void updateRender(float delta, Vector3 touchPoint) {
        this.updateGame(touchPoint, delta);
    }

    private void updateGameOver(float delta) {
        this.totalTimeGameOver += delta;
        if (this.totalTimeGameOver > 2.0f && this.gameMode != OrtiMain.GameModes.TWO_PLAYERS || this.totalTimeGameOver > 5.0f && this.gameMode == OrtiMain.GameModes.TWO_PLAYERS) {
            int victoryPlayer = 0;
            if (!(this.gameMode != OrtiMain.GameModes.TWO_PLAYERS || this.isPlayer1Crushed() && this.isPlayer2Crushed())) {
                if (this.isPlayer1Crushed()) {
                    victoryPlayer = 2;
                }
                if (this.isPlayer2Crushed()) {
                    victoryPlayer = 1;
                }
            }
            this.ingameEndGameMenuController = new IngameEndGameMenuController(World.getCameraController(), this.getGameType() == NewGameMenuController.Type.EXTENDED, this.getGameMode(), OrtiMain.getLatestScore(), this.showHighScore, victoryPlayer);
            this.changeMenu(Menu.INGAME_MENU_GAME_OVER);
        }
    }

    private void updateGame(Vector3 touchPoint, float delta) {
        this.updateMenus(touchPoint);
        if (this.currentMenu == Menu.GAME && !this.isRestarting() && !this.isRestartingGame()) {
            this.updateGenericRender(World.getDeltaTime());
            if (this.tutorialShow) {
                this.updateTutorial(touchPoint, delta);
            } else {
                if (this.showIntro && this.totalTime > 4.0) {
                    this.showIntro = false;
                }
                this.blockController.checkBlocksMovement();
                this.blockController.checkDestroyed();
                if (!this.gameOver) {
                    int numberOfBlocksPerLevelMultiplier = 1;
                    if (this.gameMode == OrtiMain.GameModes.TWO_PLAYERS) {
                        numberOfBlocksPerLevelMultiplier = 2;
                    }
                    if (MapController.getNumberOfCreatedBlocks() != this.currentLevelBlocks && MapController.getNumberOfCreatedBlocks() % (long)(20 * numberOfBlocksPerLevelMultiplier) == 0L) {
                        Assets.selectRandomBackground();
                        ++this.currentLevel;
                        this.checkUnlockLevelAchievementLevel();
                        this.currentLevelBlocks = MapController.getNumberOfCreatedBlocks();
                        Assets.sound(Assets.Sounds.BLEEP);
                    }
                    this.blockController.checkCreationBlock(this.currentLevel, this.gameMode == OrtiMain.GameModes.TWO_PLAYERS);
                    if (this.gameMode != OrtiMain.GameModes.TWO_PLAYERS) {
                        if (this.blockController.checkGameConditions(this.getPlayerController(), delta)) {
                            this.unlockAchievementVictory();
                            this.escape = true;
                            this.totalEscapeTime = Math.round(this.totalTime);
                            this.showHighScore = OrtiMain.checkGameScore(this.gameMode, this.gameType, Math.round(this.totalTime));
                            this.setGameOver();
                        }
                    } else {
                        this.blockController.checkGameConditions(this.getPlayerController(), delta);
                        this.blockController.checkGameConditions(this.getPlayerController2(), delta);
                    }
                    this.updateMovement();
                } else {
                    this.updateGameOver(delta);
                }
            }
        }
    }

    private void updateTutorial(Vector3 touchPoint, float delta) {
        switch (this.currentTutoSteps) {
            case START: {
                ActualBlock tutoBlock;
                MapController.getActualBlocks()[2][1] = tutoBlock = new ActualBlock(-10, 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, BlockLoader.allBlocks.get(1));
                MapController.getBlocks().put(tutoBlock.getId(), tutoBlock);
                this.playerController.setPosition(2.0f, 2.0f);
                this.playerController.refreshLatestCompletePosition();
                this.playerController.setTutoGadet();
                this.currentTutoSteps = TutoSteps.TAP_LEFT;
                this.showIntro = false;
                break;
            }
            case TAP_LEFT: {
                if (this.playerController.isFacingRight() || this.playerController.getCurrentMovementType() != AbstractActualPlaceable.MovementType.NORMAL && this.playerController.getCurrentMovementType() != AbstractActualPlaceable.MovementType.JUMP_DOWN && this.playerController.getCurrentMovementType() != AbstractActualPlaceable.MovementType.JUMP_UP) break;
                this.currentTutoSteps = TutoSteps.SWIPE_LEFT_RIGHT;
                break;
            }
            case SWIPE_LEFT_RIGHT: {
                if (!this.playerController.isFacingRight() || this.playerController.getCurrentMovementType() != AbstractActualPlaceable.MovementType.PUSH) break;
                this.currentTutoSteps = TutoSteps.SWIPE_LEFT_LEFT;
                break;
            }
            case SWIPE_LEFT_LEFT: {
                if (!this.playerController.isFacingRight() || this.playerController.getCurrentMovementType() != AbstractActualPlaceable.MovementType.PULL) break;
                this.currentTutoSteps = TutoSteps.TAP_RIGHT;
                break;
            }
            case TAP_RIGHT: {
                if (!this.playerController.isFacingRight() || this.playerController.getLatestCompleteX() != 2.0f || this.playerController.getCurrentMovementType() != AbstractActualPlaceable.MovementType.NORMAL && this.playerController.getCurrentMovementType() != AbstractActualPlaceable.MovementType.JUMP_DOWN && this.playerController.getCurrentMovementType() != AbstractActualPlaceable.MovementType.JUMP_UP) break;
                this.currentTutoSteps = TutoSteps.SWIPE_RIGHT_LEFT;
                break;
            }
            case SWIPE_RIGHT_LEFT: {
                if (this.playerController.isFacingRight() || this.playerController.getCurrentMovementType() != AbstractActualPlaceable.MovementType.PUSH) break;
                this.currentTutoSteps = TutoSteps.SWIPE_RIGHT_RIGHT;
                break;
            }
            case SWIPE_RIGHT_RIGHT: {
                if (this.playerController.isFacingRight() || this.playerController.getCurrentMovementType() != AbstractActualPlaceable.MovementType.PULL) break;
                this.currentTutoSteps = TutoSteps.EXTENDED_MODE_GADGET;
                break;
            }
            case EXTENDED_MODE_GADGET: {
                if (this.playerController.getCurrentMovementType() != AbstractActualPlaceable.MovementType.JUMP_FOR_BLOCK) break;
                this.currentTutoSteps = TutoSteps.FINISH;
            }
        }
        this.blockController.checkBlocksMovement();
        this.updateMovement();
    }

    private void unlockAchievementVictory() {
        switch (this.getGameMode()) {
            case ESCAPE: {
                if (this.getGameType() == NewGameMenuController.Type.EXTENDED) {
                    OrtiMain.unlockAchievement("STAYING_ALIVE_WITH_STYLE");
                    break;
                }
                OrtiMain.unlockAchievement("STAYING_ALIVE");
                break;
            }
            case ESCAPE_CLAUSTRO: {
                if (this.getGameType() == NewGameMenuController.Type.EXTENDED) {
                    OrtiMain.unlockAchievement("WANT_YOU_GONE");
                    break;
                }
                OrtiMain.unlockAchievement("STILL_ALIVE");
                break;
            }
            case ESCAPE_VERY_CLAUSTRO: {
                if (this.getGameType() == NewGameMenuController.Type.EXTENDED) {
                    OrtiMain.unlockAchievement("I_WANT_TO_SEE_THAT");
                    break;
                }
                OrtiMain.unlockAchievement("IMPRESSIVE");
            }
        }
    }

    private void checkUnlockLevelAchievementLevel() {
        switch (this.getGameMode()) {
            case INFINITE: {
                if (this.getGameType() == NewGameMenuController.Type.EXTENDED) {
                    if (this.getCurrentLevel() != 10) break;
                    OrtiMain.unlockAchievement("RIDING_THE_CAT");
                    break;
                }
                if (this.getCurrentLevel() != 8) break;
                OrtiMain.unlockAchievement("IT_SHOULD_BE_EASY");
                break;
            }
            case INFINITE_CLAUSTRO: {
                if (this.getGameType() == NewGameMenuController.Type.EXTENDED) {
                    if (this.getCurrentLevel() != 10) break;
                    OrtiMain.unlockAchievement("RIDING_THE_WAVES");
                    break;
                }
                if (this.getCurrentLevel() != 8) break;
                OrtiMain.unlockAchievement("HATERS_GONNA_HATE");
                break;
            }
            case INFINITE_VERY_CLAUSTRO: {
                if (this.getGameType() == NewGameMenuController.Type.EXTENDED) {
                    if (this.getCurrentLevel() != 10) break;
                    OrtiMain.unlockAchievement("RIDING_THE_DRAGON");
                    break;
                }
                if (this.getCurrentLevel() != 8) break;
                OrtiMain.unlockAchievement("JUMP_PUSH_REPEAT");
            }
        }
    }

    private void updateMovement() {
        this.getPlayerController().checkMovement();
        if (this.playerController2 != null) {
            this.playerController2.checkMovement();
        }
        this.player1Crushed = this.blockController.checkPlayerCollision(this.getPlayerController());
        boolean bl = this.player2Crushed = this.getPlayerController2() != null && this.blockController.checkPlayerCollision(this.getPlayerController2());
        if (this.player1Crushed || this.player2Crushed) {
            this.totalTimeGameOver = 0.0f;
            if (this.gameMode != OrtiMain.GameModes.TWO_PLAYERS) {
                if (this.gameMode == OrtiMain.GameModes.INFINITE_CLAUSTRO || this.gameMode == OrtiMain.GameModes.INFINITE || this.gameMode == OrtiMain.GameModes.INFINITE_VERY_CLAUSTRO) {
                    this.showHighScore = OrtiMain.checkGameScore(this.gameMode, this.gameType, MapController.getNumberOfCreatedBlocks());
                } else {
                    OrtiMain.resetLatestHighScore();
                }
                this.totalEscapeTime = Math.round(this.totalTime);
                this.setGameOver();
                this.worldReference.getTextureDrawController().addToPlayAtlasAnimation("smoke", Float.valueOf(0.05f), (int)this.getPlayerController().getPositionX(), (int)this.getPlayerController().getPositionY(), 1.0f, 1.0f);
                this.getPlayerController().setPosition(-50.0f, 0.0f);
            } else {
                this.gameOver = true;
                this.playerController.getCharacter().setCurrentAnimation("idle");
                this.playerController2.getCharacter().setCurrentAnimation("idle");
                if (this.player1Crushed) {
                    this.worldReference.getTextureDrawController().addToPlayAtlasAnimation("smoke", Float.valueOf(0.05f), (int)this.getPlayerController().getPositionX(), (int)this.getPlayerController().getPositionY(), 1.0f, 1.0f);
                    this.getPlayerController().setPosition(-50.0f, 0.0f);
                }
                if (this.player2Crushed) {
                    this.worldReference.getTextureDrawController().addToPlayAtlasAnimation("smoke", Float.valueOf(0.05f), (int)this.getPlayerController2().getPositionX(), (int)this.getPlayerController2().getPositionY(), 1.0f, 1.0f);
                    this.getPlayerController2().setPosition(-50.0f, 0.0f);
                }
            }
        }
    }

    private void setGameOver() {
        this.gameOver = true;
        OrtiMain.saveGame();
    }

    private void updateMap(Vector3 touchPoint) {
    }

    public void moveCorrectMenu(int column, int line) {
        if (this.isShowGeneralMenu()) {
            this.mainMenuController.moveCorrectMenu(column, line);
        } else if (this.currentMenu == Menu.INGAME_MENU) {
            this.ingameMenuController.moveMenu(column, line);
        } else if (this.currentMenu == Menu.INGAME_MENU_GAME_OVER) {
            this.ingameEndGameMenuController.moveMenu(column, line);
        }
    }

    public void selectCorrectMenu() {
        if (this.currentMenu == Menu.INGAME_MENU) {
            this.ingameMenuController.selectMenu();
        } else if (this.currentMenu == Menu.INGAME_MENU_GAME_OVER) {
            this.ingameEndGameMenuController.selectMenu();
        } else if (this.isShowGeneralMenu()) {
            this.mainMenuController.selectMenu();
        }
    }

    private void updateMenus(Vector3 touchPoint) {
        switch (this.currentMenu) {
            case GAME: {
                this.updateMap(touchPoint);
                break;
            }
            case INGAME_MENU: {
                if (!this.checkInGameMenu() || !Gdx.input.justTouched()) break;
                this.ingameMenuController.updateMenu(touchPoint);
                this.checkInGameMenu();
                break;
            }
            case INGAME_MENU_GAME_OVER: {
                if (!this.checkInGameMenuGameOver() || !Gdx.input.justTouched()) break;
                this.ingameEndGameMenuController.updateMenu(touchPoint);
                this.checkInGameMenuGameOver();
            }
        }
    }

    private boolean checkInGameMenuGameOver() {
        if (this.ingameEndGameMenuController.isClosed()) {
            switch (this.ingameEndGameMenuController.getLatestMenu()) {
                case EXIT: {
                    this.worldReference.restartGame();
                    break;
                }
                case RESTART: {
                    this.worldReference.restartGameAgain();
                }
            }
            this.ingameEndGameMenuController = null;
            this.changeMenu(Menu.GAME);
            this.ignoreNextTouchMovement = true;
            return false;
        }
        return true;
    }

    private boolean checkInGameMenu() {
        if (this.ingameMenuController.isClosed()) {
            switch (this.ingameMenuController.getLatestMenu()) {
                case EXIT: {
                    this.worldReference.restartGame();
                    break;
                }
                case RESTART: {
                    this.worldReference.restartGameAgain();
                    break;
                }
                case EXIT_TUTO: {
                    if (this.getGameMode() == OrtiMain.GameModes.TUTORIAL) {
                        this.worldReference.restartGame();
                        break;
                    }
                    this.worldReference.restartGameAgain();
                }
            }
            this.ingameMenuController = null;
            this.changeMenu(Menu.GAME);
            return false;
        }
        return true;
    }

    private void changeMenu(Menu menu) {
        this.currentMenu = menu;
    }

    public static enum Menu {
        GAME(1),
        INGAME_MENU(2),
        INGAME_MENU_GAME_OVER(3);

        private final int value;

        public int getValue() {
            return this.value;
        }

        private Menu(int value) {
            this.value = value;
        }
    }

    public static enum TutoSteps {
        START,
        INTRO,
        TAP_LEFT,
        TAP_RIGHT,
        SWIPE_LEFT_LEFT,
        SWIPE_LEFT_RIGHT,
        SWIPE_RIGHT_RIGHT,
        SWIPE_RIGHT_LEFT,
        EXTENDED_MODE_GADGET,
        FINISH;

    }
}

