/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.entities.gadgets;

import com.ortisoft.ortilator.assets.ISDLocale;
import com.ortisoft.ortilator.controllers.MapController;
import com.ortisoft.ortilator.controllers.PlayerController;
import com.ortisoft.ortilator.entities.IGadget;
import com.ortisoft.ortilator.world.loaders.BlockLoader;

public class ExplodingBlock
implements IGadget {
    private int id;
    private String name;
    private String texture;
    private String desc;

    public ExplodingBlock(int id, String name, String desc, String texture) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.texture = texture;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return ISDLocale.LocaleInUse(this.name);
    }

    @Override
    public String getDesc() {
        return ISDLocale.LocaleInUse(this.desc);
    }

    @Override
    public String getTexture() {
        return this.texture;
    }

    @Override
    public IGadget.Type getType() {
        return IGadget.Type.SUMMON_PURPLE_BLOCK;
    }

    @Override
    public boolean isValidToUse(PlayerController playerInUse) {
        return MapController.playerIsNotInFrontOfABlock(playerInUse);
    }

    @Override
    public void onUse(PlayerController playerInUse) {
        if (playerInUse.isFacingRight()) {
            MapController.insertBlockFromPlayer(playerInUse, MapController.BlockPlacementFromPlayer.RIGHT, BlockLoader.allBlocks.get(5), playerInUse.getControllerNameTwoPlayers() != null);
        } else {
            MapController.insertBlockFromPlayer(playerInUse, MapController.BlockPlacementFromPlayer.LEFT, BlockLoader.allBlocks.get(5), playerInUse.getControllerNameTwoPlayers() != null);
        }
    }
}

