/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.entities.gadgets;

import com.ortisoft.ortilator.assets.ISDLocale;
import com.ortisoft.ortilator.controllers.MapController;
import com.ortisoft.ortilator.controllers.PlayerController;
import com.ortisoft.ortilator.entities.AbstractActualPlaceable;
import com.ortisoft.ortilator.entities.IGadget;

public class Drill
implements IGadget {
    private int id;
    private String name;
    private String texture;
    private String desc;

    public Drill(int id, String name, String desc, String texture) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.texture = texture;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return ISDLocale.LocaleInUse(this.name);
    }

    @Override
    public String getDesc() {
        return ISDLocale.LocaleInUse(this.desc);
    }

    @Override
    public String getTexture() {
        return this.texture;
    }

    @Override
    public IGadget.Type getType() {
        return IGadget.Type.DRILL;
    }

    @Override
    public boolean isValidToUse(PlayerController playerInUse) {
        return MapController.playerIsInFrontOfBlock(playerInUse);
    }

    @Override
    public void onUse(PlayerController playerInUse) {
        playerInUse.setMoving(AbstractActualPlaceable.MovementType.HIT_BLOCK);
    }
}

