/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.entities.gadgets;

import com.ortisoft.ortilator.assets.ISDLocale;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.MapController;
import com.ortisoft.ortilator.controllers.PlayerController;
import com.ortisoft.ortilator.entities.IGadget;
import com.ortisoft.ortilator.entities.blocks.ActualBlock;
import com.ortisoft.ortilator.world.RandomSeed;
import java.util.ArrayList;

public class Artillery
implements IGadget {
    private int id;
    private String name;
    private String texture;
    private String desc;
    private ArrayList<ActualBlock> auxList = new ArrayList();

    public Artillery(int id, String name, String desc, String texture) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.texture = texture;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return ISDLocale.LocaleInUse(this.name);
    }

    @Override
    public String getDesc() {
        return ISDLocale.LocaleInUse(this.desc);
    }

    @Override
    public String getTexture() {
        return this.texture;
    }

    @Override
    public IGadget.Type getType() {
        return IGadget.Type.ARTILLERY;
    }

    @Override
    public boolean isValidToUse(PlayerController playerInUse) {
        return true;
    }

    @Override
    public void onUse(PlayerController playerInUse) {
        if (AbstractMapController.getMAP_WIDTH() == 17) {
            int colMax;
            int colInit;
            if (playerInUse.getNumPlayer() == 1) {
                colInit = 1;
                colMax = (int)Math.floor(8.0);
            } else {
                colInit = (int)Math.floor(8.0) + 2;
                colMax = AbstractMapController.getMAP_WIDTH();
            }
            for (int col = colInit; col <= colMax; ++col) {
                if (RandomSeed.getRan().nextInt(10) < 5) continue;
                this.addBlockToDestroy(col);
            }
        } else {
            for (int col = 1; col <= AbstractMapController.getMAP_WIDTH(); ++col) {
                if (RandomSeed.getRan().nextInt(10) < 5) continue;
                this.addBlockToDestroy(col);
            }
        }
    }

    private void addBlockToDestroy(int col) {
        this.auxList.clear();
        for (int line = 1; line < AbstractMapController.getMAP_HEIGHT(); ++line) {
            if (MapController.getActualBlocks()[col][line] == null) continue;
            this.auxList.add(MapController.getActualBlocks()[col][line]);
        }
        if (this.auxList.size() > 0) {
            MapController.getDestroyBlocks().add(this.auxList.get(RandomSeed.getRan().nextInt(this.auxList.size())));
        }
    }
}

