/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.entities.characters;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.ortisoft.ortilator.assets.ISDLocale;
import com.ortisoft.ortilator.entities.ICharacter;
import java.util.HashMap;

public class Cat
implements ICharacter {
    private int id;
    private static TextureAtlas player;
    private String name;
    private String desc;
    private String atlas;
    private Animation currentAnimation;
    private float timeAnimation = 0.0f;
    public static HashMap<String, Animation<TextureRegion>> playerAnimations;

    public Cat(int id, String name, String desc, String atlas) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.atlas = atlas;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return ISDLocale.LocaleInUse(this.name);
    }

    @Override
    public String getDesc() {
        return ISDLocale.LocaleInUse(this.desc);
    }

    @Override
    public String getAtlas() {
        return this.atlas;
    }

    @Override
    public void reloadAtlas() {
        player = new TextureAtlas(Gdx.files.internal("data/Game/" + this.atlas + ".atlas"));
        playerAnimations = new HashMap();
        playerAnimations.put("idle", new Animation<TextureAtlas.AtlasRegion>(0.1f, player.findRegions("idle"), Animation.PlayMode.LOOP));
        playerAnimations.put("moving", new Animation<TextureAtlas.AtlasRegion>(0.024f, player.findRegions("moving"), Animation.PlayMode.LOOP));
        playerAnimations.put("push", new Animation<TextureAtlas.AtlasRegion>(0.038999997f, player.findRegions("push"), Animation.PlayMode.LOOP));
        playerAnimations.put("pull", new Animation<TextureAtlas.AtlasRegion>(0.038999997f, player.findRegions("pull"), Animation.PlayMode.LOOP));
        playerAnimations.put("fall", new Animation<TextureAtlas.AtlasRegion>(0.0975f, player.findRegions("fall"), Animation.PlayMode.LOOP));
        playerAnimations.put("jump", new Animation<TextureAtlas.AtlasRegion>(0.0975f, player.findRegions("jump"), Animation.PlayMode.NORMAL));
        this.setCurrentAnimation("idle");
    }

    @Override
    public Animation getCurrentAnimation() {
        return this.currentAnimation;
    }

    @Override
    public float getTimeAnimation() {
        return this.timeAnimation;
    }

    @Override
    public void setCurrentAnimation(String animationName) {
        this.currentAnimation = playerAnimations.get(animationName);
    }

    @Override
    public void setTimeAnimation(float timeAnimation) {
        this.timeAnimation = timeAnimation;
    }
}

