/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.entities.blocks;

import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.MapController;
import com.ortisoft.ortilator.entities.Block;
import com.ortisoft.ortilator.entities.blocks.AbstractTwoPlayerBlock;
import com.ortisoft.ortilator.entities.blocks.ActualBlock;
import com.ortisoft.ortilator.world.RandomSeed;
import java.util.ArrayList;

public class BrownBlock
extends AbstractTwoPlayerBlock {
    private ArrayList<ActualBlock> auxList = new ArrayList();

    public BrownBlock(int id, float positionX, float positionY, float positionZ, float width, float height, Block blockData, boolean isTwoPlayers) {
        super(id, positionX, positionY, positionZ, width, height, blockData, isTwoPlayers);
    }

    @Override
    protected void doSpecialCondition(ArrayList<ActualBlock> actualBlocks) {
        int colMax;
        int colInit;
        if (this.getPositionX() < 10.0f) {
            colInit = (int)Math.floor(8.0) + 2;
            colMax = AbstractMapController.getMAP_WIDTH();
            MapController.player1hasActivatedArtillery = true;
        } else {
            colInit = 1;
            colMax = (int)Math.floor(8.0);
            MapController.player2hasActivatedArtillery = true;
        }
        Assets.sound(Assets.Sounds.EXPLOSION);
        for (int col = colInit; col <= colMax; ++col) {
            if (RandomSeed.getRan().nextInt(10) < 5) continue;
            this.addBlockToDestroy(col);
        }
        for (ActualBlock block : actualBlocks) {
            MapController.addParticleEffect("TwoPlayers/brown", block.getPositionX(), block.getPositionY());
        }
    }

    private void addBlockToDestroy(int col) {
        this.auxList.clear();
        for (int line = 1; line < AbstractMapController.getMAP_HEIGHT(); ++line) {
            if (MapController.getActualBlocks()[col][line] == null) continue;
            this.auxList.add(MapController.getActualBlocks()[col][line]);
        }
        if (this.auxList.size() > 0) {
            MapController.getDestroyBlocks().add(this.auxList.get(RandomSeed.getRan().nextInt(this.auxList.size())));
        }
    }
}

