/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.entities.blocks;

import com.ortisoft.ortilator.assets.Assets;
import com.ortisoft.ortilator.controllers.AbstractMapController;
import com.ortisoft.ortilator.controllers.MapController;
import com.ortisoft.ortilator.controllers.PlayerController;
import com.ortisoft.ortilator.controllers.menu.NewGameMenuController;
import com.ortisoft.ortilator.entities.AbstractActualPlaceable;
import com.ortisoft.ortilator.entities.Block;
import com.ortisoft.ortilator.world.loaders.BlockLoader;

public class ActualBlock
extends AbstractActualPlaceable {
    private Block blockData;
    private PlayerController latestPlayer;
    protected boolean deactivatedEffect = false;
    private boolean changing = false;

    public Block getBlockData() {
        return this.blockData;
    }

    public boolean isDeactivatedEffect() {
        return this.deactivatedEffect;
    }

    public ActualBlock(int id, float positionX, float positionY, float positionZ, float width, float height, Block blockData) {
        super(id, positionX, positionY, positionZ, width, height, blockData.getTexture());
        this.blockData = blockData;
        this.currentMovementType = AbstractActualPlaceable.MovementType.NONE;
    }

    private boolean tileChanged() {
        if (this.currentMovementType == AbstractActualPlaceable.MovementType.FELL && MapController.getActualBlocks()[(int)this.getPositionX()][(int)this.latestCompleteY] != null && MapController.getActualBlocks()[(int)this.getPositionX()][(int)this.latestCompleteY].getId() == this.id) {
            if (MapController.getActualBlocks()[(int)this.getPositionX()][(int)this.latestCompleteY - 1] == null) {
                MapController.getActualBlocks()[(int)this.getPositionX()][(int)this.latestCompleteY - 1] = this;
            } else {
                return true;
            }
        }
        if (this.currentMovementType == AbstractActualPlaceable.MovementType.PUSH && MapController.getActualBlocks()[(int)this.latestCompleteX][(int)this.getPositionY()] != null && MapController.getActualBlocks()[(int)this.latestCompleteX][(int)this.getPositionY()].getId() == this.id) {
            if (MapController.getActualBlocks()[(int)this.latestCompleteX + this.currentXToGo][(int)this.getPositionY()] == null) {
                MapController.getActualBlocks()[(int)this.latestCompleteX + this.currentXToGo][(int)this.getPositionY()] = this;
            } else {
                return true;
            }
        }
        this.changing = true;
        return false;
    }

    public void setMoving(PlayerController latestPlayer, AbstractActualPlaceable.MovementType currentMovementType, int currentXToGo) {
        this.latestPlayer = latestPlayer;
        super.setMoving(currentMovementType, currentXToGo);
    }

    @Override
    protected void moveByMovementType() {
        switch (this.currentMovementType) {
            case NORMAL: {
                this.moveBlock((float)this.currentXToGo * (this.movementTime / MapController.movementTime), 0.0f);
                break;
            }
            case JUMP_DOWN: {
                this.moveBlock((float)this.currentXToGo * (this.movementTime / 0.195f), -1.0f * (this.movementTime / 0.195f));
                break;
            }
            case FELL: {
                this.moveBlock(0.0f, -1.0f * (this.movementTime / 0.195f));
                break;
            }
            case PUSH: {
                this.moveBlock((float)this.currentXToGo * (this.movementTime / MapController.movementPushTime), 0.0f);
                break;
            }
            case PULL: {
                this.moveBlock((float)this.currentXToGo * (this.movementTime / MapController.movementPushTime), 0.0f);
            }
        }
    }

    private void moveBlock(float movementX, float movementY) {
        boolean rollBackDueToPerfectTiming = false;
        this.setPosition(this.latestCompleteX + movementX, this.latestCompleteY + movementY);
        if (!this.changing) {
            if (movementY > 0.0f) {
                if (this.getPositionY() > this.latestCompleteY) {
                    rollBackDueToPerfectTiming = this.tileChanged();
                }
            } else if (this.getPositionY() < this.latestCompleteY) {
                rollBackDueToPerfectTiming = this.tileChanged();
            }
            if (movementX > 0.0f) {
                if (this.getPositionX() > this.latestCompleteX) {
                    rollBackDueToPerfectTiming = this.tileChanged();
                }
            } else if (this.getPositionX() < this.latestCompleteX) {
                rollBackDueToPerfectTiming = this.tileChanged();
            }
        }
        if (rollBackDueToPerfectTiming) {
            this.setPosition(this.latestCompleteX, this.latestCompleteY);
            if ((this.currentMovementType == AbstractActualPlaceable.MovementType.PULL || this.currentMovementType == AbstractActualPlaceable.MovementType.PUSH) && this.latestPlayer != null) {
                this.latestPlayer.rollBackStop();
            }
            this.latestMovementType = this.currentMovementType;
            this.stopMovement();
        }
    }

    @Override
    protected void checkSound(AbstractActualPlaceable.SoundType soundType) {
        switch (soundType) {
            case FELL_STOP: {
                Assets.sound(Assets.Sounds.FALLING_BLOCK);
            }
        }
    }

    @Override
    protected boolean checkMovementTimeType() {
        switch (this.currentMovementType) {
            case NORMAL: {
                return this.movementTime >= MapController.movementTime;
            }
            case JUMP_DOWN: {
                return this.movementTime >= 0.195f;
            }
            case FELL: {
                return this.movementTime >= 0.195f;
            }
            case PUSH: {
                return this.movementTime >= MapController.movementPushTime;
            }
            case PULL: {
                return this.movementTime >= MapController.movementPushTime;
            }
        }
        return true;
    }

    @Override
    protected void changeAnimation() {
        if (this.currentMovementType != AbstractActualPlaceable.MovementType.NONE && !MapController.getAuxMoving().contains(this)) {
            MapController.addMoving(this);
        }
    }

    @Override
    protected void onAnimationCheck() {
        if (this.currentMovementType == AbstractActualPlaceable.MovementType.NONE) {
            MapController.removeMoving(this);
        }
        if (this.latestMovementType == AbstractActualPlaceable.MovementType.FELL && this.latestCompleteY + 1.0f < (float)(AbstractMapController.getMAP_HEIGHT() + 1) && MapController.getActualBlocks()[(int)this.getPositionX()][(int)this.latestCompleteY + 1] != null && MapController.getActualBlocks()[(int)this.getPositionX()][(int)this.latestCompleteY + 1].getCurrentMovementType() == AbstractActualPlaceable.MovementType.NONE) {
            MapController.getActualBlocks()[(int)this.getPositionX()][(int)this.latestCompleteY + 1] = null;
            MapController.checkIfBlockShouldFall((int)this.getPositionX(), (int)this.latestCompleteY + 1);
            MapController.checkIfPlayerShouldFall(MapController.getPlayerController(1), (int)this.getPositionX(), (int)this.latestCompleteY + 1);
            MapController.checkIfPlayerShouldFall(MapController.getPlayerController(2), (int)this.getPositionX(), (int)this.latestCompleteY + 1);
        }
        if (this.currentMovementType == AbstractActualPlaceable.MovementType.FELL && this.latestCompleteY + 1.0f < (float)(AbstractMapController.getMAP_HEIGHT() + 1) && MapController.getActualBlocks()[(int)this.getPositionX()][(int)this.latestCompleteY + 1] != null && MapController.getActualBlocks()[(int)this.getPositionX()][(int)this.latestCompleteY + 1].getId() == this.id) {
            MapController.getActualBlocks()[(int)this.getPositionX()][(int)this.latestCompleteY + 1] = null;
            MapController.checkIfPlayerShouldFall(MapController.getPlayerController(1), (int)this.getPositionX(), (int)this.latestCompleteY + 1);
            MapController.checkIfPlayerShouldFall(MapController.getPlayerController(2), (int)this.getPositionX(), (int)this.latestCompleteY + 1);
            MapController.checkIfBlockShouldFall((int)this.getPositionX(), (int)this.latestCompleteY + 1);
        }
        if (this.currentMovementType != AbstractActualPlaceable.MovementType.FELL && this.currentXToGo != 0 && MapController.getActualBlocks()[(int)this.latestCompleteX - this.currentXToGo][(int)this.getPositionY()] != null && MapController.getActualBlocks()[(int)this.latestCompleteX - this.currentXToGo][(int)this.getPositionY()].getId() == this.id) {
            MapController.getActualBlocks()[(int)this.latestCompleteX - this.currentXToGo][(int)this.getPositionY()] = null;
            MapController.checkIfPlayerShouldFall(MapController.getPlayerController(1), (int)this.latestCompleteX - this.currentXToGo, (int)this.getPositionY());
            MapController.checkIfPlayerShouldFall(MapController.getPlayerController(2), (int)this.latestCompleteX - this.currentXToGo, (int)this.getPositionY());
            MapController.checkIfBlockShouldFall((int)this.latestCompleteX - this.currentXToGo, (int)this.getPositionY());
            this.currentXToGo = 0;
        }
        if (this.currentMovementType == AbstractActualPlaceable.MovementType.NONE && MapController.getGameType() == NewGameMenuController.Type.EXTENDED) {
            if (this.getBlockData().getBlockType() != Block.Type.SAND && this.getBlockData().getBlockType() != Block.Type.WOOD && !this.deactivatedEffect) {
                this.checkSpecialProperties();
            }
            MapController.checkForSpecialTiles(this.getPositionX());
        }
        this.changing = false;
    }

    public void checkSpecialProperties() {
    }

    public void changeToWhiteStone() {
        super.setTexture(BlockLoader.allBlocks.get(6).getTexture());
    }
}

