/*
 * Decompiled with CFR 0.152.
 */
package com.ortisoft.ortilator.entities.blocks;

import com.ortisoft.ortilator.controllers.MapController;
import com.ortisoft.ortilator.entities.Block;
import com.ortisoft.ortilator.entities.blocks.ActualBlock;
import java.util.ArrayList;

public abstract class AbstractTwoPlayerBlock
extends ActualBlock {
    private boolean used = false;

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed() {
        this.used = true;
    }

    public AbstractTwoPlayerBlock(int id, float positionX, float positionY, float positionZ, float width, float height, Block blockData, boolean isTwoPlayers) {
        super(id, positionX, positionY, positionZ, width, height, blockData);
        if (!isTwoPlayers) {
            this.deactivatedEffect = true;
        }
    }

    @Override
    public void checkSpecialProperties() {
        if (this.deactivatedEffect || this.isUsed()) {
            return;
        }
        super.checkSpecialProperties();
        ArrayList<ActualBlock> aux = new ArrayList<ActualBlock>();
        int pos = -1;
        aux.add(this);
        ActualBlock actualBlock = MapController.getActualBlocks()[(int)this.getPositionX() + pos][(int)this.getPositionY()];
        while (actualBlock != null && actualBlock.getBlockData().getBlockType() == this.getBlockData().getBlockType() && !actualBlock.isMoving() && !((AbstractTwoPlayerBlock)actualBlock).isUsed()) {
            aux.add(actualBlock);
            actualBlock = MapController.getActualBlocks()[(int)this.getPositionX() + --pos][(int)this.getPositionY()];
        }
        pos = 1;
        actualBlock = MapController.getActualBlocks()[(int)this.getPositionX() + pos][(int)this.getPositionY()];
        while (actualBlock != null && actualBlock.getBlockData().getBlockType() == this.getBlockData().getBlockType() && !actualBlock.isMoving() && !((AbstractTwoPlayerBlock)actualBlock).isUsed()) {
            aux.add(actualBlock);
            actualBlock = MapController.getActualBlocks()[(int)this.getPositionX() + ++pos][(int)this.getPositionY()];
        }
        if (aux.size() >= 3) {
            this.doSpecialCondition(aux);
            for (ActualBlock block : aux) {
                ((AbstractTwoPlayerBlock)block).setUsed();
                block.changeToWhiteStone();
            }
            return;
        }
        aux.clear();
        aux.add(this);
        pos = 1;
        actualBlock = MapController.getActualBlocks()[(int)this.getPositionX()][(int)this.getPositionY() - pos];
        while (actualBlock != null && actualBlock.getBlockData().getBlockType() == this.getBlockData().getBlockType() && !actualBlock.isMoving() && !((AbstractTwoPlayerBlock)actualBlock).isUsed()) {
            aux.add(actualBlock);
            actualBlock = MapController.getActualBlocks()[(int)this.getPositionX()][(int)this.getPositionY() - ++pos];
        }
        if (aux.size() >= 3) {
            this.doSpecialCondition(aux);
            for (ActualBlock block : aux) {
                ((AbstractTwoPlayerBlock)block).setUsed();
                block.changeToWhiteStone();
            }
        }
    }

    protected abstract void doSpecialCondition(ArrayList<ActualBlock> var1);
}

